/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.annotation.cache.AnnotationCache;
import org.operamasks.faces.annotation.cache.ClassMetaInfo;
import org.operamasks.faces.annotation.cache.MemberMetaInfo;
import org.operamasks.faces.annotation.component.AjaxActionEvent;
import org.operamasks.faces.component.ajax.AjaxAction;
import org.operamasks.faces.component.ajax.AjaxParameter;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.event.ajax.AjaxActionSupport;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.html.HtmlRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxActionRenderer
extends AjaxRendererBase {
    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource r = ComponentResource.getResourceInstance((ResourceManager)rm);
        r.addInitScript(AjaxActionRenderer.getActionURLVarDefinition((FacesContext)context));
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc;
        ResponseWriter writer = context.getResponseWriter();
        if (writer instanceof AjaxResponseWriter) {
            ((AjaxResponseWriter)writer).setViewStateChanged();
        }
        if ((uc = PartialUpdateCandidates.getInstance()).isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer instanceof AjaxHtmlResponseWriter) {
            ((AjaxHtmlResponseWriter)writer).setViewStateChanged();
        }
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException();
        }
        UIComponent parent = component.getParent();
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            if (parent instanceof AjaxActionSupport) {
                org.operamasks.faces.event.ajax.AjaxActionEvent event = new org.operamasks.faces.event.ajax.AjaxActionEvent((AjaxAction)component, this.getAjaxParamsMap(component, paramMap));
                event = ((AjaxActionSupport)parent).getAjaxEventObject(event);
                component.queueEvent((FacesEvent)event);
            } else {
                ActionEvent event = new ActionEvent(component);
                component.queueEvent((FacesEvent)event);
            }
        }
    }

    private Map<String, Object> getAjaxParamsMap(UIComponent component, Map<String, String> requestParamsMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (UIComponent item : component.getChildren()) {
            if (!(item instanceof AjaxParameter)) continue;
            AjaxParameter para = (AjaxParameter)item;
            if (Boolean.TRUE.equals(para.getIsJsExpression())) {
                map.put(para.getName(), requestParamsMap.get(para.getName()));
                continue;
            }
            map.put(para.getName(), para.getValue());
        }
        return map;
    }

    public void attachEvent(UIComponent self, String event, UIComponent parent) {
        String userEvent;
        ValueExpression binding;
        if (event == null) {
            event = ((AjaxAction)self).getEvent();
        }
        if (parent == null) {
            parent = self.getParent();
        }
        if ((binding = parent.getValueExpression(event)) != null && binding instanceof EventHandlerGenerator) {
            ((EventHandlerGenerator)binding).setAction((AjaxAction)self);
            return;
        }
        try {
            userEvent = (String)parent.getAttributes().remove(event);
        }
        catch (IllegalArgumentException ex) {
            userEvent = (String)parent.getAttributes().get(event);
            parent.getAttributes().put(event, null);
        }
        EventHandlerGenerator ve = new EventHandlerGenerator((AjaxAction)self, userEvent);
        ve.setLiteralText(false);
        parent.setValueExpression(event, (ValueExpression)ve);
        ve.setLiteralText(true);
    }

    static /* synthetic */ String access$0() {
        return HtmlBasicRendererBase.getActionURLVar();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EventHandlerGenerator
    extends ValueExpression {
        private static final long serialVersionUID = -5718942236759049948L;
        private transient AjaxAction action;
        private String actionId;
        private String userEvent;
        private boolean isLiteralText;
        private static final Set<String> nodelayEvents = new HashSet<String>((Collection)Arrays.asList("onclick", "ondblclick", "onmouseup", "onmousedown", "onload", "onunload"));

        public EventHandlerGenerator(AjaxAction action, String userEvent) {
            this.setAction(action);
            if (userEvent != null && (userEvent = userEvent.trim()).length() != 0 && !userEvent.endsWith(";")) {
                userEvent = String.valueOf(userEvent) + ";";
            }
            this.userEvent = userEvent;
        }

        public void setAction(AjaxAction action) {
            this.action = action;
            if (action.getParent() != null && this.actionId == null) {
                this.actionId = action.getClientId(FacesContext.getCurrentInstance());
            }
        }

        public String getEventHandler() {
            block5: {
                if (this.action == null) {
                    try {
                        FacesContext ctx = FacesContext.getCurrentInstance();
                        UIComponent comp = ctx.getViewRoot().findComponent(this.actionId);
                        if (comp != null && comp instanceof AjaxAction) {
                            this.action = (AjaxAction)comp;
                            break block5;
                        }
                        return null;
                    }
                    catch (IllegalArgumentException e) {
                        return null;
                    }
                }
            }
            FacesContext context = FacesContext.getCurrentInstance();
            UIComponent cmp = this.action.getParent();
            String cmpClientId = cmp.getClientId(context);
            UIForm form = HtmlRenderer.getParentForm((UIComponent)this.action);
            String event = this.action.getEvent();
            String eventParams = this.generateEventParams(cmp, event);
            String handler = String.format("%s(%s,%s,'%s',%b,%b,'%s',%s);return true;", Aliases.getAlias((String)"OM.ajax.action"), form == null ? "null" : "'" + form.getClientId(context) + "'", form == null ? String.valueOf(Aliases.getAlias((String)"OM.SC.actionId")) + "() || " + AjaxActionRenderer.access$0() : "null", this.action.getClientId(context), this.action.isImmediate(), !nodelayEvents.contains(event), cmpClientId, eventParams != null ? eventParams : "null");
            if (this.userEvent != null) {
                handler = String.valueOf(this.userEvent) + handler;
            }
            this.actionId = this.action.getClientId(FacesContext.getCurrentInstance());
            return handler;
        }

        public Object getValue(ELContext context) {
            return this.getEventHandler();
        }

        public void setValue(ELContext context, Object value) {
            throw new PropertyNotWritableException();
        }

        public boolean isReadOnly(ELContext context) {
            return true;
        }

        public Class<?> getType(ELContext context) {
            return String.class;
        }

        public Class<?> getExpectedType() {
            return String.class;
        }

        public String getExpressionString() {
            return this.getEventHandler();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            EventHandlerGenerator other = (EventHandlerGenerator)((Object)obj);
            if (this.isLiteralText != other.isLiteralText) {
                return false;
            }
            return !(this.userEvent == null ? other.userEvent != null : !this.userEvent.equals(other.userEvent));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.isLiteralText ? 1231 : 1237);
            result = 31 * result + (this.userEvent == null ? 0 : this.userEvent.hashCode());
            return result;
        }

        public boolean isLiteralText() {
            return this.isLiteralText;
        }

        public void setLiteralText(boolean isLiteralText) {
            this.isLiteralText = isLiteralText;
        }

        private String generateEventParams(UIComponent component, String actionEvent) {
            List<String> allParams = this.getAjaxParams((UIComponent)this.action);
            allParams.addAll(this.getAnnotationParams(component, actionEvent));
            if (allParams.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder("[");
            sb.append(StringUtils.join(allParams, (String)",")).append("]");
            return sb.toString();
        }

        private List<String> getAjaxParams(UIComponent component) {
            ArrayList<String> result = new ArrayList<String>();
            for (UIComponent child : component.getChildren()) {
                AjaxParameter para;
                if (!(child instanceof AjaxParameter) || (para = (AjaxParameter)child).getName() == null || para.getValue() == null) continue;
                result.add(this.encodeParamItem(para.getName(), para.getValue().toString(), Boolean.TRUE.equals(para.getIsJsExpression())));
            }
            return result;
        }

        private List<String> getAnnotationParams(UIComponent component, String actionEvent) {
            ArrayList<String> result = new ArrayList<String>();
            if (component instanceof AjaxActionSupport) {
                Class<?> compClass = component.getClass();
                AnnotationCache cache = AnnotationCache.getInstance();
                ClassMetaInfo classMeta = cache.get(compClass);
                assert (classMeta != null);
                List fields = classMeta.getFieldsInParent(AjaxActionEvent.class);
                for (MemberMetaInfo f : fields) {
                    String[] params;
                    Field field = (Field)f.getAnnotatedMember();
                    String eventName = ((AjaxActionEvent)f.getAnnotation(AjaxActionEvent.class)).eventName();
                    if ("".equals(eventName)) {
                        eventName = field.getName();
                    }
                    if (!eventName.equals(actionEvent)) continue;
                    String[] stringArray = params = ((AjaxActionEvent)f.getAnnotation(AjaxActionEvent.class)).params();
                    int n = params.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        String[] args = s.split("=");
                        if (args != null && args.length == 2) {
                            result.add(this.encodeParamItem(args[0], args[1], true));
                        }
                        ++n2;
                    }
                }
            }
            return result;
        }

        private String encodeParamItem(String name, String value, boolean isJsExpression) {
            StringBuilder sb = new StringBuilder();
            sb.append("'").append(HtmlEncoder.enquote((String)name, null));
            sb.append("=");
            if (isJsExpression) {
                sb.append("'+");
                sb.append(Aliases.getAlias((String)"encodeURIComponent"));
                sb.append("(");
                sb.append(value);
                sb.append(")");
            } else {
                sb.append(HtmlEncoder.enquote((String)value, null));
                sb.append('\'');
            }
            return sb.toString();
        }
    }
}

