/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AjaxPhaseListener
implements PhaseListener {
    public static final String AJAX_SCRIPT_VIEW_ID = "/_global/script/ajax-script";
    public static final String LOGGING_SCRIPT_VIEW_ID = "/_global/script/logging-script";
    private static final String AJAX_SCRIPT_RESOURCE_NAME = "/META-INF/ajax.js";
    private static final String LOGGING_SCRIPT_RESOURCE_NAME = "/META-INF/logging.js";
    private final CachedScript[] cachedScripts = new CachedScript[]{new CachedScript("/_global/script/ajax-script", "/META-INF/ajax.js"), new CachedScript("/_global/script/logging-script", "/META-INF/logging.js")};

    private CachedScript getCachedScript(String viewId) {
        for (CachedScript s : this.cachedScripts) {
            if (viewId.indexOf(s.viewId) == -1) continue;
            return s;
        }
        return null;
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        CachedScript script;
        String viewId;
        FacesContext context = event.getFacesContext();
        if (context.getViewRoot() != null && (viewId = context.getViewRoot().getViewId()) != null && (script = this.getCachedScript(viewId)) != null) {
            try {
                context.responseComplete();
                this.renderScript(context, script);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderScript(FacesContext context, CachedScript script) throws IOException {
        byte[] data;
        URL url = AjaxPhaseListener.class.getResource(script.resourceName);
        long modTime = this.getLastModified(url);
        CachedScript cachedScript = script;
        synchronized (cachedScript) {
            if (script.data == null || script.lastModified != modTime) {
                script.data = this.loadScript(url);
                data = script.data;
                script.lastModified = modTime;
            } else {
                data = script.data;
            }
        }
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.setContentType("text/javascript;charset=ISO-8859-1");
        response.setContentLength(data.length);
        response.setDateHeader("Last-Modified", modTime);
        if (!"HEAD".equals(request.getMethod())) {
            ServletOutputStream out = response.getOutputStream();
            out.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadScript(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            int c;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    private long getLastModified(URL url) {
        try {
            String path;
            if (url.getProtocol().equals("file")) {
                return new File(url.getFile()).lastModified();
            }
            if ((url.getProtocol().equals("jar") || url.getProtocol().equals("wsjar")) && (path = url.getPath()).startsWith("file:") && path.indexOf("!/") != -1) {
                path = path.substring(5, path.indexOf("!/"));
                return new File(path).lastModified();
            }
            return url.openConnection().getLastModified();
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    private static final class CachedScript {
        public final String viewId;
        public final String resourceName;
        public byte[] data;
        public long lastModified;

        public CachedScript(String viewId, String resourceName) {
            this.viewId = viewId;
            this.resourceName = resourceName;
            this.data = null;
            this.lastModified = -1L;
        }
    }
}

