/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.html.FormRenderer;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxStatusRenderer
extends AjaxRendererBase {
    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        UIComponent startFacet = this.getFacet(component, "start");
        UIComponent stopFacet = this.getFacet(component, "stop");
        String clientId = component.getClientId(context);
        String startId = clientId + ".start";
        String stopId = clientId + ".stop";
        String layout = (String)component.getAttributes().get("layout");
        String tag = layout != null && layout.equals("block") ? "div" : "span";
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        if (startFacet != null) {
            String startStyle = (String)component.getAttributes().get("startStyle");
            if (startStyle == null) {
                startStyle = style;
            }
            startStyle = startStyle == null ? "display: none" : startStyle + "; display: none";
            String startStyleClass = (String)component.getAttributes().get("startStyleClass");
            if (startStyleClass == null) {
                startStyleClass = styleClass;
            }
            out.startElement(tag, component);
            out.writeAttribute("id", (Object)startId, "clientId");
            out.writeAttribute("style", (Object)startStyle, "style");
            if (startStyleClass != null) {
                out.writeAttribute("class", (Object)startStyleClass, "startStyleClass");
            }
            startFacet.encodeAll(context);
            out.endElement(tag);
        }
        if (stopFacet != null) {
            String stopStyleClass;
            String stopStyle = (String)component.getAttributes().get("stopStyle");
            if (stopStyle == null) {
                stopStyle = style;
            }
            if ((stopStyleClass = (String)component.getAttributes().get("stopStyleClass")) == null) {
                stopStyleClass = styleClass;
            }
            out.startElement(tag, component);
            out.writeAttribute("id", (Object)stopId, "clientId");
            if (stopStyle != null) {
                out.writeAttribute("style", (Object)stopStyle, "style");
            }
            if (stopStyleClass != null) {
                out.writeAttribute("class", (Object)stopStyleClass, "stopStyleClass");
            }
            stopFacet.encodeAll(context);
            out.endElement(tag);
        }
        String renderId = this.getRenderId(component);
        String onstart = (String)component.getAttributes().get("onstart");
        String onstop = (String)component.getAttributes().get("onstop");
        StringBuilder buf = new StringBuilder();
        buf.append("OM.ajax.addStatusTarget(");
        if (renderId != null) {
            buf.append(HtmlEncoder.enquote((String)renderId, (Character)Character.valueOf('\'')));
        } else {
            buf.append("null");
        }
        buf.append(",{");
        buf.append("onstart:function(){");
        if (startFacet != null) {
            buf.append("document.getElementById('");
            buf.append(startId).append("').style.display='';");
        }
        if (stopFacet != null) {
            buf.append("document.getElementById('");
            buf.append(stopId).append("').style.display='none';");
        }
        if (onstart != null) {
            buf.append(onstart);
            if (!onstart.trim().endsWith(";")) {
                buf.append(';');
            }
        }
        buf.append("},");
        buf.append("onstop:function(){");
        if (startFacet != null) {
            buf.append("document.getElementById('");
            buf.append(startId).append("').style.display='none';");
        }
        if (stopFacet != null) {
            buf.append("document.getElementById('");
            buf.append(stopId).append("').style.display='';");
        }
        if (onstop != null) {
            buf.append(onstop);
            if (!onstop.trim().endsWith(";")) {
                buf.append(';');
            }
        }
        buf.append("}");
        buf.append("});");
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        if (form != null) {
            FormRenderer.addSupportScript((UIForm)form, (String)buf.toString());
        } else {
            out.startElement("script", component);
            out.writeAttribute("type", (Object)"text/javascript", null);
            out.write(buf.toString());
            out.endElement("script");
        }
    }

    private UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        return facet != null && facet.isRendered() ? facet : null;
    }

    private String getRenderId(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof AjaxUpdater)) continue;
            return ((AjaxUpdater)parent).getRenderId();
        }
        return null;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }
}

