/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.delegate;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.component.ajax.AjaxProgress;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.component.ajax.ProgressAction;
import org.operamasks.faces.component.ajax.ProgressStatus;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxUpdaterRenderer;
import org.operamasks.faces.render.delegate.ViewDelegate;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxProgressDelegate
implements ViewDelegate {
    public void delegate(FacesContext context) throws IOException {
        ExternalContext ectx = context.getExternalContext();
        Map paramMap = ectx.getRequestParameterMap();
        String progressId = (String)paramMap.get("_AJAX_PROGRESS_POST");
        if (progressId == null) {
            return;
        }
        UIComponent component = FacesUtils.getForComponent((FacesContext)context, (String)progressId, (UIComponent)context.getViewRoot());
        if (component == null) {
            try {
                component = this.findFromUpdater(context, progressId);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (component != null && component instanceof AjaxProgress) {
            AjaxProgress progress = (AjaxProgress)component;
            String clientId = component.getClientId(context);
            String action = (String)paramMap.get(clientId);
            if (action == null || action.length() == 0) {
                return;
            }
            MethodExpression actionExpression = progress.getAction();
            if (actionExpression == null) {
                return;
            }
            ProgressStatus status = new ProgressStatus(ProgressAction.valueOf(action));
            try {
                actionExpression.invoke(context.getELContext(), new Object[]{status});
            }
            catch (ELException ex) {
                throw new FacesException((Throwable)ex);
            }
            if (status.getState() == null) {
                return;
            }
            String message = status.getMessage();
            if (message == null) {
                NumberFormat format = NumberFormat.getPercentInstance(context.getViewRoot().getLocale());
                message = format.format((double)status.getPercentage() / 100.0);
            }
            StringBuilder buf = new StringBuilder();
            buf.append(FacesUtils.getJsvar((FacesContext)context, (UIComponent)component));
            buf.append("._handleResponse({");
            buf.append("action:'").append(action).append("',");
            buf.append("state:'").append(status.getState().name()).append("',");
            buf.append("phase:").append(status.getPhase()).append(",");
            buf.append("percentage:").append(status.getPercentage()).append(",");
            buf.append("message:").append(HtmlEncoder.enquote((String)message, (Character)Character.valueOf('\'')));
            buf.append("});");
            Formatter fmt = new Formatter();
            fmt.format("Ext.onReady(function(){\n%s\n", buf.toString());
            fmt.format("});", new Object[0]);
            String script = fmt.toString();
            HttpServletResponse response = (HttpServletResponse)ectx.getResponse();
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Connection", "close");
            response.getWriter().write(script);
            context.responseComplete();
        }
    }

    public UIComponent findFromUpdater(FacesContext context, String progressId) throws IOException {
        Iterator kids = FacesUtils.createChildrenIterator((UIComponent)context.getViewRoot(), (boolean)false);
        ArrayList<AjaxUpdater> updaters = new ArrayList<AjaxUpdater>();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof AjaxUpdater)) continue;
            updaters.add((AjaxUpdater)kid);
        }
        for (AjaxUpdater updater : updaters) {
            UIComponent progress;
            if (updater.getSubviewId() == null) continue;
            AjaxUpdaterRenderer renderer = (AjaxUpdaterRenderer)FacesUtils.getRenderer((FacesContext)context, (UIComponent)updater);
            ViewHandler vh = context.getApplication().getViewHandler();
            if (vh instanceof ViewBuilder) {
                renderer.buildSubviewTree(context, (ViewBuilder)vh, updater);
            }
            if ((progress = FacesUtils.getForComponent((FacesContext)context, (String)progressId, (UIComponent)updater)) == null || !(progress instanceof AjaxProgress)) continue;
            return progress;
        }
        return null;
    }
}

