/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.delegate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Formatter;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.el.eval.closure.TargetMethodClosure;
import org.operamasks.faces.component.misc.UIFileDownload;
import org.operamasks.faces.render.delegate.ViewDelegate;
import org.operamasks.faces.util.DelegateUtils;
import org.operamasks.util.Utils;

public class FileDownloadDelegate
implements ViewDelegate {
    public void delegate(FacesContext context) throws IOException {
        ExternalContext ectx = context.getExternalContext();
        Map paramMap = ectx.getRequestParameterMap();
        String id = (String)paramMap.get("__filedownloader__");
        if (id == null) {
            return;
        }
        UIComponent component = DelegateUtils.findComponent(context, id);
        if (component != null && component instanceof UIFileDownload) {
            try {
                this.processDownload(context, (UIFileDownload)component);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
            finally {
                context.responseComplete();
            }
        }
        context.responseComplete();
    }

    private void processDownload(FacesContext context, UIFileDownload component) throws IOException {
        MethodExpression listener = component.getDownloadListener();
        Object src = component.getSrc();
        if (listener != null) {
            this.processListener(context, component, listener);
        } else if (src != null) {
            this.processSource(context, component, src);
        } else {
            throw new IllegalStateException("Download source is not specified.");
        }
    }

    private void processSource(FacesContext context, UIFileDownload component, Object src) {
        InputStream in = null;
        String targetPath = null;
        try {
            if (src != null) {
                if (src instanceof TargetMethodClosure) {
                    TargetMethodClosure m = (TargetMethodClosure)src;
                    src = m.call(context.getELContext(), new Object[0]);
                }
                if (src instanceof String) {
                    String urlStr = (String)src;
                    targetPath = urlStr = context.getApplication().getViewHandler().getResourceURL(context, urlStr);
                    if (Utils.isAbsoluteURL((String)urlStr)) {
                        in = new URL(urlStr).openStream();
                    } else {
                        if (urlStr.startsWith("/")) {
                            urlStr = urlStr.substring(urlStr.indexOf("/", 1));
                        }
                        if ((in = context.getExternalContext().getResourceAsStream(urlStr)) == null) {
                            throw new IOException("Fail to open resource " + urlStr);
                        }
                    }
                } else if (src instanceof URL) {
                    targetPath = ((URL)src).getPath();
                    in = ((URL)src).openStream();
                } else if (src instanceof InputStream) {
                    in = (InputStream)src;
                } else if (src instanceof File) {
                    targetPath = ((File)src).getPath();
                    in = new FileInputStream((File)src);
                } else if (src instanceof byte[]) {
                    in = new ByteArrayInputStream((byte[])src);
                } else {
                    throw new IllegalStateException("Invalid download source type : " + src.getClass().getName());
                }
            }
            HttpServletResponse res = this.getResponse(context, component);
            String savedName = this.getSavedName(context, component, src);
            this.setupDefaultHeader(res, savedName, component);
            ServletOutputStream out = res.getOutputStream();
            assert (in != null);
            this.writeStream(in, (OutputStream)out);
        }
        catch (IOException e) {
            this.processException(context, component, e, targetPath);
        }
    }

    private void processException(FacesContext context, UIFileDownload component, Exception e, String targetPath) {
        String onErr = component.getOnError();
        String message = null;
        message = targetPath != null ? "Resource [" + targetPath + "] not found." : "Download failed. [" + e.getMessage() + "]";
        String encoding = context.getExternalContext().getResponseCharacterEncoding();
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        if (onErr != null) {
            if (!"".equals(onErr)) {
                fmt.format("<html><script>with (parent) {(function(message){%s})('%s')};</script></html>", onErr, message);
            }
        } else {
            fmt.format("<html><script>with (parent) {alert('%s')};</script></html>", message);
        }
        ResponseStream stream = context.getResponseStream();
        try {
            stream.write(buf.toString().getBytes(encoding));
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger("org.operamasks.fileDownload");
            logger.log(Level.WARNING, "Cannot open required resource.", e);
        }
    }

    private String getSavedName(FacesContext context, UIFileDownload component, Object src) {
        String savedName = component.getSavedName();
        if (savedName == null && src != null) {
            if (src instanceof String) {
                String path = (String)src;
                savedName = this.getFileName(path);
            } else if (src instanceof File) {
                savedName = ((File)src).getName();
            } else if (src instanceof URL) {
                savedName = this.getFileName(((URL)src).getFile());
            }
        }
        if (savedName == null || savedName.length() == 0) {
            savedName = UUID.randomUUID().toString();
            savedName = savedName.replaceAll("[{}-]", "");
        }
        return savedName;
    }

    private String getFileName(String path) {
        int separatorPos = path.lastIndexOf("/");
        if (separatorPos >= 0 && separatorPos < path.length() - 1) {
            path = path.substring(separatorPos + 1);
        }
        return path;
    }

    private void processListener(FacesContext context, UIFileDownload component, MethodExpression listener) {
        HttpServletResponse res = this.getResponse(context, component);
        String savedName = this.getSavedName(context, component, null);
        this.setupDefaultHeader(res, savedName, component);
        ResponseStream out = context.getResponseStream();
        try {
            listener.invoke(context.getELContext(), new Object[]{context, out});
        }
        catch (Exception e) {
            this.processException(context, component, e, null);
        }
    }

    private HttpServletResponse getResponse(FacesContext context, UIFileDownload component) {
        HttpServletResponse httpRes = null;
        Object res = context.getExternalContext().getResponse();
        if (res != null && res instanceof HttpServletResponse) {
            httpRes = (HttpServletResponse)res;
            Long bufferSize = component.getBufferSize();
            if (bufferSize != null && bufferSize >= 0L) {
                httpRes.setBufferSize(bufferSize.intValue());
            }
            return httpRes;
        }
        throw new IllegalStateException("Download listener is only supported servlet environment");
    }

    private void setupDefaultHeader(HttpServletResponse httpRes, String savedName, UIFileDownload component) {
        String contentType = component.getContentType();
        if (contentType == null || contentType.length() == 0) {
            contentType = "application/octet-stream";
        }
        httpRes.setContentType(contentType);
        StringBuffer contentDisposition = new StringBuffer();
        contentDisposition.append("attachment;");
        try {
            savedName = new String(savedName.getBytes("gb2312"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("savedName is invalid!");
        }
        contentDisposition.append("filename=\"").append(savedName.replace("\n", ""));
        contentDisposition.append("\"");
        httpRes.setHeader("Content-Disposition", contentDisposition.toString());
    }

    private void writeStream(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = in.read(buf)) != -1) {
            out.write(buf, 0, n);
        }
        in.close();
    }
}

