/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.delegate;

import java.io.IOException;
import java.util.Formatter;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.application.StateAware;
import org.operamasks.faces.component.grid.MergedInfo;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.delegate.ViewDelegate;
import org.operamasks.faces.render.widget.helper.DataProviderHelper;
import org.operamasks.faces.util.DelegateUtils;
import org.operamasks.faces.util.StateUtils;

public class GridViewDelegate
implements ViewDelegate {
    public static final String CALLBACK_FUNCTION = "callback";

    public void delegate(FacesContext context) throws IOException {
        ExternalContext ectx = context.getExternalContext();
        Map paramMap = ectx.getRequestParameterMap();
        String gridId = (String)paramMap.get("_ajaxDataProxy_datagrid_POST");
        if (gridId == null) {
            return;
        }
        UIComponent component = DelegateUtils.findComponent(context, gridId);
        if (component != null && component instanceof UIDataGrid) {
            int rows;
            int start;
            UIDataGrid grid = (UIDataGrid)component;
            StateUtils.restoreSave((FacesContext)context, (String)grid.getId(), (StateAware)grid);
            String callback = (String)paramMap.get(CALLBACK_FUNCTION);
            String startParam = (String)paramMap.get("start");
            if (startParam != null) {
                start = Integer.parseInt(startParam);
                grid.setFirst(start);
            } else {
                start = grid.getFirst();
            }
            String limitParam = (String)paramMap.get("limit");
            if (limitParam != null) {
                rows = Integer.parseInt(limitParam);
                grid.setRows(rows);
            } else {
                rows = grid.getRows();
            }
            String script = DataProviderHelper.loadData(context, grid, start, rows);
            if (callback != null) {
                script = callback.concat("(").concat(script).concat(");");
                Formatter fmt = new Formatter();
                String clientRowsVar = grid.getClientId(context) + "_clientRows";
                String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
                fmt.format("Ext.onReady(function(){\n", new Object[0]);
                if (grid.getMerged() != null && Boolean.TRUE.equals(grid.getMerged())) {
                    if (grid.getMergedColumns() != null && grid.getMergedColumns().length > 0) {
                        fmt.format("var mergedColumnIds = new Array();", new Object[0]);
                        for (String mergedColumnId : grid.getMergedColumns()) {
                            fmt.format("mergedColumnIds.push('%s');", mergedColumnId);
                        }
                        fmt.format("OM.grid.valueAutoMerge(%s, mergedColumnIds);", FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid));
                    }
                    if (grid.getMergedInfos() != null && grid.getMergedInfos().length > 0) {
                        for (MergedInfo info : grid.getMergedInfos()) {
                            int rowStart = info.getRowStart();
                            int columnStart = info.getColumnStart();
                            int rowEnd = info.getRowEnd();
                            int columnEnd = info.getColumnEnd();
                            String label = info.getLabel();
                            if (rowStart > rowEnd) {
                                return;
                            }
                            if (columnStart > columnEnd) {
                                return;
                            }
                            fmt.format("OM.grid.freeMerge(%s, %d, %d, %d, %d, '%s');", FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid), rowStart, columnStart, rowEnd, columnEnd, label != null ? label : "");
                        }
                    }
                }
                fmt.format("\n%s\n", script);
                fmt.format("OM.ajax.removeRequestParameter('%s');\n", clientRowsVar);
                fmt.format("OM.ajax.addRequestParameter('%s', %s.getStore().getCount());\n", clientRowsVar, jsvar);
                fmt.format("});", new Object[0]);
                script = fmt.toString();
            }
            HttpServletResponse response = (HttpServletResponse)ectx.getResponse();
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Connection", "close");
            if (script != null && script.length() > 0) {
                String responseEncoding = null;
                responseEncoding = response.getCharacterEncoding();
                if (responseEncoding == null) {
                    responseEncoding = "UTF-8";
                }
                response.setHeader("Content-Length", Integer.toString(script.getBytes(responseEncoding).length));
            }
            response.getWriter().write(script);
            context.responseComplete();
        }
    }
}

