/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.imageio.ImageIO;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.component.graph.OrientationType;
import org.operamasks.faces.component.graph.PositionType;
import org.operamasks.faces.component.graph.RegressionType;
import org.operamasks.faces.component.graph.SplineType;
import org.operamasks.faces.component.graph.TimePeriodType;
import org.operamasks.faces.component.graph.UIAverageLine;
import org.operamasks.faces.component.graph.UIAxis;
import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.component.graph.UICurve;
import org.operamasks.faces.component.graph.UIDataItem;
import org.operamasks.faces.component.graph.UIDataSeries;
import org.operamasks.faces.component.graph.UILegend;
import org.operamasks.faces.component.graph.UIRegressionLine;
import org.operamasks.faces.component.graph.UISpline;
import org.operamasks.faces.component.graph.UITextAnnotation;
import org.operamasks.faces.component.graph.UITimeSeries;
import org.operamasks.faces.component.graph.UITitle;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.graph.BSpline;
import org.operamasks.faces.render.graph.ChartKeeper;
import org.operamasks.faces.render.graph.ChartRendererHelper;
import org.operamasks.faces.render.graph.ChartUtils;
import org.operamasks.faces.render.graph.CubicSpline;
import org.operamasks.faces.render.graph.CustomDrawingSupplier;
import org.operamasks.faces.render.graph.MovingAverage;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.org.jfree.chart.ChartRenderingInfo;
import org.operamasks.org.jfree.chart.JFreeChart;
import org.operamasks.org.jfree.chart.LegendItemSource;
import org.operamasks.org.jfree.chart.annotations.CategoryPointerAnnotation;
import org.operamasks.org.jfree.chart.annotations.CategoryTextAnnotation;
import org.operamasks.org.jfree.chart.annotations.XYPointerAnnotation;
import org.operamasks.org.jfree.chart.annotations.XYTextAnnotation;
import org.operamasks.org.jfree.chart.axis.Axis;
import org.operamasks.org.jfree.chart.axis.CategoryAxis;
import org.operamasks.org.jfree.chart.axis.CategoryLabelPositions;
import org.operamasks.org.jfree.chart.axis.DateAxis;
import org.operamasks.org.jfree.chart.axis.DateTickUnit;
import org.operamasks.org.jfree.chart.axis.LogarithmicAxis;
import org.operamasks.org.jfree.chart.axis.NumberAxis;
import org.operamasks.org.jfree.chart.axis.NumberTickUnit;
import org.operamasks.org.jfree.chart.axis.ValueAxis;
import org.operamasks.org.jfree.chart.block.LineBorder;
import org.operamasks.org.jfree.chart.entity.ChartEntity;
import org.operamasks.org.jfree.chart.entity.EntityCollection;
import org.operamasks.org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.operamasks.org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.operamasks.org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.operamasks.org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.Plot;
import org.operamasks.org.jfree.chart.plot.PlotOrientation;
import org.operamasks.org.jfree.chart.plot.XYPlot;
import org.operamasks.org.jfree.chart.renderer.AbstractRenderer;
import org.operamasks.org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.operamasks.org.jfree.chart.renderer.xy.XYItemRenderer;
import org.operamasks.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.operamasks.org.jfree.chart.title.LegendTitle;
import org.operamasks.org.jfree.chart.title.TextTitle;
import org.operamasks.org.jfree.chart.title.Title;
import org.operamasks.org.jfree.data.function.Function2D;
import org.operamasks.org.jfree.data.function.LineFunction2D;
import org.operamasks.org.jfree.data.function.PowerFunction2D;
import org.operamasks.org.jfree.data.statistics.Regression;
import org.operamasks.org.jfree.data.time.RegularTimePeriod;
import org.operamasks.org.jfree.data.time.TimeSeries;
import org.operamasks.org.jfree.data.time.TimeSeriesCollection;
import org.operamasks.org.jfree.data.xy.XYDataset;
import org.operamasks.org.jfree.data.xy.XYSeries;
import org.operamasks.org.jfree.data.xy.XYSeriesCollection;
import org.operamasks.org.jfree.ui.HorizontalAlignment;
import org.operamasks.org.jfree.ui.RectangleEdge;
import org.operamasks.org.jfree.ui.RectangleInsets;
import org.operamasks.org.jfree.ui.TextAnchor;
import org.operamasks.org.jfree.ui.VerticalAlignment;
import org.operamasks.resources.Resources;

public abstract class ChartRenderer
extends AjaxRendererBase {
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeChart(context, component, false);
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeChart(context, component, true);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    protected abstract JFreeChart createChart(UIChart var1);

    protected void initChart(JFreeChart chart, UIChart comp) {
        this.setChartStyles(chart, comp);
        this.setLegendStyles(chart, comp);
        this.setChartTitles(chart, comp);
        this.setChartAxes(chart, comp);
        this.createCurveSeries(chart, comp);
        this.setSeriesStyles(chart, comp);
        this.addTextAnnotations(chart, comp);
        this.setToolTipGenerator(chart, comp);
        MethodExpression init = comp.getInit();
        if (init != null) {
            ELContext context = FacesContext.getCurrentInstance().getELContext();
            init.invoke(context, new Object[]{chart});
        }
    }

    protected PlotOrientation getChartOrientation(UIChart comp) {
        if (comp.getOrientation() == OrientationType.Horizontal) {
            return PlotOrientation.HORIZONTAL;
        }
        return PlotOrientation.VERTICAL;
    }

    protected void setChartStyles(JFreeChart chart, UIChart comp) {
        Paint[] colorPalette;
        Float alpha;
        Image image;
        Plot plot = chart.getPlot();
        RectangleInsets insets = plot.getInsets();
        Double tm = comp.getTopMargin();
        Double lm = comp.getLeftMargin();
        Double bm = comp.getBottomMargin();
        Double rm = comp.getRightMargin();
        if (tm == null || tm < 0.0) {
            tm = insets.getTop();
        }
        if (lm == null || lm < 0.0) {
            lm = insets.getLeft();
        }
        if (bm == null || bm < 0.0) {
            bm = insets.getBottom();
        }
        if (rm == null || rm < 0.0) {
            rm = insets.getRight();
        }
        plot.setInsets(new RectangleInsets(tm, lm, bm, rm));
        Paint color = comp.getBackgroundColor();
        if (color != null) {
            chart.setBackgroundPaint(color);
        }
        if ((image = this.loadImage(comp.getBackgroundImage())) != null) {
            chart.setBackgroundImage(image);
            chart.setBackgroundImageAlignment(this.getImageAlign(comp.getBackgroundImagePosition()));
            chart.setBackgroundImageAlpha(comp.getBackgroundImageAlpha());
        }
        if ((color = comp.getPlotColor()) != null) {
            plot.setBackgroundPaint(color);
        }
        if ((alpha = comp.getBackgroundAlpha()) != null) {
            plot.setBackgroundAlpha(alpha.floatValue());
        }
        if ((alpha = comp.getForegroundAlpha()) != null) {
            plot.setForegroundAlpha(alpha.floatValue());
        }
        if ((image = this.loadImage(comp.getPlotImage())) != null) {
            plot.setBackgroundImage(image);
            plot.setBackgroundImageAlignment(this.getImageAlign(comp.getPlotImagePosition()));
            plot.setBackgroundImageAlpha(comp.getBackgroundImageAlpha());
        }
        if ((colorPalette = comp.getColorPalette()) != null) {
            plot.setDrawingSupplier(new CustomDrawingSupplier(colorPalette));
        } else {
            plot.setDrawingSupplier(new CustomDrawingSupplier());
        }
    }

    private Image loadImage(Object obj) {
        if (obj instanceof Image) {
            return (Image)obj;
        }
        if (obj instanceof String) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                URL url = context.getExternalContext().getResource((String)obj);
                if (url != null) {
                    return ImageIO.read(url);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private int getImageAlign(PositionType position) {
        if (position != null) {
            switch (position) {
                case Top: {
                    return 1;
                }
                case Bottom: {
                    return 2;
                }
                case Left: {
                    return 4;
                }
                case Right: {
                    return 8;
                }
                case TopLeft: {
                    return 5;
                }
                case LeftTop: {
                    return 5;
                }
                case TopRight: {
                    return 9;
                }
                case RightTop: {
                    return 9;
                }
                case BottomLeft: {
                    return 6;
                }
                case LeftBottom: {
                    return 6;
                }
                case BottomRight: {
                    return 10;
                }
                case RightBottom: {
                    return 10;
                }
                case Center: {
                    return 0;
                }
                case Stretch: {
                    return 15;
                }
            }
        }
        return 15;
    }

    protected void setChartTitles(JFreeChart chart, UIChart comp) {
        String titleText = comp.getTitle();
        if (titleText != null) {
            chart.setTitle(titleText);
        }
        for (UIComponent kid : comp.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof UITitle)) continue;
            TextTitle title = this.createTitle((UITitle)kid);
            if (chart.getTitle() == null) {
                chart.setTitle(title);
                continue;
            }
            chart.addSubtitle(title);
        }
    }

    private TextTitle createTitle(UITitle titlecomp) {
        PositionType position;
        Paint bgcolor;
        Paint color;
        FacesContext context = FacesContext.getCurrentInstance();
        String text = FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)titlecomp, (Object)titlecomp.getValue());
        TextTitle title = new TextTitle(text);
        Font font = titlecomp.getFont();
        if (font != null) {
            title.setFont(font);
        }
        if ((color = titlecomp.getColor()) != null) {
            title.setPaint(color);
        }
        if ((bgcolor = titlecomp.getBackgroundColor()) != null) {
            title.setBackgroundPaint(bgcolor);
        }
        if ((position = titlecomp.getPosition()) != null) {
            this.setTitlePosition(title, position);
        }
        return title;
    }

    private void setTitlePosition(Title title, PositionType position) {
        switch (position) {
            case Top: {
                title.setPosition(RectangleEdge.TOP);
                break;
            }
            case Bottom: {
                title.setPosition(RectangleEdge.BOTTOM);
                break;
            }
            case Left: {
                title.setPosition(RectangleEdge.LEFT);
                break;
            }
            case Right: {
                title.setPosition(RectangleEdge.RIGHT);
                break;
            }
            case TopLeft: {
                title.setPosition(RectangleEdge.TOP);
                title.setHorizontalAlignment(HorizontalAlignment.LEFT);
                break;
            }
            case TopRight: {
                title.setPosition(RectangleEdge.TOP);
                title.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                break;
            }
            case BottomLeft: {
                title.setPosition(RectangleEdge.BOTTOM);
                title.setHorizontalAlignment(HorizontalAlignment.LEFT);
                break;
            }
            case BottomRight: {
                title.setPosition(RectangleEdge.BOTTOM);
                title.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                break;
            }
            case LeftTop: {
                title.setPosition(RectangleEdge.LEFT);
                title.setVerticalAlignment(VerticalAlignment.TOP);
                break;
            }
            case LeftBottom: {
                title.setPosition(RectangleEdge.LEFT);
                title.setVerticalAlignment(VerticalAlignment.BOTTOM);
                break;
            }
            case RightTop: {
                title.setPosition(RectangleEdge.RIGHT);
                title.setVerticalAlignment(VerticalAlignment.TOP);
                break;
            }
            case RightBottom: {
                title.setPosition(RectangleEdge.RIGHT);
                title.setVerticalAlignment(VerticalAlignment.BOTTOM);
            }
        }
    }

    protected void setLegendStyles(JFreeChart chart, UIChart comp) {
        Boolean showLegend = comp.getShowLegend();
        if (showLegend != null && !showLegend.booleanValue()) {
            return;
        }
        UILegend legendcomp = comp.getLegend();
        if (legendcomp == null) {
            if (showLegend != null && showLegend.booleanValue()) {
                LegendTitle legend = new LegendTitle(chart.getPlot());
                legend.setMargin(new RectangleInsets(1.0, 1.0, 1.0, 1.0));
                legend.setFrame(new LineBorder());
                legend.setBackgroundPaint(Color.white);
                legend.setPosition(RectangleEdge.BOTTOM);
                chart.addSubtitle(legend);
            }
        } else {
            chart.addSubtitle(this.createLegend(chart, legendcomp));
        }
    }

    private LegendTitle createLegend(JFreeChart chart, UILegend legendcomp) {
        LegendTitle legend = new LegendTitle(chart.getPlot());
        PositionType position = legendcomp.getPosition();
        if (position == null) {
            legend.setPosition(RectangleEdge.BOTTOM);
        } else {
            this.setTitlePosition(legend, position);
        }
        Double tm = legendcomp.getTopMargin();
        Double lm = legendcomp.getLeftMargin();
        Double bm = legendcomp.getBottomMargin();
        Double rm = legendcomp.getRightMargin();
        if (tm == null) {
            tm = 1.0;
        }
        if (lm == null) {
            lm = 1.0;
        }
        if (bm == null) {
            bm = 1.0;
        }
        if (rm == null) {
            rm = 1.0;
        }
        legend.setMargin(new RectangleInsets(tm, lm, bm, rm));
        Paint bgcolor = legendcomp.getBackgroundColor();
        if (bgcolor != null) {
            legend.setBackgroundPaint(bgcolor);
        }
        Float borderWidth = legendcomp.getBorderWidth();
        Paint borderColor = legendcomp.getBorderColor();
        if (borderWidth != null || borderColor != null) {
            if (borderWidth == null) {
                borderWidth = Float.valueOf(1.0f);
            }
            if (borderColor == null) {
                borderColor = Color.black;
            }
            LineBorder border = new LineBorder(borderColor, new BasicStroke(borderWidth.floatValue()), new RectangleInsets(1.0, 1.0, 1.0, 1.0));
            legend.setFrame(border);
        }
        Font itemFont = legendcomp.getItemFont();
        Paint itemColor = legendcomp.getItemColor();
        if (itemFont != null) {
            legend.setItemFont(itemFont);
        }
        if (itemColor != null) {
            legend.setItemPaint(itemColor);
        }
        return legend;
    }

    protected void setChartAxes(JFreeChart chart, UIChart comp) {
        UIAxis xAxis = comp.getxAxis();
        UIAxis yAxis = comp.getyAxis();
        String xAxisLabel = comp.getxAxisLabel();
        String yAxisLabel = comp.getyAxisLabel();
        Plot plot = chart.getPlot();
        Axis domainAxis = null;
        ValueAxis rangeAxis = null;
        if (plot instanceof CategoryPlot) {
            Paint gridLineColor;
            Boolean drawGridLine;
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            if (yAxis != null && yAxis.isLogarithmic()) {
                categoryPlot.setRangeAxis(new LogarithmicAxis(null));
            }
            domainAxis = categoryPlot.getDomainAxis();
            rangeAxis = categoryPlot.getRangeAxis();
            if (xAxis != null) {
                drawGridLine = xAxis.getDrawGridLine();
                if (drawGridLine != null) {
                    categoryPlot.setDomainGridlinesVisible(drawGridLine);
                }
                if ((gridLineColor = xAxis.getGridLineColor()) != null) {
                    categoryPlot.setDomainGridlinePaint(gridLineColor);
                }
            }
            if (yAxis != null) {
                drawGridLine = yAxis.getDrawGridLine();
                if (drawGridLine != null) {
                    categoryPlot.setRangeGridlinesVisible(drawGridLine);
                }
                if ((gridLineColor = yAxis.getGridLineColor()) != null) {
                    categoryPlot.setRangeGridlinePaint(gridLineColor);
                }
            }
        } else if (plot instanceof XYPlot) {
            Paint baseLineColor;
            Boolean drawBaseLine;
            Paint gridLineColor;
            Boolean drawGridLine;
            XYPlot xyPlot = (XYPlot)plot;
            if (xAxis != null && xAxis.isLogarithmic()) {
                xyPlot.setDomainAxis(new LogarithmicAxis(null));
            }
            if (yAxis != null && yAxis.isLogarithmic()) {
                xyPlot.setRangeAxis(new LogarithmicAxis(null));
            }
            domainAxis = xyPlot.getDomainAxis();
            rangeAxis = xyPlot.getRangeAxis();
            if (xAxis != null) {
                drawGridLine = xAxis.getDrawGridLine();
                if (drawGridLine != null) {
                    xyPlot.setDomainGridlinesVisible(drawGridLine);
                }
                if ((gridLineColor = xAxis.getGridLineColor()) != null) {
                    xyPlot.setDomainGridlinePaint(gridLineColor);
                }
                if ((drawBaseLine = xAxis.getDrawBaseLine()) != null) {
                    xyPlot.setDomainZeroBaselineVisible(drawBaseLine);
                }
                if ((baseLineColor = xAxis.getBaseLineColor()) != null) {
                    xyPlot.setDomainZeroBaselinePaint(baseLineColor);
                }
            }
            if (yAxis != null) {
                drawGridLine = yAxis.getDrawGridLine();
                if (drawGridLine != null) {
                    xyPlot.setRangeGridlinesVisible(drawGridLine);
                }
                if ((gridLineColor = yAxis.getGridLineColor()) != null) {
                    xyPlot.setRangeGridlinePaint(gridLineColor);
                }
                if ((drawBaseLine = yAxis.getDrawBaseLine()) != null) {
                    xyPlot.setRangeZeroBaselineVisible(drawBaseLine);
                }
                if ((baseLineColor = yAxis.getBaseLineColor()) != null) {
                    xyPlot.setRangeZeroBaselinePaint(baseLineColor);
                }
            }
        }
        if (domainAxis != null) {
            if (xAxisLabel != null) {
                domainAxis.setLabel(xAxisLabel);
            }
            if (xAxis != null) {
                this.setAxisStyles(domainAxis, xAxis);
            }
        }
        if (rangeAxis != null) {
            if (yAxisLabel != null) {
                rangeAxis.setLabel(yAxisLabel);
            }
            if (yAxis != null) {
                this.setAxisStyles(rangeAxis, yAxis);
            }
        }
    }

    protected void setAxisStyles(Axis axis, UIAxis comp) {
        axis.setVisible(comp.isVisible());
        axis.setAxisLineVisible(comp.isDrawLine());
        axis.setTickLabelsVisible(comp.isDrawTickLabels());
        axis.setTickMarksVisible(comp.isDrawTickMarks());
        String label = comp.getLabel();
        Font labelFont = comp.getLabelFont();
        Paint labelColor = comp.getLabelColor();
        Paint lineColor = comp.getLineColor();
        Font tickLabelFont = comp.getTickLabelFont();
        Paint tickLabelColor = comp.getTickLabelColor();
        Paint tickMarkColor = comp.getTickMarkColor();
        if (label != null) {
            axis.setLabel(label);
        }
        if (labelFont != null) {
            axis.setLabelFont(labelFont);
        }
        if (labelColor != null) {
            axis.setLabelPaint(labelColor);
        }
        if (lineColor != null) {
            axis.setAxisLinePaint(lineColor);
        }
        if (tickLabelFont != null) {
            axis.setTickLabelFont(tickLabelFont);
        }
        if (tickLabelColor != null) {
            axis.setTickLabelPaint(tickLabelColor);
        }
        if (tickMarkColor != null) {
            axis.setTickMarkPaint(tickMarkColor);
        }
        axis.setTickMarkInsideLength(comp.getTickMarkInsideLength());
        axis.setTickMarkOutsideLength(comp.getTickMarkOutsideLength());
        if (axis instanceof CategoryAxis) {
            this.setCategoryAxisStyles((CategoryAxis)axis, comp);
        } else if (axis instanceof DateAxis) {
            this.setDateAxisStyles((DateAxis)axis, comp);
        } else if (axis instanceof NumberAxis) {
            this.setNumberAxisStyles((NumberAxis)axis, comp);
        }
    }

    private void setCategoryAxisStyles(CategoryAxis axis, UIAxis comp) {
        Double labelAngle;
        Double lowerMargin = comp.getLowerMargin();
        Double upperMargin = comp.getUpperMargin();
        if (lowerMargin != null) {
            axis.setLowerMargin(lowerMargin);
        }
        if (upperMargin != null) {
            axis.setUpperMargin(upperMargin);
        }
        if ((labelAngle = comp.getLabelAngle()) != null) {
            double angle = Math.PI * labelAngle / 180.0;
            CategoryLabelPositions clp = angle >= 0.0 ? CategoryLabelPositions.createDownRotationLabelPositions(angle) : CategoryLabelPositions.createUpRotationLabelPositions(-angle);
            axis.setCategoryLabelPositions(clp);
        }
    }

    private void setDateAxisStyles(DateAxis axis, UIAxis comp) {
        UIDataSeries data = ((UIChart)comp.getParent()).getDataSeries();
        if (!(data instanceof UITimeSeries)) {
            return;
        }
        UITimeSeries ts = (UITimeSeries)data;
        axis.setInverted(comp.isInverted());
        Object lowerBound = comp.getLowerBound();
        Object upperBound = comp.getUpperBound();
        Double lowerMargin = comp.getLowerMargin();
        Double upperMargin = comp.getUpperMargin();
        if (lowerBound != null) {
            axis.setLowerBound(ChartRendererHelper.getTimePeriodValue(ts, lowerBound));
        }
        if (upperBound != null) {
            axis.setUpperBound(ChartRendererHelper.getTimePeriodValue(ts, upperBound));
        }
        if (lowerMargin != null) {
            axis.setLowerMargin(lowerMargin);
        }
        if (upperMargin != null) {
            axis.setUpperMargin(upperMargin);
        }
        Double tickStep = comp.getTickStep();
        String tickFormat = comp.getTickLabelFormat();
        int dateTickUnit = 0;
        int dateTickStep = 0;
        if (tickStep != null) {
            dateTickStep = tickStep.intValue();
            TimePeriodType tp = comp.getTickUnit();
            if (tp == null) {
                tp = ts.getTimePeriod();
            }
            switch (tp) {
                case Year: {
                    dateTickUnit = 0;
                    break;
                }
                case Quarter: {
                    dateTickUnit = 1;
                    dateTickStep *= 4;
                    break;
                }
                case Month: {
                    dateTickUnit = 1;
                    break;
                }
                case Week: {
                    dateTickUnit = 2;
                    dateTickStep *= 7;
                    break;
                }
                case Day: {
                    dateTickUnit = 2;
                    break;
                }
                case Hour: {
                    dateTickUnit = 3;
                    break;
                }
                case Minute: {
                    dateTickUnit = 4;
                    break;
                }
                case Second: {
                    dateTickUnit = 5;
                    break;
                }
                case Millisecond: {
                    dateTickUnit = 6;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (tickStep != null && tickStep > 0.0 || tickFormat != null) {
            SimpleDateFormat format;
            if (tickFormat == null) {
                axis.setTickUnit(new DateTickUnit(dateTickUnit, dateTickStep));
            } else if (tickStep == null) {
                format = new SimpleDateFormat(tickFormat);
                axis.setDateFormatOverride(format);
            } else {
                format = new SimpleDateFormat(tickFormat);
                axis.setTickUnit(new DateTickUnit(dateTickUnit, dateTickStep, format));
            }
        }
    }

    private void setNumberAxisStyles(NumberAxis axis, UIAxis comp) {
        axis.setInverted(comp.isInverted());
        Object lowerBound = comp.getLowerBound();
        Object upperBound = comp.getUpperBound();
        Double lowerMargin = comp.getLowerMargin();
        Double upperMargin = comp.getUpperMargin();
        if (lowerBound != null) {
            axis.setLowerBound(TypeCoercion.coerceToDouble((Object)lowerBound));
        }
        if (upperBound != null) {
            axis.setUpperBound(TypeCoercion.coerceToDouble((Object)upperBound));
        }
        if (lowerMargin != null) {
            axis.setLowerMargin(lowerMargin);
        }
        if (upperMargin != null) {
            axis.setUpperMargin(upperMargin);
        }
        Double tickStep = comp.getTickStep();
        String tickFormat = comp.getTickLabelFormat();
        if (tickStep != null && tickStep > 0.0 || tickFormat != null) {
            if (tickFormat == null) {
                axis.setTickUnit(new NumberTickUnit(tickStep));
            } else if (tickStep == null) {
                DecimalFormat format = new DecimalFormat(tickFormat);
                axis.setNumberFormatOverride(format);
            } else {
                DecimalFormat format = new DecimalFormat(tickFormat);
                axis.setTickUnit(new NumberTickUnit(tickStep, format));
            }
        }
    }

    protected void createCurveSeries(JFreeChart chart, UIChart comp) {
        UIDataSeries data = comp.getDataSeries();
        if (data == null) {
            return;
        }
        if (!(chart.getPlot() instanceof XYPlot)) {
            return;
        }
        XYPlot plot = (XYPlot)chart.getPlot();
        XYDataset dataset = plot.getDataset();
        if (dataset.getSeriesCount() == 0) {
            return;
        }
        UIDataItem[] items = data.getItems();
        XYSeriesCollection collection = null;
        XYLineAndShapeRenderer renderer = null;
        int curSeries = 0;
        for (int i = 0; i < items.length; ++i) {
            if (dataset.getItemCount(i) < 2) continue;
            for (UIComponent kid : items[i].getChildren()) {
                Paint color;
                if (!kid.isRendered() || !(kid instanceof UICurve)) continue;
                UICurve curve = (UICurve)kid;
                XYSeries series = this.createCurveSeries(curve, dataset, i);
                if (collection == null) {
                    collection = new XYSeriesCollection();
                    renderer = new XYLineAndShapeRenderer(true, false);
                }
                collection.addSeries(series);
                String legend = curve.getLegend();
                if (legend == null || legend.length() == 0) {
                    renderer.setSeriesVisibleInLegend(curSeries, (Boolean)false);
                }
                if ((color = curve.getColor()) != null) {
                    renderer.setSeriesPaint(curSeries, color);
                }
                ++curSeries;
            }
        }
        if (collection != null) {
            plot.setDataset(1, collection);
            plot.setRenderer(1, renderer);
        }
    }

    private XYSeries createCurveSeries(UICurve curve, XYDataset data, int index) {
        if (data.getItemCount(index) < 2) {
            throw new IllegalArgumentException("Not enough data");
        }
        ChartRendererHelper.Key key = new ChartRendererHelper.Key(index, curve.getLegend());
        if (curve instanceof UIAverageLine) {
            double period = ((UIAverageLine)curve).getPeriod();
            double skip = ((UIAverageLine)curve).getSkip();
            if (data instanceof TimeSeriesCollection) {
                TimeSeries ts = ((TimeSeriesCollection)data).getSeries(index);
                return MovingAverage.createMovingAverage(ts, key, (int)period, (int)skip);
            }
            return MovingAverage.createMovingAverage(data, index, key, period, skip);
        }
        if (curve instanceof UIRegressionLine) {
            RegressionType type = ((UIRegressionLine)curve).getType();
            int samples = ((UIRegressionLine)curve).getSamples();
            if (type == null || type == RegressionType.Linear) {
                double[] p = Regression.getOLSRegression(data, index);
                LineFunction2D f = new LineFunction2D(p[0], p[1]);
                return this.createFunctionSeries(data, index, key, f, samples);
            }
            if (type == RegressionType.Power) {
                double[] p = Regression.getPowerRegression(data, index);
                PowerFunction2D f = new PowerFunction2D(p[0], p[1]);
                return this.createFunctionSeries(data, index, key, f, samples);
            }
            throw new IllegalArgumentException(type.toString());
        }
        if (curve instanceof UISpline) {
            SplineType type = ((UISpline)curve).getType();
            int samples = ((UISpline)curve).getSamples();
            int degree = ((UISpline)curve).getDegree();
            if (type == null || type == SplineType.BSpline) {
                return BSpline.createBSpline(data, index, key, samples, degree);
            }
            if (type == SplineType.CubicSpline) {
                return CubicSpline.createCubicSpline(data, index, key, samples);
            }
        }
        return null;
    }

    private XYSeries createFunctionSeries(XYDataset data, int index, ChartRendererHelper.Key key, Function2D f, int samples) {
        XYSeries series = new XYSeries(key);
        double start = data.getXValue(index, 0);
        double end = data.getXValue(index, data.getItemCount(index) - 1);
        double step = (end - start) / (double)samples;
        for (int i = 0; i < samples; ++i) {
            double x = start + step * (double)i;
            series.add(x, f.getValue(x));
        }
        return series;
    }

    protected void setSeriesStyles(JFreeChart chart, UIChart comp) {
        UIDataSeries data = comp.getDataSeries();
        if (data == null) {
            return;
        }
        Plot plot = chart.getPlot();
        AbstractRenderer renderer = null;
        if (plot instanceof CategoryPlot) {
            renderer = (AbstractRenderer)((Object)((CategoryPlot)plot).getRenderer());
        } else if (plot instanceof XYPlot) {
            renderer = (AbstractRenderer)((Object)((XYPlot)plot).getRenderer());
        }
        if (renderer != null) {
            Font itemLabelFont;
            Paint itemLabelColor;
            if (comp.isDrawItemLabel()) {
                LegendItemSource r;
                renderer.setBaseItemLabelsVisible(true);
                if (renderer instanceof CategoryItemRenderer) {
                    r = (CategoryItemRenderer)((Object)renderer);
                    r.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator());
                } else if (renderer instanceof XYItemRenderer) {
                    r = (XYItemRenderer)((Object)renderer);
                    r.setBaseItemLabelGenerator(new StandardXYItemLabelGenerator());
                }
            }
            if ((itemLabelColor = comp.getItemLabelColor()) != null) {
                renderer.setBaseItemLabelPaint(itemLabelColor);
            }
            if ((itemLabelFont = comp.getItemLabelFont()) != null) {
                renderer.setBaseItemLabelFont(itemLabelFont);
            }
            UIDataItem[] items = data.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.setSeriesStyles(renderer, comp, i, items[i]);
            }
        }
    }

    protected void setSeriesStyles(AbstractRenderer renderer, UIChart comp, int index, UIDataItem item) {
        Font itemLabelFont;
        Paint itemLabelColor;
        Paint outlineColor;
        Paint color;
        if (!item.isShowLegend() || item.getLegend() == null) {
            renderer.setSeriesVisibleInLegend(index, (Boolean)false);
        }
        if ((color = item.getColor()) != null) {
            renderer.setSeriesPaint(index, color);
        }
        if ((outlineColor = item.getOutlineColor()) == null && (outlineColor = comp.getOutlineColor()) == null && (outlineColor = renderer.getSeriesPaint(index)) instanceof Color) {
            outlineColor = ((Color)outlineColor).darker();
        }
        renderer.setSeriesOutlinePaint(index, outlineColor);
        Boolean drawItemLabel = item.getDrawItemLabel();
        if (drawItemLabel != null) {
            renderer.setSeriesItemLabelsVisible(index, drawItemLabel);
            if (drawItemLabel.booleanValue()) {
                LegendItemSource r;
                if (renderer instanceof CategoryItemRenderer) {
                    r = (CategoryItemRenderer)((Object)renderer);
                    if (r.getBaseItemLabelGenerator() == null) {
                        r.setSeriesItemLabelGenerator(index, new StandardCategoryItemLabelGenerator());
                    }
                } else if (renderer instanceof XYItemRenderer && (r = (XYItemRenderer)((Object)renderer)).getBaseItemLabelGenerator() == null) {
                    r.setSeriesItemLabelGenerator(index, new StandardXYItemLabelGenerator());
                }
            }
        }
        if ((itemLabelColor = item.getItemLabelColor()) != null) {
            renderer.setSeriesItemLabelPaint(index, itemLabelColor);
        }
        if ((itemLabelFont = item.getItemLabelFont()) != null) {
            renderer.setSeriesItemLabelFont(index, itemLabelFont);
        }
    }

    protected void addTextAnnotations(JFreeChart chart, UIChart comp) {
        Plot plot = chart.getPlot();
        if (plot instanceof CategoryPlot) {
            this.addCategoryTextAnnotations(chart, comp);
        } else if (plot instanceof XYPlot) {
            this.addXYTextAnnotations(chart, comp);
        }
    }

    private void addCategoryTextAnnotations(JFreeChart chart, UIChart comp) {
        UIDataSeries data = comp.getDataSeries();
        if (data == null) {
            return;
        }
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        for (UIComponent kid : comp.getChildren()) {
            CategoryTextAnnotation a;
            UITextAnnotation at;
            ChartRendererHelper.Key key;
            if (!kid.isRendered() || !(kid instanceof UITextAnnotation) || (key = ChartRendererHelper.getCategoryKey(data, (at = (UITextAnnotation)kid).getxValue())) == null || (a = this.createCategoryTextAnnotation(at, key)) == null) continue;
            plot.addAnnotation(a);
        }
    }

    private void addXYTextAnnotations(JFreeChart chart, UIChart comp) {
        XYPlot plot = (XYPlot)chart.getPlot();
        UIDataSeries data = comp.getDataSeries();
        if (data instanceof UITimeSeries) {
            Class timePeriodClass = ChartRendererHelper.getTimePeriodClass(((UITimeSeries)data).getTimePeriod());
            for (UIComponent kid : comp.getChildren()) {
                XYTextAnnotation a;
                if (!kid.isRendered() || !(kid instanceof UITextAnnotation) || (a = this.createTimeSeriesTextAnnotation((UITextAnnotation)kid, timePeriodClass)) == null) continue;
                plot.addAnnotation(a);
            }
        } else {
            for (UIComponent kid : comp.getChildren()) {
                XYTextAnnotation a;
                if (!kid.isRendered() || !(kid instanceof UITextAnnotation) || (a = this.createXYTextAnnotation((UITextAnnotation)kid)) == null) continue;
                plot.addAnnotation(a);
            }
        }
    }

    private CategoryTextAnnotation createCategoryTextAnnotation(UITextAnnotation at, Comparable key) {
        Double rotationAngle;
        TextAnchor anchor;
        Paint color;
        CategoryTextAnnotation result;
        String label = at.getText();
        double value = TypeCoercion.coerceToDouble((Object)at.getyValue());
        if (at.isDrawArrow()) {
            Paint arrowColor;
            Double angle = at.getArrowAngle();
            if (angle == null) {
                angle = 0.0;
            }
            CategoryPointerAnnotation pointer = new CategoryPointerAnnotation(label, key, value, angle * Math.PI / 180.0);
            Double length = at.getArrowLength();
            if (length != null) {
                pointer.setBaseRadius(length);
            }
            if ((arrowColor = at.getArrowColor()) == null) {
                arrowColor = at.getColor();
            }
            if (arrowColor != null) {
                pointer.setArrowPaint(arrowColor);
            }
            result = pointer;
        } else {
            result = new CategoryTextAnnotation(label, key, value);
        }
        Font font = at.getFont();
        if (font != null) {
            result.setFont(font);
        }
        if ((color = at.getColor()) != null) {
            result.setPaint(color);
        }
        if ((anchor = this.getTextAnchor(at.getAnchor())) != null) {
            result.setTextAnchor(anchor);
        }
        if ((rotationAngle = at.getRotationAngle()) != null) {
            result.setRotationAngle(rotationAngle * Math.PI / 180.0);
        }
        return result;
    }

    private XYTextAnnotation createXYTextAnnotation(UITextAnnotation at) {
        double x = TypeCoercion.coerceToDouble((Object)at.getxValue());
        double y = TypeCoercion.coerceToDouble((Object)at.getyValue());
        return this.createXYTextAnnotation(at, x, y);
    }

    private XYTextAnnotation createTimeSeriesTextAnnotation(UITextAnnotation at, Class timePeriodClass) {
        Date time = ChartUtils.convertDate(at.getxValue());
        if (time == null) {
            return null;
        }
        RegularTimePeriod timePeriod = RegularTimePeriod.createInstance(timePeriodClass, time, RegularTimePeriod.DEFAULT_TIME_ZONE);
        double x = timePeriod.getFirstMillisecond();
        double y = TypeCoercion.coerceToDouble((Object)at.getyValue());
        return this.createXYTextAnnotation(at, x, y);
    }

    private XYTextAnnotation createXYTextAnnotation(UITextAnnotation at, double x, double y) {
        Double rotationAngle;
        TextAnchor anchor;
        Paint color;
        XYTextAnnotation result;
        if (at.isDrawArrow()) {
            Paint arrowColor;
            Double angle = at.getArrowAngle();
            if (angle == null) {
                angle = 0.0;
            }
            XYPointerAnnotation pointer = new XYPointerAnnotation(at.getText(), x, y, angle * Math.PI / 180.0);
            Double length = at.getArrowLength();
            if (length != null) {
                pointer.setBaseRadius(length);
            }
            if ((arrowColor = at.getArrowColor()) == null) {
                arrowColor = at.getColor();
            }
            if (arrowColor != null) {
                pointer.setArrowPaint(arrowColor);
            }
            result = pointer;
        } else {
            result = new XYTextAnnotation(at.getText(), x, y);
        }
        Font font = at.getFont();
        if (font != null) {
            result.setFont(font);
        }
        if ((color = at.getColor()) != null) {
            result.setPaint(color);
        }
        if ((anchor = this.getTextAnchor(at.getAnchor())) != null) {
            result.setTextAnchor(anchor);
        }
        if ((rotationAngle = at.getRotationAngle()) != null) {
            result.setRotationAngle(rotationAngle * Math.PI / 180.0);
        }
        return result;
    }

    private TextAnchor getTextAnchor(PositionType position) {
        if (position != null) {
            switch (position) {
                case Left: {
                    return TextAnchor.CENTER_LEFT;
                }
                case Right: {
                    return TextAnchor.CENTER_RIGHT;
                }
                case Top: {
                    return TextAnchor.TOP_CENTER;
                }
                case Bottom: {
                    return TextAnchor.BOTTOM_CENTER;
                }
                case TopLeft: {
                    return TextAnchor.TOP_LEFT;
                }
                case TopRight: {
                    return TextAnchor.TOP_RIGHT;
                }
                case BottomLeft: {
                    return TextAnchor.BOTTOM_LEFT;
                }
                case BottomRight: {
                    return TextAnchor.BOTTOM_RIGHT;
                }
                case LeftTop: {
                    return TextAnchor.TOP_LEFT;
                }
                case LeftBottom: {
                    return TextAnchor.BOTTOM_LEFT;
                }
                case RightTop: {
                    return TextAnchor.TOP_RIGHT;
                }
                case RightBottom: {
                    return TextAnchor.BOTTOM_RIGHT;
                }
                case Center: {
                    return TextAnchor.CENTER;
                }
                case Stretch: {
                    return TextAnchor.CENTER;
                }
            }
        }
        return null;
    }

    protected void setToolTipGenerator(JFreeChart chart, UIChart comp) {
        if (!comp.isShowItemTips()) {
            return;
        }
        Plot plot = chart.getPlot();
        if (plot instanceof CategoryPlot) {
            this.setCategoryToolTipGenerator((CategoryPlot)plot, comp);
        } else if (plot instanceof XYPlot) {
            this.setXYToolTipGenerator((XYPlot)plot, comp);
        }
    }

    private void setCategoryToolTipGenerator(CategoryPlot plot, UIChart comp) {
        UIAxis axis = comp.getyAxis();
        NumberFormat format = axis != null && axis.getItemTipFormat() != null ? new DecimalFormat(axis.getItemTipFormat()) : NumberFormat.getInstance();
        plot.getRenderer().setToolTipGenerator(new StandardCategoryToolTipGenerator("<h3>{1}</h3>{0} = {2}", format));
    }

    private void setXYToolTipGenerator(XYPlot plot, UIChart comp) {
        String yLabel;
        UIAxis xAxis = comp.getxAxis();
        UIAxis yAxis = comp.getyAxis();
        String xLabel = comp.getxAxisLabel();
        if (xLabel == null && xAxis != null) {
            xLabel = xAxis.getLabel();
        }
        if ((yLabel = comp.getyAxisLabel()) == null && yAxis != null) {
            yLabel = yAxis.getLabel();
        }
        String labelFormat = xLabel != null && yLabel != null ? String.format("<h3>{0}</h3>%s: {1}<br/>%s: {2}", xLabel, yLabel) : "<h3>{0}</h3>({1}, {2})";
        if (comp.getDataSeries() instanceof UITimeSeries) {
            DateFormat xfmt = xAxis != null && xAxis.getItemTipFormat() != null ? new SimpleDateFormat(xAxis.getItemTipFormat()) : DateFormat.getInstance();
            NumberFormat yfmt = yAxis != null && yAxis.getItemTipFormat() != null ? new DecimalFormat(yAxis.getItemTipFormat()) : NumberFormat.getInstance();
            plot.getRenderer().setToolTipGenerator(new StandardXYToolTipGenerator(labelFormat, xfmt, yfmt));
        } else {
            NumberFormat xfmt = xAxis != null && xAxis.getItemTipFormat() != null ? new DecimalFormat(xAxis.getItemTipFormat()) : NumberFormat.getInstance();
            NumberFormat yfmt = yAxis != null && yAxis.getItemTipFormat() != null ? new DecimalFormat(yAxis.getItemTipFormat()) : NumberFormat.getInstance();
            plot.getRenderer().setToolTipGenerator(new StandardXYToolTipGenerator(labelFormat, xfmt, yfmt));
        }
    }

    protected void encodeChart(FacesContext context, UIComponent component, boolean isAjax) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIChart c = (UIChart)component;
        JFreeChart chart = this.createChart(c);
        if (chart == null) {
            throw new FacesException(Resources._T((String)"UI_CHART_INCOMPATIBLE_DATA_SERIES"));
        }
        this.initChart(chart, c);
        this.encodeChartImage(context, c, chart, isAjax);
    }

    protected void encodeChartImage(FacesContext context, UIChart component, JFreeChart chart, boolean isAjax) throws IOException {
        int width = component.getWidth();
        int height = component.getHeight();
        ChartRenderingInfo info = null;
        if (component.isShowItemTips()) {
            info = new ChartRenderingInfo();
        }
        BufferedImage image = chart.createBufferedImage(width, height, info);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", stream);
        byte[] data = stream.toByteArray();
        ChartKeeper keeper = ChartKeeper.getInstance(context);
        String filename = keeper.save(data, ".png");
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        String url = rm.getServiceResourceURL("chart", filename);
        if (isAjax) {
            AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
            out.writeAttributeScript(component.getClientId(context), "src", (Object)url);
        } else {
            ResponseWriter out = context.getResponseWriter();
            out.startElement("img", (UIComponent)component);
            out.writeAttribute("id", (Object)component.getClientId(context), "clientId");
            out.writeURIAttribute("src", (Object)url, null);
            RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
            out.endElement("img");
        }
        if (info != null) {
            this.encodeItemTips(context, component, info, isAjax);
        }
    }

    private void encodeItemTips(FacesContext context, UIChart comp, ChartRenderingInfo info, boolean isAjax) throws IOException {
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        StringBuilder buf = new StringBuilder();
        buf.append("Ext.om.AreaTips.init();\n");
        buf.append("Ext.om.AreaTips.register({");
        buf.append("target:'").append(comp.getClientId(context)).append("'");
        buf.append(",trackMouse:true");
        buf.append(",areas:[");
        EntityCollection entities = info.getEntityCollection();
        Iterator it = entities.iterator();
        while (it.hasNext()) {
            ChartEntity entity = (ChartEntity)it.next();
            String tooltip = entity.getToolTipText();
            if (tooltip == null) continue;
            buf.append("{");
            buf.append("shape:'").append(entity.getShapeType()).append("'");
            buf.append(",coords:[").append(entity.getShapeCoords()).append("]");
            buf.append(",text:").append(HtmlEncoder.enquote((String)tooltip));
            buf.append("},");
        }
        if (buf.charAt(buf.length() - 1) == ',') {
            buf.setLength(buf.length() - 1);
        }
        buf.append("]});\n");
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[]{"Ext.om.AreaTips"});
        resource.addInitScript(buf.toString());
    }
}

