/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.graph.UIAxis;
import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.graph.ChartRenderer;
import org.operamasks.org.jfree.chart.JFreeChart;
import org.operamasks.org.jfree.chart.axis.ValueAxis;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.DatasetRenderingOrder;
import org.operamasks.org.jfree.chart.plot.Plot;
import org.operamasks.org.jfree.chart.plot.XYPlot;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.general.Dataset;
import org.operamasks.org.jfree.data.time.TimeSeriesCollection;
import org.operamasks.org.jfree.data.xy.XYDataset;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeChartRenderer
extends ChartRenderer {
    @Override
    protected void encodeChart(FacesContext context, UIComponent component, boolean isAjax) throws IOException {
        Class type;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIChart c = (UIChart)component;
        List<UIChart> kids = this.getSubchartComponents(c);
        List<JFreeChart> subcharts = this.createSubcharts(context, kids);
        if (subcharts.size() == 0) {
            return;
        }
        JFreeChart compositeChart = subcharts.size() == 1 ? subcharts.get(0) : (XYDataset.class.isAssignableFrom(type = this.getComonDatasetType(subcharts)) ? this.createXYCompositeChart(subcharts, c) : this.createCategoryCompositeChart(subcharts, c));
        this.initChart(compositeChart, c);
        for (int i = 0; i < subcharts.size(); ++i) {
            UIChart kid = kids.get(i);
            JFreeChart subchart = subcharts.get(i);
            ChartRenderer cr = (ChartRenderer)FacesUtils.getRenderer((FacesContext)context, (UIComponent)kid);
            cr.initChart(subchart, kid);
        }
        this.encodeChartImage(context, c, compositeChart, isAjax);
    }

    @Override
    protected JFreeChart createChart(UIChart comp) {
        throw new AssertionError();
    }

    private List<UIChart> getSubchartComponents(UIChart comp) {
        ArrayList<UIChart> result = new ArrayList<UIChart>();
        for (UIComponent kid : comp.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof UIChart)) continue;
            result.add((UIChart)kid);
        }
        return result;
    }

    private List<JFreeChart> createSubcharts(FacesContext context, List<UIChart> kids) {
        ArrayList<JFreeChart> result = new ArrayList<JFreeChart>(kids.size());
        for (UIChart kid : kids) {
            ChartRenderer cr = (ChartRenderer)FacesUtils.getRenderer((FacesContext)context, (UIComponent)kid);
            result.add(cr.createChart(kid));
        }
        return result;
    }

    private Class getComonDatasetType(List<JFreeChart> subcharts) {
        Class<CategoryDataset> commonType = null;
        for (JFreeChart c : subcharts) {
            Dataset ds;
            Plot plot = c.getPlot();
            Class type = null;
            if (plot instanceof CategoryPlot) {
                ds = ((CategoryPlot)plot).getDataset();
                type = CategoryDataset.class;
            } else if (plot instanceof XYPlot) {
                ds = ((XYPlot)plot).getDataset();
                type = ds instanceof TimeSeriesCollection ? TimeSeriesCollection.class : XYDataset.class;
            }
            if (type != null && commonType == null) {
                commonType = type;
                continue;
            }
            if (type != null && type == commonType) continue;
            throw new FacesException(Resources._T((String)"UI_CHART_INCOMPATIBLE_COMMON_DATA_SERIES"));
        }
        return commonType;
    }

    private JFreeChart createCategoryCompositeChart(List<JFreeChart> subcharts, UIChart comp) {
        CategoryPlot compositePlot = new CategoryPlot();
        compositePlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        compositePlot.setOrientation(this.getChartOrientation(comp));
        for (int i = 0; i < subcharts.size(); ++i) {
            CategoryPlot subplot = (CategoryPlot)subcharts.get(i).getPlot();
            compositePlot.setDataset(i, subplot.getDataset());
            compositePlot.setRenderer(i, subplot.getRenderer());
            if (i == 0) {
                compositePlot.setDomainAxis(0, subplot.getDomainAxis());
                compositePlot.setRangeAxis(0, subplot.getRangeAxis());
                continue;
            }
            int yAxisMap = this.getRangeAxisMap(comp, i);
            ValueAxis yAxis = null;
            if (yAxisMap == -1) {
                yAxisMap = 0;
            } else if (yAxisMap == i) {
                yAxis = subplot.getRangeAxis();
            }
            compositePlot.setRangeAxis(i, yAxis);
            compositePlot.mapDatasetToRangeAxis(i, yAxisMap);
        }
        return new JFreeChart(null, null, compositePlot, false);
    }

    private JFreeChart createXYCompositeChart(List<JFreeChart> subcharts, UIChart comp) {
        XYPlot compositePlot = new XYPlot();
        compositePlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        compositePlot.setOrientation(this.getChartOrientation(comp));
        for (int i = 0; i < subcharts.size(); ++i) {
            XYPlot subplot = (XYPlot)subcharts.get(i).getPlot();
            compositePlot.setDataset(i, subplot.getDataset());
            compositePlot.setRenderer(i, subplot.getRenderer());
            if (i == 0) {
                compositePlot.setDomainAxis(0, subplot.getDomainAxis());
                compositePlot.setRangeAxis(0, subplot.getRangeAxis());
                continue;
            }
            int yAxisMap = this.getRangeAxisMap(comp, i);
            ValueAxis yAxis = null;
            if (yAxisMap == -1) {
                yAxisMap = 0;
            } else if (yAxisMap == i) {
                yAxis = subplot.getRangeAxis();
            }
            compositePlot.setRangeAxis(i, yAxis);
            compositePlot.mapDatasetToRangeAxis(i, yAxisMap);
        }
        return new JFreeChart(null, null, compositePlot, false);
    }

    private int getRangeAxisMap(UIChart comp, int index) {
        UIChart subcomp = this.getSubchartComponent(comp, index);
        int yAxisMap = -1;
        if (subcomp != null) {
            String mapId;
            UIAxis yAxis = subcomp.getyAxis();
            if (yAxis != null && (mapId = (String)yAxis.getAttributes().get("mapTo")) != null) {
                yAxisMap = this.getSubchartIndexById(comp, mapId);
            }
            if (yAxisMap == -1 && (yAxis != null || subcomp.getyAxisLabel() != null)) {
                yAxisMap = index;
            }
        }
        return yAxisMap;
    }

    private UIChart getSubchartComponent(UIChart parent, int index) {
        for (UIComponent kid : parent.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof UIChart)) continue;
            if (index == 0) {
                return (UIChart)kid;
            }
            --index;
        }
        return null;
    }

    private int getSubchartIndexById(UIChart parent, String id) {
        int index = 0;
        for (UIComponent kid : parent.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof UIChart)) continue;
            if (kid.getId().equals(id)) {
                return index;
            }
            ++index;
        }
        return index;
    }
}

