/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import org.operamasks.org.jfree.data.function.Function2D;

public class CubicSplineFunction2D
implements Function2D {
    private int count;
    private double[] x;
    private double[] y;
    private double[] s;
    private double[] dy;

    public CubicSplineFunction2D(double[][] data) {
        this(data, data.length);
    }

    public CubicSplineFunction2D(double[][] data, int count) {
        this.count = count;
        this.x = new double[count];
        this.y = new double[count];
        for (int i = 0; i < count; ++i) {
            this.x[i] = data[i][0];
            this.y[i] = data[i][1];
        }
        this.s = new double[count];
        this.dy = new double[count];
        this.init(this.x, this.y, this.s, this.dy);
    }

    private void init(double[] x, double[] y, double[] s, double[] dy) {
        int j;
        int n = this.count;
        dy[0] = 0.0;
        s[0] = 0.0;
        double h0 = x[1] - x[0];
        for (j = 1; j < n - 2; ++j) {
            double h1 = x[j + 1] - x[j];
            double alpha = h0 / (h0 + h1);
            double beta = (1.0 - alpha) * (y[j] - y[j - 1]) / h0;
            beta = 3.0 * (beta + alpha * (y[j + 1] - y[j]) / h1);
            dy[j] = -alpha / (2.0 + (1.0 - alpha) * dy[j - 1]);
            s[j] = beta - (1.0 - alpha) * s[j - 1];
            s[j] = s[j] / (2.0 + (1.0 - alpha) * dy[j - 1]);
            h0 = h1;
        }
        for (j = n - 2; j >= 0; --j) {
            dy[j] = dy[j] * dy[j + 1] + s[j];
        }
        for (j = 0; j <= n - 2; ++j) {
            s[j] = x[j + 1] - x[j];
        }
    }

    public double getValue(double t) {
        int i;
        double[] x = this.x;
        double[] y = this.y;
        double[] s = this.s;
        double[] dy = this.dy;
        int n = this.count;
        if (t >= x[n - 1]) {
            i = n - 2;
        } else {
            i = 0;
            while (t > x[i + 1]) {
                ++i;
            }
        }
        double h1 = (x[i + 1] - t) / s[i];
        double h0 = h1 * h1;
        double z = (3.0 * h0 - 2.0 * h0 * h1) * y[i] + s[i] * (h0 - h0 * h1) * dy[i];
        h1 = (t - x[i]) / s[i];
        h0 = h1 * h1;
        z = z + (3.0 * h0 - 2.0 * h0 * h1) * y[i + 1] - s[i] * (h0 - h0 * h1) * dy[i + 1];
        return z;
    }
}

