/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.operamasks.faces.render.graph.CubicSplineFunction2D;
import org.operamasks.org.jfree.chart.axis.CategoryAxis;
import org.operamasks.org.jfree.chart.axis.ValueAxis;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.PlotOrientation;
import org.operamasks.org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.operamasks.org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.ui.RectangleEdge;

public class CurveAndShapeRenderer
extends LineAndShapeRenderer {
    private static final long serialVersionUID = 9064746373505112666L;
    private boolean drawArea;

    public CurveAndShapeRenderer() {
    }

    public CurveAndShapeRenderer(boolean lines, boolean shapes) {
        super(lines, shapes);
    }

    public boolean getDrawArea() {
        return this.drawArea;
    }

    public void setDrawArea(boolean drawArea) {
        this.drawArea = drawArea;
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (pass == 0) {
            if (row == 0 && column == 0) {
                int seriesCount = dataset.getRowCount();
                for (int series = 0; series < seriesCount; ++series) {
                    this.drawSeriesCurve(g2, dataArea, plot, domainAxis, rangeAxis, dataset, series);
                }
            }
        } else {
            super.drawItem(g2, state, dataArea, plot, domainAxis, rangeAxis, dataset, row, column, pass);
        }
    }

    private void drawSeriesCurve(Graphics2D g2, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int series) {
        double x;
        if (!this.getItemVisible(series, 0) || !this.getItemLineVisible(series, 0) && !this.drawArea) {
            return;
        }
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        PlotOrientation orientation = plot.getOrientation();
        int itemCount = dataset.getColumnCount();
        double[][] points = new double[itemCount][2];
        int count = 0;
        for (int i = 0; i < itemCount; ++i) {
            Number value = dataset.getValue(series, i);
            if (value == null) continue;
            points[count][0] = domainAxis.getCategoryMiddle(i, itemCount, dataArea, xAxisLocation);
            points[count][1] = rangeAxis.valueToJava2D(value.doubleValue(), dataArea, yAxisLocation);
            ++count;
        }
        if (count < 2) {
            return;
        }
        CubicSplineFunction2D f = new CubicSplineFunction2D(points, count);
        GeneralPath path = new GeneralPath();
        double startX = points[0][0];
        double startY = points[0][1];
        double endX = points[count - 1][0];
        double endY = points[count - 1][1];
        double yz = rangeAxis.valueToJava2D(0.0, dataArea, yAxisLocation);
        if (orientation == PlotOrientation.HORIZONTAL) {
            if (this.drawArea) {
                path.moveTo((float)yz, (float)startX);
                path.lineTo((float)startY, (float)startX);
                for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                    path.lineTo((float)f.getValue(x), (float)x);
                }
                path.lineTo((float)endY, (float)endX);
                path.lineTo((float)yz, (float)endX);
                path.closePath();
            } else {
                path.moveTo((float)startY, (float)startX);
                for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                    path.lineTo((float)f.getValue(x), (float)x);
                }
                path.lineTo((float)endY, (float)endX);
            }
        } else if (this.drawArea) {
            path.moveTo((float)startX, (float)yz);
            path.lineTo((float)startX, (float)startY);
            for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                path.lineTo((float)x, (float)f.getValue(x));
            }
            path.lineTo((float)endX, (float)endY);
            path.lineTo((float)endX, (float)yz);
            path.closePath();
        } else {
            path.moveTo((float)startX, (float)startY);
            for (x = Math.floor(startX) + 1.0; x < endX; x += 1.0) {
                path.lineTo((float)x, (float)f.getValue(x));
            }
            path.lineTo((float)endX, (float)endY);
        }
        Paint paint = this.getSeriesPaint(series);
        Stroke stroke = this.getSeriesStroke(series);
        if (this.drawArea) {
            g2.setPaint(paint);
            g2.fill(path);
            if (paint instanceof Color) {
                paint = ((Color)paint).darker();
            } else if (paint instanceof GradientPaint) {
                paint = ((GradientPaint)paint).getColor1().darker();
            }
        }
        if (this.getItemLineVisible(series, 0)) {
            g2.setPaint(paint);
            g2.setStroke(stroke);
            g2.draw(path);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.drawArea ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurveAndShapeRenderer other = (CurveAndShapeRenderer)obj;
        return this.drawArea == other.drawArea;
    }
}

