/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Stroke;
import org.operamasks.faces.component.graph.LineStyleType;
import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.component.graph.UIDataItem;
import org.operamasks.faces.render.graph.ChartRenderer;
import org.operamasks.faces.render.graph.ChartRendererHelper;
import org.operamasks.org.jfree.chart.ChartFactory;
import org.operamasks.org.jfree.chart.JFreeChart;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.Plot;
import org.operamasks.org.jfree.chart.plot.XYPlot;
import org.operamasks.org.jfree.chart.renderer.AbstractRenderer;
import org.operamasks.org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.operamasks.org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.operamasks.org.jfree.chart.renderer.category.LineRenderer3D;
import org.operamasks.org.jfree.chart.renderer.xy.XYItemRenderer;
import org.operamasks.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.general.Dataset;
import org.operamasks.org.jfree.data.time.TimeSeriesCollection;
import org.operamasks.org.jfree.data.xy.XYDataset;

public class LineChartRenderer
extends ChartRenderer {
    protected JFreeChart createChart(UIChart comp) {
        Dataset dataset = ChartRendererHelper.createDataset(comp);
        JFreeChart chart = null;
        if (dataset instanceof CategoryDataset) {
            chart = comp.isEffect3D() ? ChartFactory.createLineChart3D(null, null, null, (CategoryDataset)dataset, this.getChartOrientation(comp), false, false, false) : ChartFactory.createLineChart(null, null, null, (CategoryDataset)dataset, this.getChartOrientation(comp), false, false, false);
        } else if (dataset instanceof TimeSeriesCollection) {
            chart = ChartFactory.createTimeSeriesChart(null, null, null, (XYDataset)dataset, false, false, false);
            ((XYPlot)chart.getPlot()).setOrientation(this.getChartOrientation(comp));
        } else if (dataset instanceof XYDataset) {
            chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)dataset, this.getChartOrientation(comp), false, false, false);
        }
        return chart;
    }

    protected void setSeriesStyles(JFreeChart chart, UIChart comp) {
        XYItemRenderer r;
        Plot plot = chart.getPlot();
        if (plot instanceof CategoryPlot) {
            CategoryItemRenderer r2 = ((CategoryPlot)plot).getRenderer();
            if (r2 instanceof LineAndShapeRenderer) {
                this.setLineStyles((LineAndShapeRenderer)r2, comp);
            }
        } else if (plot instanceof XYPlot && (r = ((XYPlot)plot).getRenderer()) instanceof XYLineAndShapeRenderer) {
            this.setLineStyles((XYLineAndShapeRenderer)r, comp);
        }
        super.setSeriesStyles(chart, comp);
    }

    protected void setSeriesStyles(AbstractRenderer renderer, UIChart comp, int index, UIDataItem item) {
        super.setSeriesStyles(renderer, comp, index, item);
        if (renderer instanceof LineAndShapeRenderer) {
            this.setSeriesLineStyles((LineAndShapeRenderer)renderer, comp, index, item);
        } else if (renderer instanceof XYLineAndShapeRenderer) {
            this.setSeriesLineStyles((XYLineAndShapeRenderer)renderer, comp, index, item);
        }
    }

    private void setLineStyles(LineAndShapeRenderer renderer, UIChart comp) {
        Boolean fillMarkers;
        Boolean drawMarkers;
        Boolean drawLines = comp.getDrawLines();
        if (drawLines != null) {
            renderer.setBaseLinesVisible(drawLines);
        }
        if ((drawMarkers = comp.getDrawMarkers()) != null) {
            renderer.setBaseShapesVisible(drawMarkers);
        }
        if ((fillMarkers = comp.getFillMarkers()) != null) {
            renderer.setBaseShapesFilled(fillMarkers);
        }
        renderer.setUseFillPaint(true);
        Boolean drawOutline = comp.getDrawOutline();
        if (drawOutline != null) {
            renderer.setDrawOutlines(drawOutline);
        } else if (renderer instanceof LineRenderer3D) {
            renderer.setDrawOutlines(false);
        }
        renderer.setUseOutlinePaint(true);
    }

    private void setSeriesLineStyles(LineAndShapeRenderer renderer, UIChart comp, int index, UIDataItem item) {
        Paint markerFillColor;
        Boolean fillMarkers;
        Boolean drawMarkers;
        Boolean drawLines = item.getDrawLines();
        if (drawLines != null) {
            renderer.setSeriesLinesVisible(index, drawLines);
        }
        Float lineWidth = item.getLineWidth();
        LineStyleType lineStyle = item.getLineStyle();
        if (lineWidth == null) {
            lineWidth = comp.getLineWidth();
        }
        if (lineStyle == null) {
            lineStyle = comp.getLineStyle();
        }
        if (lineWidth != null || lineStyle != null) {
            if (lineWidth == null) {
                lineWidth = Float.valueOf(1.0f);
            }
            renderer.setSeriesStroke(index, this.createLineStroke(lineWidth.floatValue(), lineStyle));
        }
        if ((drawMarkers = item.getDrawMarkers()) != null) {
            renderer.setSeriesShapesVisible(index, drawMarkers);
        }
        if ((fillMarkers = item.getFillMarkers()) != null) {
            renderer.setSeriesShapesFilled(index, fillMarkers);
        }
        if ((markerFillColor = item.getMarkerFillColor()) == null && (markerFillColor = comp.getMarkerFillColor()) == null) {
            markerFillColor = renderer.getSeriesPaint(index);
        }
        renderer.setSeriesFillPaint(index, markerFillColor);
    }

    private void setLineStyles(XYLineAndShapeRenderer renderer, UIChart comp) {
        Boolean fillMarkers;
        Boolean drawMarkers;
        Boolean drawLines = comp.getDrawLines();
        if (drawLines != null) {
            renderer.setBaseLinesVisible(drawLines);
        }
        if ((drawMarkers = comp.getDrawMarkers()) != null) {
            renderer.setBaseShapesVisible(drawMarkers);
        }
        if ((fillMarkers = comp.getFillMarkers()) != null) {
            renderer.setBaseShapesFilled(fillMarkers);
        }
        renderer.setUseFillPaint(true);
        Boolean drawOutline = comp.getDrawOutline();
        if (drawOutline != null) {
            renderer.setDrawOutlines(drawOutline);
        }
        renderer.setUseOutlinePaint(true);
    }

    private void setSeriesLineStyles(XYLineAndShapeRenderer renderer, UIChart comp, int index, UIDataItem item) {
        Paint markerFillColor;
        Boolean fillMarkers;
        Boolean drawMarkers;
        Boolean drawLines = item.getDrawLines();
        if (drawLines != null) {
            renderer.setSeriesLinesVisible(index, drawLines);
        }
        Float lineWidth = item.getLineWidth();
        LineStyleType lineStyle = item.getLineStyle();
        if (lineWidth == null) {
            lineWidth = comp.getLineWidth();
        }
        if (lineStyle == null) {
            lineStyle = comp.getLineStyle();
        }
        if (lineWidth != null || lineStyle != null) {
            if (lineWidth == null) {
                lineWidth = Float.valueOf(1.0f);
            }
            renderer.setSeriesStroke(index, this.createLineStroke(lineWidth.floatValue(), lineStyle));
        }
        if ((drawMarkers = item.getDrawMarkers()) != null) {
            renderer.setSeriesShapesVisible(index, drawMarkers);
        }
        if ((fillMarkers = item.getFillMarkers()) != null) {
            renderer.setSeriesShapesFilled(index, fillMarkers);
        }
        if ((markerFillColor = item.getMarkerFillColor()) == null && (markerFillColor = comp.getMarkerFillColor()) == null) {
            markerFillColor = renderer.getSeriesPaint(index);
        }
        renderer.setSeriesFillPaint(index, markerFillColor);
    }

    private Stroke createLineStroke(float width, LineStyleType style) {
        if (style == null || style == LineStyleType.Solid) {
            return new BasicStroke(width);
        }
        float[] dash = null;
        if (style == LineStyleType.Dot) {
            dash = new float[]{width * 2.0f};
        } else if (style == LineStyleType.Dash) {
            dash = new float[]{width * 8.0f, width * 2.0f};
        } else if (style == LineStyleType.DashDot) {
            dash = new float[]{width * 8.0f, width * 2.0f, width * 2.0f, width * 2.0f};
        } else if (style == LineStyleType.DashDotDot) {
            dash = new float[]{width * 8.0f, width * 2.0f, width * 2.0f, width * 2.0f, width * 2.0f, width * 2.0f};
        }
        return new BasicStroke(width, 0, 2, 0.0f, dash, 0.0f);
    }
}

