/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.graph;

import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.component.graph.UIChart;
import org.operamasks.faces.render.graph.ChartRenderer;
import org.operamasks.faces.render.graph.ChartRendererHelper;
import org.operamasks.org.jfree.chart.ChartFactory;
import org.operamasks.org.jfree.chart.JFreeChart;
import org.operamasks.org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.operamasks.org.jfree.chart.plot.MultiplePiePlot;
import org.operamasks.org.jfree.chart.plot.PiePlot;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.category.CategoryToPieDataset;
import org.operamasks.org.jfree.data.general.Dataset;
import org.operamasks.org.jfree.util.TableOrder;

public class PieChartRenderer
extends ChartRenderer {
    protected JFreeChart createChart(UIChart comp) {
        Dataset dataset = ChartRendererHelper.createDataset(comp);
        JFreeChart chart = null;
        PiePlot pieplot = null;
        boolean ring = TypeCoercion.coerceToBoolean(comp.getAttributes().get("ring"));
        if (dataset instanceof CategoryDataset) {
            CategoryDataset catset = (CategoryDataset)dataset;
            if (catset.getRowCount() == 1) {
                CategoryToPieDataset pieset = new CategoryToPieDataset(catset, TableOrder.BY_ROW, 0);
                chart = ring ? ChartFactory.createRingChart(null, pieset, false, false, false) : (comp.isEffect3D() ? ChartFactory.createPieChart3D(null, pieset, false, false, false) : ChartFactory.createPieChart(null, pieset, false, false, false));
                pieplot = (PiePlot)chart.getPlot();
            } else {
                chart = comp.isEffect3D() ? ChartFactory.createMultiplePieChart3D(null, catset, TableOrder.BY_ROW, false, false, false) : ChartFactory.createMultiplePieChart(null, catset, TableOrder.BY_ROW, false, false, false);
                pieplot = (PiePlot)((MultiplePiePlot)chart.getPlot()).getPieChart().getPlot();
            }
        }
        if (pieplot != null) {
            Object startAngle;
            if (!comp.isDrawItemLabel()) {
                pieplot.setLabelGenerator(null);
            }
            if (comp.isShowItemTips()) {
                pieplot.setToolTipGenerator(new StandardPieToolTipGenerator());
            }
            if ((startAngle = comp.getAttributes().get("startAngle")) != null) {
                pieplot.setStartAngle(TypeCoercion.coerceToDouble(startAngle));
            }
        }
        return chart;
    }
}

