/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.AjaxActionEventHandler;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxCommandButtonRenderer
extends AjaxRendererBase
implements ToolBarItemRenderer {
    private static Map<String, LiteAttributeEncoder> liteAttr = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttr);

    public AjaxCommandButtonRenderer() {
        liteAttr.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Boolean disabled = (Boolean)component.getAttributes().get("disabled");
                if (disabled != null) {
                    if (disabled.booleanValue()) {
                        out.writeScriptBlock(jsvar + ".disable();");
                    } else {
                        out.writeScriptBlock(jsvar + ".enable();");
                    }
                }
            }
        });
        liteAttr.put("image", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Object obj = component.getAttributes().get("image");
                Formatter fmt = new Formatter();
                fmt.format("var %s_el = %s.getEl();\n", jsvar, jsvar);
                fmt.format("var %s_button = %s.getEl().select('button').first();\n", jsvar, jsvar);
                if (obj == null) {
                    fmt.format("%s_el.removeClass('x-btn-text-icon');\n", jsvar);
                    fmt.format("%s_button.removeClass('x-btn-text-icon');\n", jsvar);
                    fmt.format("%s_button.applyStyles('background-image: none;');\n", jsvar);
                } else {
                    fmt.format("%s_el.addClass('x-btn-text-icon');\n", jsvar);
                    fmt.format("%s_button.addClass('x-btn-text-icon');\n", jsvar);
                    fmt.format("%s_button.applyStyles('background-image: url(%s);');\n", jsvar, obj.toString());
                }
                out.writeScriptBlock(fmt.toString());
            }
        });
        liteAttr.put("value", null);
        liteAttr.put("label", null);
    }

    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly((UIComponent)component)) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(context))) {
            ActionEvent event = new ActionEvent(component);
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeInitHtml(context, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.Button"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String jsvar = FacesUtils.getJsvar((FacesContext)FacesContext.getCurrentInstance(), (UIComponent)component);
        resource.addVariable(jsvar);
        StringBuilder buf = new StringBuilder();
        this.encodeButton(buf, component, jsvar);
        this.encodeOnclick(buf, component, Aliases.getVar((String)jsvar));
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Init script of " + FacesUtils.getComponentDesc((UIComponent)component) + " with id " + component.getId() + " is encoded as [" + buf.toString() + "]");
        }
        resource.addInitScript(buf.toString());
        resource.releaseVariable(jsvar);
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        if (uc.isUpdateValue(component) && (FacesUtils.isDynamicValue((UIComponent)component, (String)"value") || FacesUtils.isDynamicValue((UIComponent)component, (String)"label"))) {
            String text = HtmlEncoder.enquote((String)this.getText(context, component), (Character)Character.valueOf('\''));
            out.writeScriptBlock(jsvar + ".setText(" + text + ");");
        }
        Set attributes = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attributes, liteAttributes);
    }

    public boolean isRepaintable(UIComponent component) {
        UIComponent p;
        for (p = component.getParent(); p != null && !(p instanceof ToolBar); p = p.getParent()) {
        }
        if (p != null) {
            log.fine("Skipped repainting of button [" + component.getId() + "] which is in a toolbar.");
            return false;
        }
        return true;
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    protected void encodeOnclick(StringBuilder buf, UIComponent component, String jsvar) {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        String onclick = (String)component.getAttributes().get("onclick");
        if (onclick != null) {
            if ((onclick = onclick.trim()).length() == 0) {
                onclick = null;
            } else if (!onclick.endsWith(";")) {
                onclick = onclick + ";";
            }
        }
        Formatter fmt = new Formatter(buf);
        Object alwaysSubmit = component.getAttributes().get("alwaysSubmit");
        if (form != null && (alwaysSubmit == null || Boolean.parseBoolean(alwaysSubmit.toString()))) {
            fmt.format("%s.on('click', function(){", jsvar);
            if (onclick != null) {
                fmt.format("if (function(){%s}.apply(this)==false)return;", onclick);
            }
            buf.append(RendererUtils.encodeAjaxSubmit((FacesContext)context, (UIComponent)component, (String)jsvar, (String[])new String[]{HtmlEncoder.enquote((String)clientId), HtmlEncoder.enquote((String)"")}));
            buf.append("});\n");
        } else if (onclick != null) {
            fmt.format("%s.on('click',function(){%s});\n", jsvar, onclick);
        }
        Object allowReEnter = component.getAttributes().get("allowReEnter");
        fmt.format("%s.allowReEnter=", jsvar);
        if (allowReEnter != null && Boolean.parseBoolean(allowReEnter.toString())) {
            buf.append("true;");
        } else {
            buf.append("false;");
        }
    }

    public String getToolBarItemAddScript(FacesContext context, UIComponent component, String jsvar) {
        StringBuilder script = new StringBuilder();
        Formatter fmt = new Formatter(script);
        fmt.format("%s.add(%s);\n", jsvar, this.getToolBarItemAddElement(context, component));
        return script.toString();
    }

    public String getToolBarItemAddElement(FacesContext context, UIComponent item) {
        return Aliases.getVar((String)FacesUtils.getJsvar((FacesContext)context, (UIComponent)item));
    }

    public String getToolBarItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        String jsVar = resource.allocVariable(component);
        StringBuilder script = new StringBuilder();
        Formatter fmt = new Formatter(script);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("button");
        script.append(RendererUtils.getJsvarAliasDef((String)jsVar, (Aliases)alias));
        fmt.format("%s=new %s(%s{", jsVar, alias.alias("Ext.Toolbar.Button"), c.start());
        jsVar = alias.var(jsVar);
        ExtConfig extConfig = this.buildExtConfig(context, component);
        CompRendererUtils.mergeUserExtConfig(component, extConfig);
        script.append(extConfig.toScript(c));
        fmt.format("}%s);", c.end());
        ResponseWriter out = context.getResponseWriter();
        if (out instanceof AjaxHtmlResponseWriter) {
            this.encodeOnclick(script, component, jsVar);
        } else {
            this.encodeAjaxOnclick(script, component, jsVar);
        }
        return script.toString();
    }

    public boolean ignoreChildren() {
        return true;
    }

    protected void encodeButton(StringBuilder buf, UIComponent component, String jsvar) {
        FacesContext context = FacesContext.getCurrentInstance();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("button");
        fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.Button"), c.start());
        ExtConfig extConfig = this.buildExtConfig(context, component);
        extConfig.set("renderTo", component.getClientId(context));
        CompRendererUtils.mergeUserExtConfig(component, extConfig);
        buf.append(extConfig.toScript(c));
        fmt.format("}%s);", c.end());
    }

    protected ExtConfig buildExtConfig(FacesContext context, UIComponent component) {
        String type;
        ExtConfig extConfig = new ExtConfig();
        String text = this.getText(context, component);
        String tooltip = (String)component.getAttributes().get("tooltip");
        Object disabled = component.getAttributes().get("disabled");
        Object minWidth = component.getAttributes().get("minWidth");
        Object width = component.getAttributes().get("width");
        String cls = (String)component.getAttributes().get("cls");
        String style = (String)component.getAttributes().get("style");
        String icon = RendererUtils.getIcon((UIComponent)component);
        extConfig.set("text", text);
        if (tooltip != null) {
            extConfig.set("tooltip", tooltip);
        }
        if (disabled != null) {
            extConfig.set("disabled", disabled);
        }
        if (minWidth != null) {
            extConfig.set("minWidth", minWidth);
        }
        if (width != null) {
            extConfig.set("minWidth", width);
        }
        if (icon != null) {
            extConfig.set("icon", icon);
            extConfig.set("iconCls", "x-btn-text-icon");
        }
        if (cls != null) {
            extConfig.set("cls", cls);
        }
        if ((type = (String)component.getAttributes().get("type")) != null) {
            extConfig.set("type", type);
            if ("reset".equals(type)) {
                Boolean alwaysSubmit = (Boolean)component.getAttributes().get("alwaysSubmit");
                if (alwaysSubmit == null || alwaysSubmit.booleanValue()) {
                    extConfig.set("alwaysSubmit", true);
                }
                extConfig.set("plugins", "new OM.Ext.ButtonPlugin()", true);
            }
        }
        if (style != null) {
            extConfig.set("style", style);
        }
        return extConfig;
    }

    protected String getText(FacesContext context, UIComponent component) {
        String text = (String)component.getAttributes().get("label");
        if (text == null) {
            Object value = ((UICommand)component).getValue();
            text = value != null ? value.toString() : FacesUtils.encodeComponentChildren((FacesContext)context, (UIComponent)component);
        }
        return text;
    }

    protected String getHiddenFieldName(FacesContext context, UIComponent component) {
        String result = null;
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        if (form != null) {
            result = form.getClientId(context) + ':' + "_link";
        }
        return result;
    }

    private void encodeAjaxOnclick(StringBuilder buf, UIComponent component, String jsvar) {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        String onclick = (String)component.getAttributes().get("onclick");
        if (onclick != null) {
            if ((onclick = onclick.trim()).length() == 0) {
                onclick = null;
            } else if (!onclick.endsWith(";")) {
                onclick = onclick + ";";
            }
        }
        Formatter fmt = new Formatter(buf);
        Object alwaysSubmit = component.getAttributes().get("alwaysSubmit");
        if (form != null && (alwaysSubmit == null || Boolean.parseBoolean(alwaysSubmit.toString()))) {
            fmt.format("%s.on('click', function(){", jsvar);
            if (onclick != null) {
                fmt.format("if (function(){%s}.apply(this)==false)return;", onclick);
            }
            buf.append(RendererUtils.encodeAjaxSubmit((FacesContext)context, (UIComponent)component, (String)jsvar, (String[])new String[]{HtmlEncoder.enquote((String)clientId), HtmlEncoder.enquote((String)"")}));
            buf.append("});\n");
        } else if (onclick != null) {
            fmt.format("%s.on('click',function(){%s});\n", jsvar, onclick);
        }
        AjaxActionEventHandler handler = new AjaxActionEventHandler(component);
        fmt.format("%s", handler.toScript());
    }

    private void encodeInitHtml(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("span", component);
        out.writeAttribute("id", (Object)component.getClientId(context), "clientId");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"disabled,onclick,style");
        out.endElement("span");
    }
}

