/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.CommandLinkRenderer;
import org.operamasks.faces.render.widget.helper.CommandLinkRenderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxCommandLinkRenderer
extends AjaxRendererBase {
    protected CommandLinkRenderer delegate = new CommandLinkRenderer();
    private static Map<String, LiteAttributeEncoder> LITE_ATTRIBUTES = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(RendererUtils.HTML_LITE_ATTRIBUTES){
        {
            this.put("type", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    out.writeAttributeScript(component.getClientId(context), "type", component.getAttributes().get("type"));
                }
            });
            this.put("target", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    if (!RendererUtils.isDisabled((UIComponent)component)) {
                        String target = (String)component.getAttributes().get("target");
                        String href = (String)component.getAttributes().get("href");
                        if (target != null && href != null) {
                            out.writeAttributeScript(component.getClientId(context), "target", (Object)target);
                        }
                    }
                }
            });
            this.put("href", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    String target = (String)component.getAttributes().get("target");
                    String href = (String)component.getAttributes().get("href");
                    if (target != null && href != null) {
                        out.writeAttributeScript(component.getClientId(context), "href", (Object)href);
                    } else {
                        out.writeAttributeScript(component.getClientId(context), "href", (Object)"#");
                    }
                }
            });
            this.put("onclick", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    UIForm form = FacesUtils.getParentForm((UIComponent)component);
                    String target = (String)component.getAttributes().get("target");
                    String href = (String)component.getAttributes().get("href");
                    boolean doReturn = true;
                    if (target != null && href != null) {
                        doReturn = false;
                    }
                    String onclick = CommandLinkRenderHelper.getOnclickScript(context, form, component, doReturn);
                    out.writeAttributeScript(component.getClientId(context), "onclick", (Object)onclick);
                }
            });
            this.remove("disabled");
        }
    });

    public void decode(FacesContext context, UIComponent component) {
        this.delegate.decode(context, component);
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (this.isDisabledDynamicly(component)) {
            this.renderAjaxHtmlBegin(context, component);
        }
        this.renderLink(context, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeHtmlChildren(context, component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeHtmlEnd(context, component);
        if (this.isDisabledDynamicly(component)) {
            this.renderAjaxHtmlEnd(context);
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        if (FacesUtils.getParentForm((UIComponent)component) == null && FacesUtils.isTransientStateSupported((FacesContext)context)) {
            out.setViewStateChanged(false);
        }
        if (uc.isUpdateValue(component)) {
            Object value;
            String label = null;
            if (component instanceof UICommand && (value = ((UICommand)component).getValue()) != null) {
                label = value.toString();
            }
            if (label != null) {
                out.writeInnerHtmlScript(component.getClientId(context), label);
            }
            uc.getAttributeCandidates(component).remove("value");
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    private void renderAjaxHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("span", null);
        out.writeAttribute("id", (Object)this.getOuterClientId(context, component), null);
        out.write("");
    }

    private void renderAjaxHtmlEnd(FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("span");
    }

    private String getOuterClientId(FacesContext context, UIComponent component) {
        String clientId = component.getClientId(context);
        return String.valueOf(clientId) + ':' + "_outer";
    }

    private boolean isDisabledDynamicly(UIComponent component) {
        ValueExpression ve = component.getValueExpression("disabled");
        if (ve != null) {
            return !ve.isLiteralText();
        }
        return component.getValueExpression("binding") != null;
    }

    protected void renderLink(FacesContext context, UIComponent component) throws IOException {
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        if (RendererUtils.isDisabled((UIComponent)component)) {
            this.renderDisabledLink(context, component);
        } else if (form != null) {
            this.renderActiveLink(context, form, component);
        } else if (FacesUtils.isTransientStateSupported((FacesContext)context)) {
            this.renderSingleLink(context, component);
        }
    }

    protected void renderSingleLink(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        if (out instanceof AjaxHtmlResponseWriter) {
            ((AjaxHtmlResponseWriter)out).setViewStateChanged(false);
        } else if (out instanceof AjaxResponseWriter) {
            ((AjaxResponseWriter)out).setViewStateChanged(false);
        }
        this.renderActiveLink(context, null, component);
    }

    protected void renderActiveLink(FacesContext context, UIForm form, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String target = (String)component.getAttributes().get("target");
        String href = (String)component.getAttributes().get("href");
        String type = (String)component.getAttributes().get("type");
        String style = (String)component.getAttributes().get("style");
        boolean doReturn = true;
        out.startElement("a", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        if (target != null && href != null) {
            out.writeAttribute("href", (Object)href, "href");
            out.writeAttribute("target", (Object)target, "target");
            doReturn = false;
        } else if (StringUtils.isEmpty((String)style)) {
            out.writeAttribute("style", (Object)"cursor:pointer", null);
        } else {
            out.writeAttribute("style", (Object)("cursor:pointer;" + style), null);
        }
        String onclick = CommandLinkRenderHelper.getOnclickScript(context, form, component, doReturn);
        out.writeAttribute("onclick", (Object)onclick, "onclick");
        if (type != null) {
            out.writeAttribute("type", (Object)type, "type");
        }
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"disabled,onclick,target");
    }

    protected void renderDisabledLink(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String type = (String)component.getAttributes().get("type");
        out.startElement("span", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        if (type != null) {
            out.writeAttribute("type", (Object)type, "type");
        }
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"disabled");
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return LITE_ATTRIBUTES;
    }
}

