/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.FormRenderer;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxFormRenderer
extends AjaxRendererBase {
    private static final String CLIENT_VALIDATE_PARAM = "org.operamasks.faces.CLIENT_VALIDATE";
    private FormRenderer delegate = new FormRenderer();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(RendererUtils.HTML_LITE_ATTRIBUTES){
        {
            this.put("title", null);
            this.put("styleClass", null);
            this.put("style", AjaxStyleEncoder.getInstance());
        }
    });

    public void decode(FacesContext context, UIComponent component) {
        String postback = FormRenderer.getPostbackFieldName((FacesContext)context, (UIComponent)component);
        if (context.getExternalContext().getRequestParameterMap().containsKey(postback)) {
            ((UIForm)component).setSubmitted(true);
            PartialUpdateCandidates.getInstance().markSubmitForm(component);
        } else {
            ((UIForm)component).setSubmitted(false);
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        this.delegate.encodeHtmlBegin(context, component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        String renderId = this.getRenderId(component);
        ResponseWriter out = context.getResponseWriter();
        if (renderId != null && renderId.length() != 0) {
            out.startElement("input", component);
            out.writeAttribute("type", (Object)"hidden", null);
            out.writeAttribute("name", (Object)"org.operamasks.faces.RenderId", null);
            out.writeAttribute("value", (Object)renderId, null);
            out.endElement("input");
        }
        out.startElement("span", component);
        out.writeAttribute("id", (Object)(String.valueOf(component.getClientId(context)) + "_none"), null);
        out.endElement("span");
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        String onsubmit = (String)component.getAttributes().get("onsubmit");
        String onbeforerequest = (String)component.getAttributes().get("onbeforerequest");
        String onsuccess = (String)component.getAttributes().get("onsuccess");
        String onfailure = (String)component.getAttributes().get("onfailure");
        String oncomplete = (String)component.getAttributes().get("oncomplete");
        String groupId = (String)component.getAttributes().get("groupId");
        FormRenderer.addSupportScript((UIForm)((UIForm)component), (String)buf.toString());
        this.delegate.renderHtmlBeginSection(context, component, out);
        this.delegate.renderHtmlMiddleSection(context, component, out);
        this.delegate.renderHtmlEndSection(context, component, out);
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        this.delegate.renderScripts(context, component);
    }

    private boolean isClientValidateEnabled(FacesContext context, UIComponent component) {
        Object clientValidate = component.getAttributes().get("clientValidate");
        if (clientValidate != null) {
            return "true".equalsIgnoreCase(clientValidate.toString());
        }
        String paramValue = context.getExternalContext().getInitParameter(CLIENT_VALIDATE_PARAM);
        return paramValue != null && paramValue.equalsIgnoreCase("true");
    }

    private void addValidatorScripts(FacesContext context, UIComponent component, StringBuilder script, StringBuilder validations, boolean isClientValidateEnabled) {
        if (!component.isRendered()) {
            return;
        }
        if (component instanceof UIInput) {
            if (isClientValidateEnabled) {
                this.addValidatorScripts(context, (UIInput)component, script, validations);
            }
            this.addFieldValidatorScripts(context, (UIInput)component, script, validations);
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            this.addValidatorScripts(context, child, script, validations, isClientValidateEnabled);
        }
    }

    private void addFieldValidatorScripts(FacesContext context, UIInput component, StringBuilder script, StringBuilder validations) {
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        if (jsvar == null || jsvar.length() == 0) {
            return;
        }
        if (validations.length() != 0) {
            validations.append(",");
        }
        validations.append("new FieldValidateWrapper('");
        validations.append(component.getClientId(context));
        validations.append("','").append(jsvar).append("')");
    }

    private void addValidatorScripts(FacesContext context, UIInput component, StringBuilder script, StringBuilder validations) {
        Converter converter = this.getConverterWithType(context, component);
        if (converter instanceof ClientValidator) {
            this.addValidatorScript(context, (UIComponent)component, (ClientValidator)converter, script, validations);
        }
        if (component.isRequired()) {
            if (validations.length() != 0) {
                validations.append(",");
            }
            validations.append("new RequiredValidator('");
            validations.append(component.getClientId(context));
            validations.append("',");
            String requiredMessage = component.getRequiredMessage();
            if (requiredMessage == null) {
                requiredMessage = Resources._T((String)"JSF_VALIDATE_REQUIRED", (Object[])new Object[]{FacesUtils.getLabel((FacesContext)context, (UIComponent)component)});
            }
            validations.append(HtmlEncoder.enquote((String)requiredMessage));
            String display = FacesUtils.getMessageComponentId((FacesContext)context, (UIComponent)component);
            if (display != null) {
                validations.append(",");
                validations.append(HtmlEncoder.enquote((String)display));
            } else {
                validations.append(",null");
            }
            Boolean requiredTrim = (Boolean)component.getAttributes().get("requiredTrim");
            if (requiredTrim == null || requiredTrim.booleanValue()) {
                validations.append(",true");
            }
            validations.append(")");
        }
        Validator[] validatorArray = component.getValidators();
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v instanceof ClientValidator) {
                this.addValidatorScript(context, (UIComponent)component, (ClientValidator)v, script, validations);
            }
            ++n2;
        }
    }

    private void addValidatorScript(FacesContext context, UIComponent component, ClientValidator validator, StringBuilder script, StringBuilder validations) {
        String vs = validator.getValidatorScript(context, component);
        String vis = validator.getValidatorInstanceScript(context, component);
        if (vs != null) {
            script.append(vs);
        }
        if (vis != null) {
            if (validations.length() != 0) {
                validations.append(",");
            }
            validations.append(vis);
        }
    }

    private Converter getConverterWithType(FacesContext context, UIInput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Class converterType = null;
        try {
            converterType = ve.getType(context.getELContext());
        }
        catch (ELException eLException) {
            // empty catch block
        }
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getRenderId(UIComponent component) {
        UIComponent parent = component.getParent();
        while (parent != null) {
            if (parent instanceof AjaxUpdater && !((AjaxUpdater)parent).getGlobalAction().booleanValue()) {
                return ((AjaxUpdater)parent).getRenderId();
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void encodeResourceBegin(FacesContext context, final ResourceManager rm, final UIComponent component) throws IOException {
        if (!this.isClientValidateEnabled(context, component)) {
            return;
        }
        rm.registerResource((Resource)new AbstractResource("urn:client-validate:" + component.getClientId(context)){

            public int getPriority() {
                return 0;
            }

            public void encodeEnd(FacesContext context) throws IOException {
                String script;
                ComponentResource resource = (ComponentResource)rm.getRegisteredResource("urn:yui-ext");
                if (resource != null && (script = AjaxFormRenderer.this.encodeExtStyleValidationScripts(context, (UIForm)component)) != null && script.length() != 0) {
                    resource.addInitScript(script);
                }
            }
        });
    }

    private boolean isExtField(FacesContext context, UIComponent component) {
        if (component instanceof UIField) {
            return true;
        }
        Renderer renderer = FacesUtils.getRenderer((FacesContext)context, (UIComponent)component);
        if (renderer == null) {
            return false;
        }
        return renderer.getClass().getPackage().getName().endsWith("yuiext") || renderer.getClass().getPackage().getName().endsWith("ext");
    }

    private void updateServerSideValidationErrors(FacesContext context, UIForm form) {
        if (this.isImmediate(context)) {
            this.updateImmediateWidgetError(context, form);
        } else {
            this.updateAllWidgetErrors(context, form);
        }
    }

    private void updateImmediateWidgetError(FacesContext context, UIForm form) {
        Iterator kids = FacesUtils.createFacetsAndChildrenIterator((UIComponent)form, (boolean)false);
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (!(child instanceof UIInput) || !this.isExtField(context, child)) continue;
            UIInput input = (UIInput)child;
            if (!child.isRendered() || !this.isActionSourceWidget(context, (UIComponent)input)) continue;
            if (input.isValid()) {
                this.resetServerSideValidationErrors(context, input);
            } else {
                this.encodeServerSideValidationErrors(context, input);
            }
            return;
        }
    }

    public void updateAllWidgetErrors(FacesContext context, UIForm form) {
        Iterator kids = FacesUtils.createFacetsAndChildrenIterator((UIComponent)form, (boolean)false);
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (!(child instanceof UIInput) || !this.isExtField(context, child)) continue;
            UIInput input = (UIInput)child;
            if (!child.isRendered()) continue;
            if (input.isValid()) {
                this.resetServerSideValidationErrors(context, input);
                continue;
            }
            this.encodeServerSideValidationErrors(context, input);
        }
    }

    private boolean isActionSourceWidget(FacesContext context, UIComponent component) {
        String sourceWidgetClientId = ((HttpServletRequest)context.getExternalContext().getRequest()).getParameter("sourceWidgetClientId");
        return sourceWidgetClientId != null && sourceWidgetClientId.equals(component.getClientId(context));
    }

    private boolean isImmediate(FacesContext context) {
        String immediate = ((HttpServletRequest)context.getExternalContext().getRequest()).getParameter("immediate");
        return "true".equalsIgnoreCase(immediate);
    }

    private void resetServerSideValidationErrors(FacesContext context, UIInput input) {
        AjaxResponseWriter writer = (AjaxResponseWriter)context.getResponseWriter();
        String inputJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)input);
        writer.writeActionScript("if(typeof " + inputJsvar + " != 'undefined')if(" + inputJsvar + ".clearInvalid){" + inputJsvar + ".clearInvalid();}");
    }

    private void encodeServerSideValidationErrors(FacesContext context, UIInput input) {
        Iterator iter = context.getMessages(input.getClientId(context));
        if (iter == null || !iter.hasNext()) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        while (iter.hasNext()) {
            FacesMessage message = (FacesMessage)iter.next();
            String summary = message.getSummary();
            String detail = message.getDetail();
            if (buf.length() > 0) {
                buf.append("<br/>");
            }
            if (summary != null && summary.length() > 0) {
                buf.append(summary);
            }
            if (detail == null || detail.length() <= 0 || detail.equals(summary)) continue;
            buf.append("<br/>").append(detail);
        }
        AjaxResponseWriter writer = (AjaxResponseWriter)context.getResponseWriter();
        String inputJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)input);
        writer.writeActionScript("if(typeof " + inputJsvar + " != 'undefined')if(" + inputJsvar + ".markInvalid){" + inputJsvar + ".markInvalid(" + HtmlEncoder.enquote((String)buf.toString()) + ");}");
    }

    private String encodeExtStyleValidationScripts(FacesContext context, UIForm form) {
        Iterator kids = FacesUtils.createFacetsAndChildrenIterator((UIComponent)form, (boolean)false);
        StringBuilder buf = new StringBuilder();
        while (kids.hasNext()) {
            UIComponent child = (UIComponent)kids.next();
            if (!(child instanceof UIInput) || !this.isExtField(context, child)) continue;
            buf.append(this.encodeExtStyleValidationScripts(context, form, (UIInput)child));
        }
        return buf.toString();
    }

    private String encodeExtStyleValidationScripts(FacesContext context, UIForm form, UIInput component) {
        Aliases alias = Aliases.getInstance((FacesContext)context);
        return String.format("%s('%s','%s',%s);", alias.alias("OM.ajax.initValidation"), form.getClientId(context), component.getClientId(context), alias.var(FacesUtils.getJsvar((FacesContext)context, (UIComponent)component)));
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

