/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.render.ajax.AjaxOutputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.FormatRenderer;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxFormatRenderer
extends AjaxOutputRenderer {
    protected FormatRenderer delegate = new FormatRenderer();

    @Override
    protected void renderCurrentValue(FacesContext context, UIComponent component, String currentValue) throws IOException {
        this.delegate.renderCurrentValue(context, component, currentValue);
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        Set attrs = uc.getAttributeCandidates(component);
        if (uc.isUpdateValue(component)) {
            String message = this.delegate.formatMessage(component, this.getCurrentValue(context, component));
            if (RendererUtils.needsEscape((UIComponent)component)) {
                message = HtmlEncoder.encode((String)message);
            }
            out.writeInnerHtmlScript(component.getClientId(context), message);
            attrs.remove("value");
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return RendererUtils.HTML_LITE_ATTRIBUTES;
    }
}

