/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Arrays;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.layout.impl.UIBorderLayout;
import org.operamasks.faces.component.layout.impl.UIPanel;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.layout.ajax.AbstractLayoutRenderer;
import org.operamasks.resources.Resources;

public class AjaxBorderLayoutRenderer
extends AbstractLayoutRenderer {
    private static final String[] regions = new String[]{"center", "east", "south", "west", "north"};
    private static final int CENTER_POSITION = 0;

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        AjaxBorderLayoutRenderer.validateStructure(component);
        super.encodeHtmlBegin(context, component);
    }

    protected String getExtClass(UIComponent component) {
        UIBorderLayout borderLayout = (UIBorderLayout)component;
        if (borderLayout.getFitToBody() == null || borderLayout.getFitToBody() != null && !borderLayout.getFitToBody().booleanValue()) {
            return "Ext.Panel";
        }
        return "Ext.Viewport";
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        UIBorderLayout borderLayout = (UIBorderLayout)component;
        config.set("layout", "border");
        if (borderLayout.getFitToBody() != null && borderLayout.getFitToBody().booleanValue()) {
            config.remove("applyTo");
        }
    }

    private static void validateStructure(UIComponent component) {
        assert (component instanceof UIBorderLayout);
        boolean[] regionExists = new boolean[regions.length];
        for (int i = 0; i < regionExists.length; ++i) {
            regionExists[i] = false;
        }
        for (UIComponent child : component.getChildren()) {
            int i;
            UIPanel panelChild = (UIPanel)child;
            String region = panelChild.getRegion();
            if (region == null) continue;
            for (i = 0; i < regions.length && !regions[i].equals(region); ++i) {
            }
            if (i < region.length()) {
                if (!regionExists[i]) {
                    regionExists[i] = true;
                    continue;
                }
                throw new FacesException(Resources._T((String)"UI_BORDERLAYOUT_DUPLICATE_REGION", (Object[])new Object[]{FacesUtils.getComponentDesc((UIComponent)component), regions[i]}));
            }
            throw new FacesException(Resources._T((String)"UI_BORDERLAYOUT_UNDEFINED_REGION", (Object[])new Object[]{FacesUtils.getComponentDesc((UIComponent)child), region, Arrays.toString(regions)}));
        }
        if (!regionExists[0]) {
            throw new FacesException(Resources._T((String)"UI_BORDERLAYOUT_MISSING_CENTER", (Object[])new Object[]{FacesUtils.getComponentDesc((UIComponent)component)}));
        }
    }
}

