/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.layout.ajax;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.layout.GridLayout;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.layout.Facelet;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;

public class AjaxGridLayoutRenderer
extends AjaxRendererBase {
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("table", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
        out.writeText((Object)"\n", null);
        this.renderCaption(context, component);
        this.renderHeader(context, component);
        this.renderFooter(context, component);
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void encodeHtmlChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        this.renderBody(context, component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.endElement("table");
        out.writeText((Object)"\n", null);
    }

    private void renderCaption(FacesContext context, UIComponent component) throws IOException {
        UIComponent caption = component.getFacet("caption");
        if (caption == null || !caption.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String captionClass = (String)component.getAttributes().get("captionClass");
        String captionStyle = (String)component.getAttributes().get("captionStyle");
        out.startElement("caption", caption);
        if (captionClass != null) {
            out.writeAttribute("class", (Object)captionClass, "captionClass");
        }
        if (captionStyle != null) {
            out.writeAttribute("style", (Object)captionStyle, "captionStyle");
        }
        caption.encodeAll(context);
        out.endElement("caption");
    }

    private void renderHeader(FacesContext context, UIComponent component) throws IOException {
        UIComponent header = component.getFacet("header");
        if (header == null || !header.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String headerClass = (String)component.getAttributes().get("headerClass");
        out.startElement("thead", component);
        out.writeText((Object)"\n", null);
        out.startElement("tr", header);
        out.startElement("th", header);
        if (headerClass != null) {
            out.writeAttribute("class", (Object)headerClass, "headerClass");
        }
        out.writeAttribute("colspan", (Object)this.getColumnCount(component), null);
        out.writeAttribute("scope", (Object)"colgroup", null);
        header.encodeAll(context);
        out.endElement("th");
        out.endElement("tr");
        out.writeText((Object)"\n", null);
        out.endElement("thead");
        out.writeText((Object)"\n", null);
    }

    private void renderFooter(FacesContext context, UIComponent component) throws IOException {
        UIComponent footer = component.getFacet("footer");
        if (footer == null || !footer.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        String footerClass = (String)component.getAttributes().get("footerClass");
        out.startElement("tfoot", component);
        out.writeText((Object)"\n", null);
        out.startElement("tr", footer);
        out.startElement("td", footer);
        if (footerClass != null) {
            out.writeAttribute("class", (Object)footerClass, "footerClass");
        }
        out.writeAttribute("colspan", (Object)this.getColumnCount(component), null);
        footer.encodeAll(context);
        out.endElement("td");
        out.endElement("tr");
        out.writeText((Object)"\n", null);
        out.endElement("tfoot");
        out.writeText((Object)"\n", null);
    }

    private void renderBody(FacesContext context, UIComponent component) throws IOException {
        int columns = this.getColumnCount(component);
        String[] rowClasses = this.getStyleClasses(component, "rowClasses");
        String[] columnClasses = this.getStyleClasses(component, "columnClasses");
        int rowStyles = rowClasses.length;
        int columnStyles = columnClasses.length;
        int rowStyle = 0;
        int columnStyle = 0;
        int cellidx = 0;
        ResponseWriter out = context.getResponseWriter();
        out.startElement("tbody", component);
        out.writeText((Object)"\n", null);
        GridLayout layout = (GridLayout)component;
        if (layout.getFacelets().size() > 0) {
            for (Facelet facelet : layout.getFacelets()) {
                if (cellidx % columns == 0) {
                    if (cellidx != 0) {
                        out.endElement("tr");
                        out.writeText((Object)"\n", null);
                    }
                    out.startElement("tr", component);
                    if (rowStyles > 0) {
                        out.writeAttribute("class", (Object)rowClasses[rowStyle++], "rowClasses");
                        if (rowStyle >= rowStyles) {
                            rowStyle = 0;
                        }
                    }
                    columnStyle = 0;
                }
                out.startElement("td", component);
                if (columnStyles > 0) {
                    out.writeAttribute("class", (Object)columnClasses[columnStyle++], "columnClasses");
                    if (columnStyle >= columnStyles) {
                        columnStyle = 0;
                    }
                }
                facelet.encodeAll(context);
                out.endElement("td");
                out.writeText((Object)"\n", null);
                ++cellidx;
            }
            while (cellidx % columns != 0) {
                out.startElement("td", null);
                if (columnStyles > 0) {
                    out.writeAttribute("class", (Object)columnClasses[columnStyle++], null);
                    if (columnStyle >= columnStyles) {
                        columnStyle = 0;
                    }
                }
                out.endElement("td");
                ++cellidx;
            }
            out.endElement("tr");
            out.writeText((Object)"\n", null);
        }
        out.endElement("tbody");
        out.writeText((Object)"\n", null);
    }

    private String[] getStyleClasses(UIComponent component, String name) {
        String values = (String)component.getAttributes().get(name);
        if (values == null) {
            return new String[0];
        }
        String[] result = values.split(",");
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    private int getColumnCount(UIComponent component) {
        Integer count = (Integer)component.getAttributes().get("columns");
        if (count == null) {
            return 2;
        }
        if (count < 1) {
            return 1;
        }
        return count;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)uc.getAttributeCandidates(component), (Map)this.getLiteAttributes());
    }
}

