/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.render.resource.HttpResourceService;

public class BoxResourceService
extends HttpResourceService {
    private static Map<String, Color> colorMap = new HashMap<String, Color>();

    public BoxResourceService() {
        super("box-service");
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Box box;
        try {
            box = this.parseParameters(request);
        }
        catch (Exception ex) {
            response.sendError(400);
            return;
        }
        Dimension size = box.shape.getSize(box);
        BufferedImage image = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        box.shape.render(g, box);
        g.dispose();
        response.reset();
        response.setContentType("image/png");
        response.setDateHeader("Last-Modified", System.currentTimeMillis());
        response.setHeader("Cache-Control", "max-age=86400");
        ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
    }

    private boolean checkReferer(HttpServletRequest request) {
        String host = request.getServerName();
        if (host.equals("localhost")) {
            return true;
        }
        String referer = request.getHeader("Referer");
        if (referer == null) {
            return false;
        }
        try {
            URI uri = new URI(referer);
            return host.equals(uri.getHost());
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    private Box parseParameters(HttpServletRequest request) {
        String border;
        Box box = new Box();
        box.shape = Shape.valueOf(request.getParameter("a"));
        String height = request.getParameter("height");
        if (height != null) {
            box.height = BoxResourceService.parseInt(height, Integer.MAX_VALUE);
        }
        box.background = BoxResourceService.parseColor(request.getParameter("bg"));
        String fill = request.getParameter("fill");
        if (fill != null) {
            if (fill.indexOf(",") != -1) {
                String[] g = fill.split(",");
                Color startColor = BoxResourceService.parseColor(g[0]);
                Color endColor = BoxResourceService.parseColor(g[1]);
                int extent = BoxResourceService.parseInt(g[2], Integer.MAX_VALUE);
                box.fill = new GradientPaint(0.0f, 0.0f, startColor, 0.0f, extent, endColor);
                if (box.height <= 0) {
                    box.height = extent;
                }
            } else {
                box.fill = BoxResourceService.parseColor(fill);
            }
        }
        if ((border = request.getParameter("border")) != null) {
            String[] g = border.split(",");
            box.borderWidth = BoxResourceService.parseInt(g[0], 50);
            box.borderColor = BoxResourceService.parseColor(g[1]);
            box.borderRadius = BoxResourceService.parseInt(g[2], 1500);
            if (box.borderWidth > box.borderRadius) {
                box.borderRadius = 0;
            }
            box.radius = Math.max(box.borderWidth, box.borderRadius);
        }
        return box;
    }

    private static Color parseColor(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        Color c = colorMap.get(s);
        if (c != null) {
            return c;
        }
        if (s.length() == 3) {
            int r = Integer.parseInt(s.substring(0, 1), 16);
            int g = Integer.parseInt(s.substring(1, 2), 16);
            int b = Integer.parseInt(s.substring(2, 3), 16);
            return new Color(r, g, b);
        }
        if (s.length() == 6) {
            int rgb = Integer.parseInt(s, 16);
            return new Color(rgb, false);
        }
        if (s.length() == 8) {
            int argb = (int)Long.parseLong(s, 16);
            return new Color(argb, true);
        }
        throw new IllegalArgumentException();
    }

    private static int parseInt(String s, int max) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int i = Integer.parseInt(s);
        if (i < 0 || i > max) {
            throw new IllegalArgumentException();
        }
        return i;
    }

    static {
        colorMap.put("transparent", new Color(0, 0, 0, 0));
        colorMap.put("aqua", new Color(0, 255, 255));
        colorMap.put("black", new Color(0, 0, 0));
        colorMap.put("blue", new Color(0, 0, 255));
        colorMap.put("fuchsia", new Color(255, 0, 255));
        colorMap.put("gray", new Color(128, 128, 128));
        colorMap.put("green", new Color(0, 128, 0));
        colorMap.put("lime", new Color(0, 255, 0));
        colorMap.put("maroon", new Color(128, 0, 0));
        colorMap.put("navy", new Color(0, 0, 128));
        colorMap.put("olive", new Color(128, 128, 0));
        colorMap.put("orange", new Color(255, 165, 0));
        colorMap.put("purple", new Color(128, 0, 128));
        colorMap.put("red", new Color(255, 0, 0));
        colorMap.put("silver", new Color(192, 192, 192));
        colorMap.put("teal", new Color(0, 128, 128));
        colorMap.put("white", new Color(255, 255, 255));
        colorMap.put("yellow", new Color(255, 255, 0));
    }

    private static class MCR
    extends Renderer {
        private static final int W = 1;

        private MCR() {
        }

        public Dimension getSize(Box b) {
            if (b.height > 0) {
                return new Dimension(1, b.height);
            }
            if (b.borderWidth > 0) {
                return new Dimension(1, b.borderWidth);
            }
            return new Dimension(1, 1);
        }

        public void render(Graphics2D g, Box b) {
            int h = b.height;
            int s = b.borderWidth;
            if (b.fill != null) {
                g.setPaint(b.fill);
                g.fillRect(0, 0, 1, h);
            }
            if (s > 0) {
                g.setColor(b.borderColor);
                g.fillRect(0, 0, 1, s);
            }
        }
    }

    private static class BRR
    extends CornerRenderer {
        private BRR() {
        }

        public void render(Graphics2D g, Box b) {
            int r = b.borderRadius;
            int s = b.borderWidth;
            if (r > 0) {
                if (b.background != null) {
                    g.setPaint(b.background);
                    g.fillRect(0, 0, r, r);
                }
                if (b.fill != null) {
                    g.setPaint(b.fill);
                    g.fillArc(-r, -r, r * 2, r * 2, 0, -90);
                }
                if (s > 0) {
                    g.setStroke(new BasicStroke(s));
                    g.setColor(b.borderColor);
                    g.drawArc(-r + s / 2, -r + s / 2, r * 2 - s, r * 2 - s, 0, -90);
                }
            } else if (s > 0) {
                g.setColor(b.borderColor);
                g.fillRect(0, 0, s, s);
            }
        }
    }

    private static class BLR
    extends CornerRenderer {
        private BLR() {
        }

        public void render(Graphics2D g, Box b) {
            int r = b.borderRadius;
            int s = b.borderWidth;
            if (r > 0) {
                if (b.background != null) {
                    g.setPaint(b.background);
                    g.fillRect(0, 0, r, r);
                }
                if (b.fill != null) {
                    g.setPaint(b.fill);
                    g.fillArc(0, -r, r * 2, r * 2, 180, 90);
                }
                if (s > 0) {
                    g.setStroke(new BasicStroke(s));
                    g.setColor(b.borderColor);
                    g.drawArc(s / 2, -r + s / 2, r * 2 - s, r * 2 - s, 180, 90);
                }
            } else if (s > 0) {
                g.setColor(b.borderColor);
                g.fillRect(0, 0, s, s);
            }
        }
    }

    private static class TRR
    extends CornerRenderer {
        private TRR() {
        }

        public void render(Graphics2D g, Box b) {
            int r = b.borderRadius;
            int s = b.borderWidth;
            if (r > 0) {
                if (b.background != null) {
                    g.setPaint(b.background);
                    g.fillRect(0, 0, r, r);
                }
                if (b.fill != null) {
                    g.setPaint(b.fill);
                    g.fillArc(-r, 0, r * 2, r * 2, 0, 90);
                }
                if (s > 0) {
                    g.setStroke(new BasicStroke(s));
                    g.setColor(b.borderColor);
                    g.drawArc(-r + s / 2, s / 2, r * 2 - s, r * 2 - s, 0, 90);
                }
            } else if (s > 0) {
                g.setColor(b.borderColor);
                g.fillRect(0, 0, s, s);
            }
        }
    }

    private static class TLR
    extends CornerRenderer {
        private TLR() {
        }

        public void render(Graphics2D g, Box b) {
            int r = b.borderRadius;
            int s = b.borderWidth;
            if (r > 0) {
                if (b.background != null) {
                    g.setPaint(b.background);
                    g.fillRect(0, 0, r, r);
                }
                if (b.fill != null) {
                    g.setPaint(b.fill);
                    g.fillArc(0, 0, r * 2, r * 2, 90, 90);
                }
                if (s > 0) {
                    g.setStroke(new BasicStroke(s));
                    g.setColor(b.borderColor);
                    g.drawArc(s / 2, s / 2, r * 2 - s, r * 2 - s, 90, 90);
                }
            } else if (s > 0) {
                g.setColor(b.borderColor);
                g.fillRect(0, 0, s, s);
            }
        }
    }

    private static abstract class CornerRenderer
    extends Renderer {
        private CornerRenderer() {
        }

        public Dimension getSize(Box b) {
            if (b.radius > 0) {
                return new Dimension(b.radius, b.radius);
            }
            return new Dimension(1, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Shape {
        tl(new TLR()),
        tr(new TRR()),
        bl(new BLR()),
        br(new BRR()),
        mc(new MCR());

        private Renderer r;

        private Shape(Renderer r) {
            this.r = r;
        }

        public Renderer getRenderer() {
            return this.r;
        }

        public Dimension getSize(Box box) {
            return this.r.getSize(box);
        }

        public void render(Graphics2D g, Box box) {
            this.r.render(g, box);
        }
    }

    private static class Box {
        Shape shape;
        int height;
        Color background;
        Paint fill;
        int borderWidth;
        Color borderColor;
        int borderRadius;
        int radius;

        private Box() {
        }
    }

    private static abstract class Renderer {
        private Renderer() {
        }

        public abstract Dimension getSize(Box var1);

        public abstract void render(Graphics2D var1, Box var2);
    }
}

