/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.validator.Validator;
import org.operamasks.faces.component.AjaxActionEventHandler;
import org.operamasks.faces.component.form.impl.UICheckBox;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.component.grid.CellEditor;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.FormMessageTarget;
import org.operamasks.faces.component.widget.UIForm;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ExtRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFieldRenderer
extends ExtRenderer
implements ToolBarItemRenderer {
    protected static final String FIELD_IN_EDITDATAGRID = "org.operamasks.faces.fieldInEditDataGrid";
    protected static final int DEFAULT_WIDTH = 136;
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AbstractFieldRenderer() {
        liteAttrCore.put("width", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Integer width = ((UIField)component).getWidth();
                if (width != null) {
                    out.writeScriptBlock(String.format("%s.setWidth(%s);\n", jsvar, width));
                }
            }
        });
        liteAttrCore.put("height", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Integer height = ((UIField)component).getHeight();
                if (height != null) {
                    out.writeScriptBlock(String.format("%s.setHeight(%s);\n", jsvar, height));
                }
            }
        });
        liteAttrCore.put("hidden", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                boolean hidden = Boolean.TRUE.equals(((UIField)component).getHidden());
                if (hidden) {
                    out.writeScriptBlock(String.format("%s.hide();\n", jsvar));
                } else {
                    out.writeScriptBlock(String.format("%s.show();\n", jsvar));
                }
            }
        });
        liteAttrCore.put("readOnly", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                boolean readOnly = Boolean.TRUE.equals(((UIField)component).getReadOnly());
                out.writeScriptBlock(String.format("%s.setReadOnly(%s);\n", jsvar, readOnly));
            }
        });
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                boolean disabled = Boolean.TRUE.equals(((UIField)component).getDisabled());
                if (disabled) {
                    out.writeScriptBlock(String.format("%s.disable();\n", jsvar));
                } else {
                    out.writeScriptBlock(String.format("%s.enable();\n", jsvar));
                }
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!CompRendererUtils.needsDecode(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(clientId);
        if (newValue != null) {
            this.setSubmittedValue(component, newValue);
        }
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (component.getParent() instanceof ToolBar) {
            return;
        }
        UIField field = (UIField)component;
        this.beforeHtmlBegin(context, component);
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        String clientId = component.getClientId(context);
        out.startElement("table", component);
        out.writeAttribute("id", (Object)component.getOuterContainerId(context), null);
        out.writeAttribute("cellspacing", (Object)0, null);
        out.writeAttribute("cellpadding", (Object)0, null);
        out.startElement("tr", component);
        out.startElement("td", component);
        if (!Boolean.TRUE.equals(field.getHideLabel()) && field.getFieldLabel() != null) {
            out.startElement("label", component);
            if (field.getLabelStyle() != null) {
                out.writeAttribute("style", (Object)field.getLabelStyle(), null);
            } else {
                out.writeAttribute("class", (Object)"x-form-item-label", null);
            }
            if (field.getLabelSeparator() != null) {
                out.writeText((Object)(String.valueOf(field.getFieldLabel()) + field.getLabelSeparator()), (UIComponent)field, null);
            } else {
                out.writeText((Object)field.getFieldLabel(), (UIComponent)field, null);
            }
            out.endElement("label");
        }
        out.endElement("td");
        out.startElement("td", component);
        out.startElement("div", component);
        out.writeAttribute("class", (Object)"x-form-item", null);
        out.startElement("div", component);
        out.writeAttribute("class", (Object)"x-form-element", null);
        out.startElement(this.getHtmlMarkup(), component);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        String inputType = ((UIField)component).getInputType();
        if (!"password".equalsIgnoreCase(inputType)) {
            inputType = "text";
        }
        if (component instanceof UICheckBox) {
            inputType = "checkbox";
        }
        out.writeAttribute("type", (Object)inputType, null);
        String style = (String)component.getAttributes().get("style");
        String styleClass = (String)component.getAttributes().get("styleClass");
        String defaultStyle = "";
        if (RendererUtils.isContainer((UIComponent)component)) {
            defaultStyle = this.getContainerDefaultStyle();
        }
        style = style != null && style.length() > 0 ? String.valueOf(defaultStyle) + style : defaultStyle;
        out.writeAttribute("style", (Object)style, "style");
        if (styleClass != null && styleClass.length() > 0) {
            out.writeAttribute("class", (Object)styleClass, "class");
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (component.getParent() instanceof ToolBar) {
            return;
        }
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement(this.getHtmlMarkup());
        out.endElement("div");
        out.endElement("div");
        out.endElement("td");
        out.endElement("table");
        out.write("\n");
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        resource.addInitScript(this.innerResourceBegin(context, component, rm));
    }

    public void encodeResourceEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        resource.addInitScript(this.innerResourceEnd(component));
    }

    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        UIField field = (UIField)component;
        if (Boolean.TRUE.equals(field.getHidden())) {
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            resource.addInitScript(String.format("%s.hide();", jsvar));
        }
    }

    public CellEditor getCellEditor(UIField field) {
        FacesContext context = FacesContext.getCurrentInstance();
        try {
            this.encodeResourceBegin(context, ResourceManager.getInstance((FacesContext)context), (UIComponent)field);
            this.encodeResourceEnd(context, ResourceManager.getInstance((FacesContext)context), (UIComponent)field);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)field);
        field.getAttributes().put(FIELD_IN_EDITDATAGRID, Boolean.TRUE);
        return new FieldCellEditor(Aliases.getVar((String)jsvar), this.getExtraConfig(field));
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.form", "Ext.QuickTips"};
    }

    public void enable(UIField field) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)field, new String[]{"disabled"});
    }

    public void disable(UIField field) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)field, new String[]{"disabled"});
    }

    public void hide(UIField field) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)field, new String[]{"hidden"});
    }

    public void show(UIField field) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)field, new String[]{"hidden"});
    }

    public void focus(UIField field) {
        FacesContext context = FacesContext.getCurrentInstance();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)field);
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(String.valueOf(jsvar) + ".focus();");
    }

    public String getToolBarItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        StringBuffer sb = new StringBuffer();
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        sb.append(this.innerResourceBegin(context, component, rm));
        sb.append(this.innerResourceEnd(component));
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }

    public String getToolBarItemAddScript(FacesContext context, UIComponent component, String jsvar) {
        Formatter fmt = new Formatter();
        fmt.format("if(typeof %2$s != 'undefined'){%1$s.addField(%2$s);}", jsvar, this.getToolBarItemAddElement(context, component));
        return fmt.toString();
    }

    public boolean ignoreChildren() {
        return true;
    }

    public String getToolBarItemAddElement(FacesContext context, UIComponent item) {
        return Aliases.getVar((String)FacesUtils.getJsvar((FacesContext)context, (UIComponent)item));
    }

    protected abstract String getHtmlMarkup();

    protected void setSubmittedValue(UIComponent component, Object newValue) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(newValue);
        }
    }

    protected String getCurrentValue(FacesContext context, UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        Object currentValue = this.getValue(component);
        if (currentValue != null) {
            return this.getFormattedValue(context, component, currentValue);
        }
        return null;
    }

    protected Object getValue(UIComponent component) {
        if (component instanceof ValueHolder) {
            return ((ValueHolder)component).getValue();
        }
        return null;
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)component, (Object)currentValue);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return RendererUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected void beforeHtmlBegin(FacesContext context, UIComponent component) {
    }

    protected String innerResourceBegin(FacesContext context, UIComponent component, ResourceManager rm) {
        StringBuilder buf = new StringBuilder();
        this.encodeField(buf, context, component, rm);
        if (component instanceof UIField && component.isRendered() && Boolean.TRUE.equals(CompRendererUtils.isClientValidateEnabled((UIField)component)) && !this.inEditDataGrid(component)) {
            this.updateFormValidateFieldIds(buf, context, component);
        }
        buf.append(';');
        Formatter fmt = new Formatter(buf);
        ComponentResource.registerJS((ResourceManager)rm, (String[])this.getDependedJSPackages(context, component));
        ComponentResource.registerCSS((ResourceManager)rm, (String[])this.getDependedCSSPackages(context, component));
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        ComponentResource.getResourceInstance((ResourceManager)rm).addVariable(jsvar);
        String clientId = component.getClientId(context);
        if (!(component.getParent() instanceof ToolBar)) {
            Aliases alias = Aliases.getInstance((FacesContext)context);
            fmt.format("%s(%s,'%s');", alias.alias("OM.applyToMarkup"), alias.var(jsvar), clientId);
        }
        return fmt.toString();
    }

    protected String innerResourceEnd(UIComponent component) {
        AjaxActionEventHandler handler = new AjaxActionEventHandler(component);
        return handler.toScript();
    }

    protected void encodeField(StringBuilder buf, FacesContext context, final UIComponent component, ResourceManager rm) {
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("field");
        buf.append(RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias));
        fmt.format("%s=new %s(%s{", jsvar, alias.alias(this.getExtClass(component)), c.start());
        ExtConfig config = new ExtConfig(component);
        config.addPropertyModifiers("msgTarget", new ExtConfig.PropertyModifier(){

            public Object modifyValue(Object currentValue) {
                UIForm form;
                if (!$assertionsDisabled && !(currentValue instanceof String)) {
                    throw new AssertionError();
                }
                String value = (String)currentValue;
                if (value == null && (form = (UIForm)FacesUtils.getParentForm((UIComponent)component)) != null) {
                    value = form.getMsgTarget();
                }
                if (value != null && !FormMessageTarget.isSupport(value).booleanValue()) {
                    throw new FacesException(Resources._T((String)"UI_UNEXPECTED_ATTRIBUTE_VALUE", (Object[])new Object[]{FacesUtils.getComponentDesc((UIComponent)component), "msgTarget", value, FormMessageTarget.getSupportTargets()}));
                }
                return value;
            }
        });
        UIField field = (UIField)component;
        String value = this.getCurrentValue(FacesContext.getCurrentInstance(), component);
        if (value == null) {
            value = "";
        }
        value = value.replaceAll("\\r", "");
        value = HtmlEncoder.enquote((String)value);
        config.set("value", value, true);
        this.processExtConfig(context, component, config);
        this.postProcessExtConfig(component, config);
        config.set("plugins", "new " + alias.alias("Ext.ux.plugins.FieldValidatePlugin") + "()", true);
        this.addClientValidateSets(context, config, field, alias);
        String configStr = config.toScript(c);
        buf.append(configStr);
        fmt.format("}%s)", c.end());
    }

    protected void addClientValidateSets(FacesContext context, ExtConfig config, UIField field, Aliases alias) {
        String tooltip;
        String clientId = field.getClientId(context);
        Boolean clientValidateEnabled = CompRendererUtils.isClientValidateEnabled(field);
        if (Boolean.TRUE.equals(clientValidateEnabled) || this.inEditDataGrid((UIComponent)field)) {
            String validatorArray = this.constructValidatorArray(context, field, alias);
            config.set("validator", String.format("%s(%s)", alias.alias("OM.buildClientValidator"), validatorArray), true);
            if (!this.inEditDataGrid((UIComponent)field)) {
                this.initValidateEvents(field);
            }
        }
        if ((Boolean.FALSE.equals(clientValidateEnabled) || Boolean.TRUE.equals(clientValidateEnabled) && this.hasValidateEvents(field)) && !this.inEditDataGrid((UIComponent)field)) {
            config.set("validateOnBlur", false);
            config.set("validationEvent", false);
        }
        if (field.getParent() instanceof ToolBar) {
            config.set("name", clientId);
        }
        if (FormMessageTarget.none.toString().equals(field.getMsgTarget())) {
            config.set("msgTarget", String.valueOf(FacesUtils.getParentForm((UIComponent)field).getClientId(context)) + "_none");
        }
        if ((tooltip = field.getTooltip()) != null && tooltip.length() > 0) {
            Aliases.ConfigBuilder c = Aliases.getConfigBuilder((String)"field");
            config.set("listeners", String.format("%s{%s:%s('%s')}%s", c.start(), c.prop("render"), alias.alias("OM.buildToolTipRenderer"), tooltip, c.end()), true);
        }
        config.set("id", clientId);
    }

    protected void initValidateEvents(UIField field) {
        UIForm parentForm;
        String validateEvents = field.getValidateEvents();
        if (validateEvents == null && (parentForm = CompRendererUtils.getParentUIForm((UIComponent)field)) != null) {
            validateEvents = parentForm.getValidateEvents();
        }
        if (validateEvents == null) {
            return;
        }
        String[] events = validateEvents.split(",");
        if (events.length > 0) {
            String[] stringArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                String event = stringArray[n2];
                if ((event = event.trim()).length() > 0) {
                    String originalScript = (String)field.getAttributes().get(event);
                    if (originalScript != null && originalScript.trim().length() > 0) {
                        if (!(originalScript = originalScript.trim()).endsWith(";")) {
                            originalScript = String.valueOf(originalScript) + ";";
                        }
                    } else {
                        originalScript = "";
                    }
                    field.getAttributes().put(event, String.valueOf(originalScript) + "return this.validate();");
                }
                ++n2;
            }
        }
    }

    protected boolean hasValidateEvents(UIField field) {
        UIForm form = CompRendererUtils.getParentUIForm((UIComponent)field);
        return field.getValidateEvents() != null || form != null && form.getValidateEvents() != null;
    }

    protected String constructValidatorArray(FacesContext context, UIField field, Aliases alias) {
        StringBuilder buf = new StringBuilder("[");
        int validatorCounter = 0;
        Converter converter = this.getConverterWithType(context, field);
        if (converter instanceof ClientValidator && this.addValidatorScript(context, (UIComponent)field, (ClientValidator)converter, buf)) {
            ++validatorCounter;
        }
        if (field.isRequired()) {
            if (validatorCounter != 0) {
                buf.append(",");
            }
            buf.append("new ").append(alias.alias("RequiredValidator")).append("(");
            String requiredMessage = field.getRequiredMessage();
            if (requiredMessage == null) {
                requiredMessage = Resources._T((String)"JSF_VALIDATE_REQUIRED", (Object[])new Object[]{FacesUtils.getLabel((FacesContext)context, (UIComponent)field)});
            }
            buf.append(HtmlEncoder.enquote((String)requiredMessage));
            Boolean requiredTrim = (Boolean)field.getAttributes().get("requiredTrim");
            if (requiredTrim == null || requiredTrim.booleanValue()) {
                buf.append(",true");
            }
            buf.append(")");
            ++validatorCounter;
        }
        Validator[] validatorArray = field.getValidators();
        int n = validatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Validator v = validatorArray[n2];
            if (v instanceof ClientValidator) {
                if (validatorCounter != 0) {
                    buf.append(",");
                }
                if (this.addValidatorScript(context, (UIComponent)field, (ClientValidator)v, buf)) {
                    ++validatorCounter;
                } else if (validatorCounter != 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
            }
            ++n2;
        }
        buf.append("]");
        return buf.toString();
    }

    protected boolean addValidatorScript(FacesContext context, UIComponent component, ClientValidator validator, StringBuilder buf) {
        String vsi = validator.getValidatorInstanceScript(context, component);
        if (vsi != null) {
            buf.append(vsi);
            return true;
        }
        return false;
    }

    protected Converter getConverterWithType(FacesContext context, UIInput component) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Class converterType = null;
        try {
            converterType = ve.getType(context.getELContext());
        }
        catch (ELException eLException) {
            // empty catch block
        }
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected String getContainerDefaultStyle() {
        return "";
    }

    public ExtConfig getExtraConfig(UIField field) {
        return null;
    }

    protected void updateFormValidateFieldIds(StringBuilder buf, FacesContext context, UIComponent component) {
        Formatter fmt = new Formatter(buf);
        UIForm form = CompRendererUtils.getParentUIForm(component);
        if (form == null) {
            return;
        }
        String formClientId = form.getClientId(context);
        String fieldClientId = HtmlEncoder.enquote((String)component.getClientId(context));
        buf.append(";");
        Aliases alias = Aliases.getInstance((FacesContext)context);
        fmt.format("%s('%s',%s);", alias.alias("OM.updateFormValidateFieldIds"), formClientId, fieldClientId);
    }

    protected boolean inEditDataGrid(UIComponent comp) {
        return Boolean.TRUE.equals(comp.getAttributes().get(FIELD_IN_EDITDATAGRID));
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public boolean isRepaintable(UIComponent component) {
        return CompRendererUtils.isRepaintable(component);
    }

    protected void encodeAjaxValue(UIComponent component, PartialUpdateCandidates uc, AjaxResponseWriter out, String jsvar) throws IOException {
        String value = this.getCurrentValue(FacesContext.getCurrentInstance(), component);
        if (value == null) {
            value = "";
        }
        value = value.replaceAll("\\r", "");
        value = HtmlEncoder.enquote((String)value);
        String script = String.format("%s.setValue(%s);\n", jsvar, value);
        out.writeScriptBlock(script);
    }

    public static class FieldCellEditor
    implements CellEditor {
        private String script;
        private ExtConfig config;

        public FieldCellEditor(String script, ExtConfig config) {
            this.script = script;
            this.config = config;
        }

        public void render(StringBuilder buf) throws IOException {
            buf.append(this.script);
        }

        public void setScript(String script) {
            this.script = script;
        }

        public ExtConfig getExtraConfig() throws IOException {
            return this.config;
        }
    }
}

