/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.operamasks.faces.component.widget.UICalendar;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxInputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;

public class AjaxCalendarRenderer
extends AjaxInputRenderer {
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        String clientId = component.getClientId(context);
        String value = this.getCurrentValue(context, component);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)(clientId + ':' + "_container"), null);
        String styleClass = "";
        if (component.getAttributes().get("styleClass") != null) {
            styleClass = component.getAttributes().get("styleClass").toString();
        }
        out.writeAttribute("class", (Object)(styleClass + " calendarCtCls"), null);
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"readonly,alt,accesskey,disabled,onchange");
        out.endElement("div");
        out.write("\n");
        if (value == null) {
            value = UICalendar.getFormattedValue(new Date());
        }
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        out.writeAttribute("value", (Object)value, "value");
        out.endElement("input");
        out.write("\n");
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.om.DatePicker"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String clientId = component.getClientId(context);
        String containerId = clientId + ':' + "_container";
        String jsvar = resource.allocVariable(component);
        String value = this.getCurrentValue(context, component);
        Formatter fmt = new Formatter();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("calendar");
        fmt.format("%s%s=new %s({disabled:%b});", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.DatePicker"), RendererUtils.isDisabled((UIComponent)component));
        if (value == null) {
            value = UICalendar.getFormattedValue(new Date());
        }
        String jsvarAlias = alias.var(jsvar);
        fmt.format("%s.setValue(%s('%s','%s'));", jsvarAlias, alias.alias("Date.parseDate"), value, "m/d/Y");
        fmt.format("%s.render('%s');", jsvarAlias, containerId);
        String onchange = (String)component.getAttributes().get("onchange");
        if (onchange == null) {
            onchange = "";
        } else if (!onchange.trim().endsWith(";")) {
            onchange = onchange + ";";
        }
        String onselect = (String)component.getAttributes().get("onselect");
        if (onselect == null) {
            onselect = "";
        } else if (!onselect.trim().endsWith(";")) {
            onselect = onselect + ";";
        }
        fmt.format("%s.on('select',function(o,d){Ext.getDom('%s').value = d.format('%s');%s %s});", jsvarAlias, clientId, "m/d/Y", onselect, onchange);
        resource.releaseVariable(jsvar);
        resource.addInitScript(fmt.toString());
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        if (uc.isUpdateValue(component)) {
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            String value = this.getCurrentValue(context, component);
            Formatter fmt = new Formatter();
            if (value != null && value.length() != 0) {
                fmt.format("%s.setValue(Date.parseDate('%s', '%s'));\n", jsvar, value, "m/d/Y");
            }
            if (FacesUtils.isDynamicValue((UIComponent)component, (String)"disabled")) {
                if (RendererUtils.isDisabled((UIComponent)component)) {
                    fmt.format("%s.disable();\n", jsvar);
                } else {
                    fmt.format("%s.enable();\n", jsvar);
                }
            }
            AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
            out.writeScriptBlock(fmt.toString());
            uc.getAttributeCandidates(component).remove("value");
        }
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return UICalendar.getFormattedValue(currentValue);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return UICalendar.getConvertedValue((String)submittedValue);
    }
}

