/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.servlet.http.Cookie;
import org.operamasks.faces.component.widget.UIChooseSkin;
import org.operamasks.faces.render.ajax.AjaxInputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.resource.SkinDescriptor;
import org.operamasks.faces.render.resource.SkinManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxChooseSkinRenderer
extends AjaxInputRenderer {
    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("select", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        out.writeAttribute("name", (Object)component.getClientId(context), "clientId");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
        out.writeText((Object)"\n", null);
        this.renderOptions(context, component);
        out.endElement("select");
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        if (((UIChooseSkin)component).isLocalValueSet()) {
            this.renderAjaxResponse(context, component);
        }
    }

    private void renderAjaxResponse(FacesContext context, UIComponent component) throws IOException {
        String extraFiles;
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String skin = this.getCurrentValue(context, component);
        if (skin == null) {
            skin = "default";
        }
        out.writeAttributeScript(component.getClientId(context), "value", (Object)skin);
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        SkinManager skinManager = SkinManager.getInstance((FacesContext)context);
        StringBuilder buf = new StringBuilder();
        Formatter f = new Formatter(buf);
        buf.append("(function(){");
        buf.append("var doc = document;var h = doc.getElementsByTagName(\"head\")[0];var els = h.childNodes;var el;for (var i = 0; i < els.length; i++) {if (els[i].className == 'x-skin')els[i].parentNode.removeChild(els[i]);}\n");
        f.format("el = doc.createElement(\"link\");el.setAttribute(\"class\", \"x-skin\");el.setAttribute(\"rel\", \"stylesheet\");el.setAttribute(\"type\", \"text/css\");el.setAttribute(\"href\", \"%s\");h.appendChild(el);", rm.getSkinResourceURL(skin, "/yuiext/css/ext-all.css"));
        f.format("el = doc.createElement(\"link\");el.setAttribute(\"class\", \"x-skin\");el.setAttribute(\"rel\", \"stylesheet\");el.setAttribute(\"type\", \"text/css\");el.setAttribute(\"href\", \"%s\");h.appendChild(el);", rm.getSkinResourceURL(skin, "/yuiext/css/ext-extra.css"));
        SkinDescriptor skinDesc = skinManager.getSkin(skin);
        if (skinDesc != null && (extraFiles = skinDesc.getProperty("yuiext.files")) != null) {
            for (String file : extraFiles.split(",")) {
                file = file.trim();
                String url = rm.getSkinResourceURL(skin, file);
                if (file.endsWith(".js")) {
                    f.format("el = doc.createElement(\"script\");el.setAttribute(\"class\", \"x-skin\");el.setAttribute(\"type\", \"text/javascript\");el.setAttribute(\"src\", \"%s\");h.appendChild(el);", url);
                    continue;
                }
                if (!file.endsWith(".css")) continue;
                f.format("el = doc.createElement(\"link\");el.setAttribute(\"class\", \"x-skin\");el.setAttribute(\"rel\", \"stylesheet\");el.setAttribute(\"type\", \"text/css\");el.setAttribute(\"href\", \"%s\");h.appendChild(el);", url);
            }
        }
        buf.append("window.location.reload(false);\n");
        buf.append("})();\n");
        out.writeScriptBlock(buf.toString());
    }

    protected void renderOptions(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        List<SelectItem> items = this.getSelectItems(context);
        String currentValue = this.getCurrentValue(context, component);
        for (SelectItem item : items) {
            out.startElement("option", null);
            out.writeAttribute("value", item.getValue(), null);
            if (currentValue.equals(item.getValue())) {
                out.writeAttribute("selected", (Object)true, null);
            }
            if (item.getDescription() != null) {
                out.writeAttribute("title", (Object)item.getDescription(), null);
            }
            out.writeText((Object)item.getLabel(), null);
            out.endElement("option");
            out.writeText((Object)"\n", null);
        }
    }

    public List<SelectItem> getSelectItems(FacesContext context) {
        SkinManager skinManager = SkinManager.getInstance((FacesContext)context);
        Map skins = skinManager.getSkins();
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(skins.size());
        for (Map.Entry entry : skins.entrySet()) {
            String name = (String)entry.getKey();
            SkinDescriptor skin = (SkinDescriptor)entry.getValue();
            String label = skin.getDisplayName(context.getViewRoot().getLocale()) != null ? skin.getDisplayName(context.getViewRoot().getLocale()) : skin.getId();
            String description = skin.getDescription();
            result.add(new SelectItem((Object)name, label, description));
        }
        Collections.sort(result, new Comparator<SelectItem>(){

            @Override
            public int compare(SelectItem a, SelectItem b) {
                return a.getLabel().compareTo(b.getLabel());
            }
        });
        for (SelectItem item : result) {
            if (!"default".equals(item.getValue())) continue;
            result.remove(item);
            result.add(0, item);
            break;
        }
        return result;
    }

    @Override
    public String getCurrentValue(FacesContext context, UIComponent component) {
        String value = super.getCurrentValue(context, component);
        if (value == null) {
            value = "default";
        }
        return value;
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        this.processCookie(rm, component);
    }

    private void processCookie(ResourceManager rm, UIComponent component) {
        String skin;
        FacesContext context;
        Cookie c;
        String cookie = (String)component.getAttributes().get("cookie");
        if (cookie != null && (c = (Cookie)(context = FacesContext.getCurrentInstance()).getExternalContext().getRequestCookieMap().get(cookie)) != null && (skin = c.getValue()) != null && skin.length() != 0) {
            SkinManager.setCurrentSkin((FacesContext)context, (String)skin);
        }
    }
}

