/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.widget.menu.UICommandMenuItem;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.MenuItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.CommandLinkRenderHelper;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxCommandMenuItemRenderer
extends AjaxRendererBase
implements MenuItemRenderer {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxCommandMenuItemRenderer() {
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                if (RendererUtils.isDisabled((UIComponent)component)) {
                    out.writeScriptBlock(String.format("if(typeof(%1$s) != 'undefined'){%1$s.disable();}", jsvar));
                } else {
                    out.writeScriptBlock(String.format("if(typeof(%1$s) != 'undefined'){%1$s.enable();}", jsvar));
                }
            }
        });
        liteAttrCore.put("label", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String text = HtmlEncoder.enquote((String)MenuRendererHelper.getItemText(context, component, false), (Character)Character.valueOf('\''));
                out.writeScriptBlock(String.format("if(typeof(%1$s) != 'undefined'){%1$s.setText(%2$s);}", jsvar, text));
            }
        });
        liteAttrCore.put("image", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String icon = MenuRendererHelper.getItemIcon(context, component);
                icon = icon == null ? "Ext.BLANK_IMAGE_URL" : HtmlEncoder.enquote((String)icon, (Character)Character.valueOf('\''));
                StringBuffer sb = new StringBuffer();
                Formatter fmt = new Formatter(sb);
                fmt.format("if(typeof(%1$s) != 'undefined'){%1$s.icon=%2$s;}", jsvar, icon);
                sb.append("try {");
                fmt.format("if(%1$s){var %1$s_icon = %1$s.getEl().select('img');", jsvar);
                fmt.format("if(%s_icon && %s_icon != null) {", jsvar, jsvar);
                fmt.format("%s_icon.first().dom.src=%s;", jsvar, icon);
                sb.append("}}");
                sb.append("} catch(e){}");
                out.writeScriptBlock(sb.toString());
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly((UIComponent)component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            ActionEvent event = new ActionEvent(component);
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)event);
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        UIMenu menu = MenuRendererHelper.getParentMenu(component);
        if (menu == null) {
            return;
        }
        ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]).addInitScript(this.getMenuItemInitScript(context, component, (UIComponent)menu));
    }

    public String getMenuItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        String text = MenuRendererHelper.getItemText(context, component, true);
        String handler = CommandLinkRenderHelper.getOnclickScript(context, FacesUtils.getParentForm((UIComponent)component), component, false);
        Formatter fmt = new Formatter();
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        String itemJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        resource.addVariable(itemJsVar);
        fmt.format(RendererUtils.getJsvarAliasDef((String)itemJsVar, (Aliases)alias), new Object[0]);
        fmt.format("%s=new %s(%s{", itemJsVar, alias.alias("Ext.menu.Item"), c.start());
        MenuRendererHelper.encodeItemConfig(fmt, context, component, text, c);
        if (handler != null) {
            fmt.format(",%s:function(){%s}", c.prop("handler"), handler);
        }
        fmt.format("}%s);", c.end());
        String menuJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent);
        fmt.format("%s.addItem(%s);", alias.var(menuJsVar), alias.var(itemJsVar));
        return fmt.toString();
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public void setDisabled(UICommandMenuItem item, boolean disabled) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)item, new String[]{"disabled"});
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

