/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.widget.UIDataView;
import org.operamasks.faces.component.widget.UIPager;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.FormRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.DataRendererHelper;
import org.operamasks.faces.render.widget.helper.DataViewRenderHelper;
import org.operamasks.faces.render.widget.helper.PagerHelper;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;

public class AjaxDataViewRenderer
extends AjaxRendererBase {
    private static final String JSON_TOTAL = "totalcount";
    private static final String JSON_ROOT = "records";
    private static final String JSON_VIEWSTATE = "viewState";
    private static final String JSON_PARAMS = "params";
    public static final String DELEGATE_PARAM = "_ajaxDataProxy_view";

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (!FacesUtils.isAjaxResponse((FacesContext)context)) {
            return;
        }
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        String requestId = (String)paramMap.get(DELEGATE_PARAM);
        if (requestId != null && requestId.equals(clientId)) {
            try {
                this.loadData(context, (UIDataView)component);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        String clientId;
        UIDataView view;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIDataView uIDataView = view = (UIDataView)component;
        synchronized (uIDataView) {
            view.setRowIndex(-1);
            clientId = component.getClientId(context);
        }
        AjaxHtmlResponseWriter out = (AjaxHtmlResponseWriter)context.getResponseWriter();
        out.setViewStateChanged(false);
        String containerId = view.getContainer();
        if (containerId == null) {
            out.startElement("div", component);
            UIComponent header = component.getFacet("header");
            if (header != null) {
                out.startElement("div", component);
                DataViewRenderHelper.encodeRecursive(context, header);
                out.endElement("div");
                out.write("\n");
            }
            out.startElement("div", component);
            out.writeAttribute("id", (Object)clientId, "clientId");
            RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"rows");
            out.endElement("div");
            UIComponent footer = component.getFacet("footer");
            if (footer != null) {
                out.startElement("div", component);
                DataViewRenderHelper.encodeRecursive(context, footer);
                out.endElement("div");
                out.write("\n");
            }
            out.endElement("div");
            out.write("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        UIDataView view;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        UIDataView uIDataView = view = (UIDataView)component;
        synchronized (uIDataView) {
            view.setRowIndex(-1);
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        out.setViewStateChanged(false);
        if (view.isNeedReload()) {
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)view);
            out.writeActionScript(jsvar + ".store.load();\n");
            view.setNeedReload(false);
        }
    }

    public boolean isRepaintable(UIComponent component) {
        log.fine("DataView[" + component.getId() + "] cannot be repaint.");
        return false;
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.View", "Ext.data.FacesProxy"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeResourceBegin(FacesContext context, ResourceManager manager, UIComponent component) {
        String ondataready;
        String clientId;
        UIDataView view;
        String template = DataViewRenderHelper.getTemplate(context, component);
        if (template == null) {
            throw new FacesException("Missing required template attribute or facet.");
        }
        UIDataView uIDataView = view = (UIDataView)component;
        synchronized (uIDataView) {
            view.setRowIndex(-1);
            clientId = component.getClientId(context);
        }
        ComponentResource resource = (ComponentResource)manager.getRegisteredResource("urn:yui-ext");
        List<UIColumn> columns = DataRendererHelper.getColumns(component);
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        String jsvar = resource.allocVariable(component);
        String dsvar = jsvar + "_ds";
        resource.addVariable(dsvar);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("dataview");
        if (view.getAsync().booleanValue()) {
            fmt.format("%s%s=new %s(%s{", RendererUtils.getJsvarAliasDef((String)dsvar, (Aliases)alias), dsvar, alias.alias("Ext.data.Store"), c.start());
            fmt.format("%s: new %s(%s{%s:%s, %s:{%s:'%s'", c.prop("proxy"), alias.alias("Ext.data.FacesScriptProxy"), c.start(), c.prop("url"), AjaxDataViewRenderer.getActionURLVar(), c.prop("extraParams"), DELEGATE_PARAM, view.getId());
            if (form != null) {
                fmt.format(",'%s':''", FormRenderer.getPostbackFieldName((FacesContext)context, (UIComponent)form));
            }
            fmt.format(",'%s':''", "__view_delegate_request__");
            fmt.format("}}%s),", c.end());
            fmt.format("%s: new %s(%s{%s:'%s',%s:'%s'}%s,[", c.prop("reader"), alias.alias("Ext.data.FacesReader"), c.start(), c.prop("root"), JSON_ROOT, c.prop("totalProperty"), JSON_TOTAL, c.end());
            buf.append(DataRendererHelper.encodeRecordDefinition(columns));
            fmt.format("])}%s);", c.end());
            fmt.format("%s.load();", alias.var(dsvar));
        } else {
            fmt.format("%s%s=new %s({fields:[", RendererUtils.getJsvarAliasDef((String)dsvar, (Aliases)alias), dsvar, alias.alias("Ext.data.SimpleStore"));
            buf.append(DataRendererHelper.encodeRecordDefinition(columns));
            buf.append("]});");
            fmt.format("%s.loadData([%s]);", alias.var(dsvar), DataRendererHelper.encodeArrayData(context, view, columns));
            view.setValue(null);
        }
        String containerId = view.getContainer();
        if (containerId == null) {
            containerId = clientId;
        }
        fmt.format("%s%s=new %s(%s{%s:'',%s:%s,%s:new %s('<tpl for=\".\">',%s,'</tpl>')", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.DataView"), c.start(), c.prop("itemSelector"), c.prop("store"), alias.var(dsvar), c.prop("tpl"), alias.alias("Ext.XTemplate"), HtmlEncoder.enquote((String)template.trim()));
        DataViewRenderHelper.encodeViewConfig(fmt, view, resource, c);
        fmt.format("}%s);", c.end());
        c = alias.configBuilder("panel");
        fmt.format("new %s(%s{%s:'%s',%s:%s,%s:false,%s:false", alias.alias("Ext.Panel"), c.start(), c.prop("renderTo"), containerId, c.prop("items"), alias.var(jsvar), c.prop("border"), c.prop("bodyBorder"));
        fmt.format("}%s);", c.end());
        List<UIPager> pagers = PagerHelper.getAllPagersFor(context, (UIComponent)view);
        if (pagers.size() > 0) {
            resource.addInitScript(buf.toString());
            buf.setLength(0);
            int start = pagers.get(0).getStart();
            int pageSize = pagers.get(0).getPageSize();
            view.setFirst(start);
            view.setRows(pageSize);
            for (UIPager pager : pagers) {
                pager.setStart(start);
                pager.setPageSize(pageSize);
                pager.bind(context, dsvar);
            }
        }
        if ((ondataready = (String)view.getAttributes().get("ondataready")) == null) {
            ondataready = "";
        }
        fmt.format("%s.on('load',function(){this.refresh();%s},%s);", alias.var(dsvar), ondataready, alias.var(jsvar));
        resource.releaseVariable(jsvar);
        resource.addInitScript(buf.toString());
    }

    public void encodeInitScriptBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource.getResourceInstance((ResourceManager)rm).addInitScript(AjaxDataViewRenderer.getActionURLVarDefinition((FacesContext)context));
    }

    private void loadData(FacesContext context, UIDataView data) throws IOException {
        int rows;
        int rowIndex;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        int totalRows = data.getRowCount();
        String startParam = (String)paramMap.get("start");
        if (startParam != null) {
            rowIndex = Integer.parseInt(startParam);
            data.setFirst(rowIndex);
        } else {
            rowIndex = data.getFirst();
        }
        String limitParam = (String)paramMap.get("limit");
        if (limitParam != null) {
            rows = Integer.parseInt(limitParam);
            data.setRows(rows);
        } else {
            rows = data.getRows();
        }
        List<UIColumn> columns = DataRendererHelper.getColumns((UIComponent)data);
        JSONArray viewData = DataRendererHelper.encodeJsonData(context, data, columns, rowIndex, rows);
        JSONObject json = new JSONObject();
        json.put((Object)JSON_TOTAL, (Object)totalRows);
        json.put((Object)JSON_ROOT, (Object)viewData);
        String[] state = FacesUtils.getViewState((FacesContext)context);
        if (state[0] != null) {
            json.put((Object)JSON_VIEWSTATE, (Object)state[0]);
        }
        JSONObject params = new JSONObject();
        params.put((Object)"start", (Object)rowIndex);
        json.put((Object)JSON_PARAMS, (Object)params);
        DataRendererHelper.sendJsonData(context, json);
    }
}

