/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Formatter;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.operamasks.faces.component.widget.UICalendar;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxInputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxDateMenuRenderer
extends AjaxInputRenderer {
    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        if (uc.isUpdateValue(component)) {
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
            String value = this.getCurrentValue(context, component);
            Formatter fmt = new Formatter();
            if (value != null && value.length() != 0) {
                fmt.format("%s.picker.setValue(Date.parseDate('%s','%s'));", jsvar, value, "m/d/Y");
            }
            AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
            out.writeScriptBlock(fmt.toString());
        }
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.menu.DateMenu"};
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        String clientId = component.getClientId(context);
        String jsvar = resource.allocVariable(component);
        String value = this.getCurrentValue(context, component);
        String onchange = (String)component.getAttributes().get("onchange");
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        UIForm parentForm = FacesUtils.getParentForm((UIComponent)component);
        String dateMenuOnSelect = null;
        if (parentForm != null) {
            dateMenuOnSelect = alias.var("dmo_" + jsvar);
            fmt.format("%s=OM.buildDateMenuOnSelect(%s,%s);", dateMenuOnSelect, FacesUtils.getJsvar((FacesContext)context, (UIComponent)parentForm), clientId);
        }
        buf.append(RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias));
        fmt.format("%s=new %s({id:'%s',cls:'x-date-menu'});", jsvar, alias.alias("Ext.menu.DateMenu"), clientId);
        jsvar = alias.var(jsvar);
        if (value != null) {
            fmt.format("%s.picker.setValue(%s('%s', '%s'));", jsvar, alias.alias("Date.parseDate"), value, "m/d/Y");
        }
        fmt.format("%s.on('select', function(o,d){", jsvar);
        if (onchange != null) {
            if (parentForm != null && dateMenuOnSelect != null) {
                buf.append(dateMenuOnSelect).append("(o,d);");
            }
            buf.append(onchange);
            if (!onchange.endsWith(";")) {
                buf.append(";");
            }
        }
        buf.append(RendererUtils.encodeAjaxSubmit((FacesContext)context, (UIComponent)component, (String)jsvar, (String[])new String[]{HtmlEncoder.enquote((String)clientId), "d.format('m/d/Y')"}));
        buf.append("});");
        UIMenu parentMenu = MenuRendererHelper.getParentMenu(component);
        if (parentMenu != null) {
            String text = MenuRendererHelper.getItemText(context, component, false);
            fmt.format("%s.addItem(new %s(%s{", alias.var(FacesUtils.getJsvar((FacesContext)context, (UIComponent)parentMenu)), alias.alias("Ext.menu.Item"), c.start());
            MenuRendererHelper.encodeItemConfig(fmt, context, component, text, c);
            fmt.format(",%s:%s", c.prop("menu"), jsvar);
            fmt.format("}%s));", c.end());
        }
        resource.releaseVariable(jsvar);
        resource.addInitScript(fmt.toString());
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        return UICalendar.getFormattedValue(currentValue);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String newValue = (String)submittedValue;
        ValueExpression binding = component.getValueExpression("value");
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null) {
            if (binding == null) {
                return UICalendar.getConvertedValue(newValue);
            }
            Class valueType = binding.getType(context.getELContext());
            if (valueType == null || valueType == String.class || valueType == Object.class) {
                return newValue;
            }
            converter = context.getApplication().createConverter(valueType);
            if (converter == null) {
                return UICalendar.getConvertedValue(newValue);
            }
        }
        return converter.getAsObject(context, component, newValue);
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (RendererUtils.isDisabledOrReadonly((UIComponent)component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId)) {
            String newValue = (String)paramMap.get(clientId);
            this.setSubmittedValue(component, newValue);
            ActionEvent event = new ActionEvent(component);
            PartialUpdateCandidates.addLinkedUpdate((UIComponent)component);
            component.queueEvent((FacesEvent)event);
        }
    }
}

