/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.widget.UIDrawImage;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.widget.helper.DrawImageHelper;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.util.Base64;

public class AjaxDrawImageRenderer
extends AjaxRendererBase {
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UIDrawImage drawImage = (UIDrawImage)component;
        Object value = drawImage.getValue();
        ResponseWriter out = context.getResponseWriter();
        if (value instanceof String && !((String)value).startsWith("resource:")) {
            this.encodeImageElement(out, component, this.src(context, component), "value");
        } else {
            boolean inlined = this.isInline(context, component);
            String url = this.getUrl(context, component, inlined);
            this.encodeImageElement(out, component, url, null);
        }
    }

    private void encodeImageElement(ResponseWriter out, UIComponent component, String url, String property) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        out.startElement("img", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        out.writeAttribute("src", (Object)url, null);
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component);
        out.endElement("img");
    }

    private String getUrl(FacesContext context, UIComponent component, boolean inlined) throws IOException {
        String url;
        DrawImageHelper info = new DrawImageHelper((UIDrawImage)component);
        if (inlined) {
            url = this.encodeInlineImage(context, info);
        } else {
            url = this.getURLForIE(context, component);
            info.save(context);
        }
        return url;
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        String script;
        if (Boolean.FALSE.equals(((UIDrawImage)component).isNeedRefresh())) {
            return;
        }
        String clientId = component.getClientId(context);
        boolean inlined = this.isInline(context, component);
        UIDrawImage drawImage = (UIDrawImage)component;
        Object value = drawImage.getValue();
        ResponseWriter out = context.getResponseWriter();
        String url = null;
        url = value instanceof String && !((String)value).startsWith("resource:") ? this.src(context, component) : this.getUrl(context, component, inlined);
        if (inlined) {
            script = String.format("OM.F('%s','src','%s');\n", clientId, url);
        } else {
            String fixedUrl = null;
            fixedUrl = url.indexOf("?") == -1 ? url + "?_rnd=" : url + "&_rnd=";
            script = String.format("OM.F('%s','src','%s'+new Date().getTime());\n", clientId, fixedUrl);
        }
        assert (out instanceof AjaxResponseWriter);
        ((AjaxResponseWriter)out).writeScriptBlock(script);
    }

    private String getURLForIE(FacesContext context, UIComponent component) {
        StringBuilder buf = new StringBuilder();
        String clientId = component.getClientId(context);
        String url = RendererUtils.getActionURL((FacesContext)context);
        buf.append(url);
        buf.append(url.indexOf(63) == -1 ? (char)'?' : '&');
        buf.append("__view_delegate_request__=&");
        buf.append("__stream.response__=&");
        buf.append("org.operamasks.faces.DrawImage").append('=').append(clientId);
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)kid;
            buf.append('&');
            buf.append(param.getName());
            buf.append('=');
            buf.append(param.getValue());
        }
        String encoding = context.getResponseWriter().getCharacterEncoding();
        return HtmlEncoder.encodeURI((String)buf.toString(), (String)encoding);
    }

    private boolean isInline(FacesContext context, UIComponent component) {
        if (!((UIDrawImage)component).isInline().booleanValue()) {
            return false;
        }
        String ua = (String)context.getExternalContext().getRequestHeaderMap().get("User-Agent");
        return ua == null || (ua = ua.toLowerCase()).indexOf("msie") == -1 || ua.indexOf("opera") != -1;
    }

    private String encodeInlineImage(FacesContext context, DrawImageHelper info) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        info.encode(context, stream);
        String data = Base64.encode((byte[])stream.toByteArray());
        return "data:" + info.getType() + ";base64," + data;
    }

    protected String src(FacesContext context, UIComponent component) {
        Object value = ((UIGraphic)component).getValue();
        if (value == null) {
            return "";
        }
        String url = value.toString();
        url = context.getApplication().getViewHandler().getResourceURL(context, url);
        if (component instanceof UIDrawImage && ((UIDrawImage)component).isDynamic().booleanValue()) {
            url = context.getExternalContext().encodeResourceURL(url);
        }
        return url;
    }
}

