/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.grid.GridSelectionModel;
import org.operamasks.faces.component.grid.RowSelectionModel;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.component.grid.impl.UIEditDataGrid;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.event.AjaxEventDesc;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.widget.ajax.AjaxDataGridRenderer;
import org.operamasks.faces.render.widget.helper.DataGridRenderHelper;
import org.operamasks.faces.render.widget.helper.EditDataGridRenderHelper;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;
import org.operamasks.org.json.simple.JSONValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxEditDataGridRenderer
extends AjaxDataGridRenderer {
    private static final String MODIFIED_DATA_FIELD = "_modifiedData";
    private static final String REMOVED_DATA_FIELD = "_removedData";
    private static final String CLIENT_ROWS_PARAM = "_clientRows";
    protected static final Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(new HashMap<String, LiteAttributeEncoder>(AjaxDataGridRenderer.liteAttributes){
        {
            this.put("readOnly", new LiteAttributeEncoder(){

                public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                    boolean readOnly = Boolean.TRUE.equals(component.getAttributes().get("readOnly"));
                    out.writeScriptBlock(String.format("%s.setReadOnly(%s);", jsvar, readOnly));
                }
            });
        }
    });

    @Override
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        UIEditDataGrid grid = (UIEditDataGrid)component;
        String clientId = grid.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String gridPostId = (String)paramMap.get("_ajaxDataProxy_datagrid_POST");
        if (grid.getId().equals(gridPostId)) {
            return;
        }
        String modifiedDataValue = (String)paramMap.get(clientId + MODIFIED_DATA_FIELD);
        String removedDataValue = (String)paramMap.get(clientId + REMOVED_DATA_FIELD);
        String clientRows = (String)paramMap.get(clientId + CLIENT_ROWS_PARAM);
        if (clientRows != null) {
            try {
                grid.setClientRows(Integer.parseInt(clientRows));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (modifiedDataValue != null || removedDataValue != null) {
            JSONArray modifiedData = null;
            JSONArray removedData = null;
            JSONObject transData = null;
            try {
                if (modifiedDataValue != null) {
                    modifiedData = (JSONArray)JSONValue.parse((String)modifiedDataValue);
                }
                if (removedDataValue != null) {
                    removedData = (JSONArray)JSONValue.parse((String)removedDataValue);
                }
                transData = new JSONObject();
                transData.put((Object)"modifed", (Object)modifiedData);
                transData.put((Object)"removed", (Object)removedData);
                grid.setTransData(transData);
            }
            catch (Throwable e) {
                // empty catch block
            }
            EditDataGridRenderHelper.applyData(context, grid, new EditDataGridRenderHelper.ChangedData(modifiedData, removedData));
            AjaxHtmlResponseWriter out = (AjaxHtmlResponseWriter)context.getResponseWriter();
            if (out != null) {
                out.setViewStateChanged();
            }
        }
    }

    @Override
    protected void registerAjaxEvents(UIDataGrid grid, String jsvar) {
        super.registerAjaxEvents(grid, jsvar);
        UIEditDataGrid editGrid = (UIEditDataGrid)grid;
        grid.getAjaxEvents().add(new AjaxEventDesc(jsvar, "beforeedit", editGrid.getOnbeforeedit()));
        grid.getAjaxEvents().add(new AjaxEventDesc(jsvar, "afteredit", editGrid.getOnafteredit()));
    }

    @Override
    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeAjaxEnd(context, component);
        UIEditDataGrid grid = (UIEditDataGrid)component;
        Formatter fmt = new Formatter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid);
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        if (grid.isCommit()) {
            fmt.format("%s.getStore().commitChanges();\n", jsvar);
            fmt.format("%s.reset();\n", jsvar);
            grid.setCommit(false);
            grid.setAddedData(null);
            grid.setModifiedData(null);
            grid.setRemovedData(null);
        }
        if (grid.getInsertRow() != -1 && !Boolean.TRUE.equals(grid.getReadOnly())) {
            fmt.format("%s.stopEditing();\n", jsvar);
            fmt.format("var newRecordDefinition = Ext.data.Record.create(%s);\n", EditDataGridRenderHelper.createRecord(grid));
            String modifiedVar = jsvar + "_modified";
            StringBuilder modified = new StringBuilder();
            List insertDataList = this.constructInsertDataList(grid);
            fmt.format("var newRecord,%s;", modifiedVar);
            for (int i = insertDataList.size() - 1; i > -1; --i) {
                fmt.format("%s=[];\n", modifiedVar);
                fmt.format("newRecord = new newRecordDefinition(%s);\n", EditDataGridRenderHelper.encodeRecordValue(grid, insertDataList.get(i), modified, modifiedVar));
                fmt.format("newRecord.dirty = true;\n", new Object[0]);
                fmt.format(modified.toString(), new Object[0]);
                fmt.format("newRecord.modified = %s;\n", modifiedVar);
                fmt.format("%s.getStore().insert(%d, newRecord);\n", jsvar, grid.getInsertRow());
                fmt.format("%s.getStore().afterEdit(newRecord);\n", jsvar);
            }
            fmt.format("%s.getView().refresh();\n", jsvar);
            fmt.format("%s.startEditing(%s.getStore().findInsertIndex(newRecord) || 0, 0);\n", jsvar, jsvar);
            grid.insertRow(-1);
        }
        String clientRowsVar = grid.getClientId(context) + CLIENT_ROWS_PARAM;
        fmt.format("OM.ajax.removeRequestParameter('%s');\n", clientRowsVar);
        fmt.format("OM.ajax.addRequestParameter('%s',%s.getStore().getCount());\n", clientRowsVar, jsvar);
        GridSelectionModel selectionModel = grid.getSelectionModel();
        if (selectionModel == null || selectionModel instanceof RowSelectionModel) {
            String clientId = grid.getClientId(context);
            fmt.format("var _sm = %s.getSelectionModel();\n", jsvar);
            fmt.format("var client_rows = [];\n", new Object[0]);
            fmt.format("var items = _sm.getSelections();\n", new Object[0]);
            fmt.format("var dsvar = %s.getStore();", jsvar);
            fmt.format("if (items) {\n", new Object[0]);
            fmt.format("for (var i = 0; i < items.length; i++ ) {\n", new Object[0]);
            fmt.format("client_rows.push(dsvar.indexOf(_sm.getSelections()[i]));\n", new Object[0]);
            fmt.format("}\n", new Object[0]);
            fmt.format("}\n", new Object[0]);
            fmt.format("OM.ajax.removeRequestParameter('%s%s');\n", clientId, "_selectedClientRows");
            fmt.format("OM.ajax.addRequestParameter('%s%s', client_rows);\n", clientId, "_selectedClientRows");
        }
        out.setViewStateChanged();
        DataGridRenderHelper.addOperationScript(fmt.toString());
    }

    private List constructInsertDataList(UIEditDataGrid grid) {
        Object insertData = grid.getInsertRowData();
        List<Object> insertDataList = null;
        if (insertData == null) {
            insertDataList = new ArrayList<Object>();
            insertDataList.add(null);
        } else if (insertData instanceof List) {
            insertDataList = (List)insertData;
        } else if (Object[].class.isAssignableFrom(insertData.getClass())) {
            insertDataList = Arrays.asList((Object[])insertData);
        } else {
            insertDataList = new ArrayList();
            insertDataList.add(insertData);
        }
        return insertDataList;
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeHtmlEnd(context, component);
        ResponseWriter out = context.getResponseWriter();
        String clientId = component.getClientId(context);
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("id", (Object)(clientId + MODIFIED_DATA_FIELD), "clientId");
        out.writeAttribute("name", (Object)(clientId + MODIFIED_DATA_FIELD), "clientId");
        out.endElement("input");
        out.startElement("input", component);
        out.writeAttribute("type", (Object)"hidden", null);
        out.writeAttribute("id", (Object)(clientId + REMOVED_DATA_FIELD), "clientId");
        out.writeAttribute("name", (Object)(clientId + REMOVED_DATA_FIELD), "clientId");
        out.endElement("input");
    }

    @Override
    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        String[] superJsPackages = super.getDependedJSPackages(context, component);
        ArrayList<String> resultJsPackageList = new ArrayList<String>();
        for (String pkgName : superJsPackages) {
            resultJsPackageList.add(pkgName);
        }
        resultJsPackageList.add("Ext.grid.FacesEditorGrid");
        return resultJsPackageList.toArray(new String[0]);
    }

    @Override
    protected String getExtClass() {
        return "Ext.grid.FacesEditorGrid";
    }

    @Override
    protected void encodeGridOptions(StringBuilder buf, FacesContext context, UIDataGrid grid, String jsvar, String dsvar, String smvar, String cmvar) {
        super.encodeGridOptions(buf, context, grid, jsvar, dsvar, smvar, cmvar);
        Formatter fmt = new Formatter(buf);
        UIForm form = FacesUtils.getParentForm((UIComponent)grid);
        String gridClientId = HtmlEncoder.enquote((String)grid.getClientId(context));
        if (form != null) {
            Aliases alias = Aliases.getInstance((FacesContext)context);
            fmt.format("%s('%s',%s);", alias.alias("OM.updateFormValidateFieldIds"), form.getClientId(context), gridClientId);
        }
    }

    @Override
    protected ExtConfig getSelectionModelConfig(UIDataGrid grid) {
        ExtConfig config = super.getSelectionModelConfig(grid);
        Boolean flag = ((UIEditDataGrid)grid).getMoveEditorOnEnter();
        if (flag != null && flag.booleanValue()) {
            config.set("moveEditorOnEnter", true);
        }
        return config;
    }

    @Override
    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        String clientId = component.getClientId(context);
        config.set("id", clientId);
        config.set("modifiedDataField", clientId + MODIFIED_DATA_FIELD);
        config.set("removedDataField", clientId + REMOVED_DATA_FIELD);
        String invalidTextTemplate = (String)component.getAttributes().get("invalidTextTemplate");
        if (invalidTextTemplate != null && invalidTextTemplate.length() > 0) {
            config.set("invalidTextTemplate", invalidTextTemplate);
        }
    }

    public void removeSelections(UIEditDataGrid grid) {
        if (!Boolean.TRUE.equals(grid.getReadOnly())) {
            RendererUtils.addOperationScript((String)new StringBuffer(FacesUtils.getJsvar((FacesContext)FacesContext.getCurrentInstance(), (UIComponent)grid)).append(".remove();").toString());
        }
    }

    public void remove(UIEditDataGrid grid, int row) {
        if (!Boolean.TRUE.equals(grid.getReadOnly())) {
            RendererUtils.addOperationScript((String)new StringBuffer(FacesUtils.getJsvar((FacesContext)FacesContext.getCurrentInstance(), (UIComponent)grid)).append(".remove(").append(row).append(");").toString());
        }
    }

    private void fillback(UIEditDataGrid grid, int row, String field, String value) {
        FacesContext context = FacesContext.getCurrentInstance();
        StringBuffer buf = new StringBuffer();
        Formatter fmt = new Formatter(buf);
        fmt.format("OM.grid.fillback(%s, %d, '%s', '%s');", FacesUtils.getJsvar((FacesContext)context, (UIComponent)grid), row, field, value);
        RendererUtils.addOperationScript((String)buf.toString());
    }

    @Override
    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

