/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.faces.component.ajax.AjaxProgress;
import org.operamasks.faces.component.widget.UIFileUpload;
import org.operamasks.faces.component.widget.UIFileUploadProgress;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.operamasks.resources.Resources;

public class AjaxFileUploadRenderer
extends AjaxRendererBase {
    public static final Object REQUEST_PARAM_POST = "__FILEUPLOAD_KEY__";
    private Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        UIForm parentForm = FacesUtils.getParentForm((UIComponent)component);
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)context.getExternalContext().getRequest())) {
            this.renderFileUploadField(context, parentForm, component);
        }
    }

    private void renderFileUploadField(FacesContext context, UIForm form, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (form != null && this.isFirstFileUploadComponent(context, form, component)) {
            this.modifyFormToSupportFileUpload(context, form, component);
        }
        this.encodeComponent(writer, component);
    }

    private void encodeComponent(ResponseWriter writer, UIComponent component) throws IOException {
        UIFileUpload fileUpload = (UIFileUpload)component;
        MethodExpression uploadListener = fileUpload.getUploadListener();
        String writeTo = fileUpload.getWriteTo();
        if (writeTo == null && uploadListener == null) {
            throw new FacesException("Neither attribute 'writeTo' or 'uploadListener' is set.");
        }
        String codeFragment = fileUpload.getRich() == null || fileUpload.getRich() == false ? String.format("\n<div id='%1$s_container' style='position:relative;'>\n<input id='%1$s' name='%1$s' type='file' />\n</div>", component.getId()) : String.format("\n<table id='%1$s_container'><tr><td><input type='text' id='%1$s_fake_input' %2$s /></td><td><div style='display: block; height: 25px; overflow: hidden;'>%3$s<span style='height: 20px; width:65px; display: block; overflow: hidden; cursor: pointer; position: relative; top: -20px; text-align: right;'><input id='%1$s' name='%1$s' type='file' hidefocus='true' style='outline:none; -moz-opacity: 0; filter: alpha(opacity : 0); opacity: 0; float: right; height:100%%; width:auto!important;*width:65px!important; cursor: pointer;' onselect=\"document.getElementById('%1$s_fake_input').select();\" onchange=\"document.getElementById('%1$s_fake_input').value=document.getElementById('%1$s').value;\" onkeyup=\"document.getElementById('%1$s_fake_input').value=document.getElementById('%1$s').value;\"/></span></div></td></tr></table>", component.getId(), this.getStylingCodeFragment(fileUpload), this.getButtonFragment(fileUpload));
        writer.write(codeFragment);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(((Object)((Object)this)).getClass().getSimpleName() + " : " + FacesUtils.getComponentDesc((UIComponent)component) + " is encoded as [" + codeFragment + "\n]");
        }
    }

    private String getStylingCodeFragment(UIFileUpload fileUpload) {
        String style = fileUpload.getStyle();
        String styleClass = fileUpload.getStyleClass();
        if (style == null && styleClass == null) {
            style = "width:160px";
            styleClass = "x-form-text x-form-field";
        }
        return this.getStyleClassCodeFragment(styleClass) + " " + this.getStyleCodeFragment(style);
    }

    private String getStyleCodeFragment(String style) {
        if (style == null) {
            return "";
        }
        return "style='" + style + "'";
    }

    private String getStyleClassCodeFragment(String styleClass) {
        if (styleClass == null) {
            return "";
        }
        return " class='" + styleClass + "'";
    }

    private String getButtonFragment(UIFileUpload fileUpload) {
        if (fileUpload.getBrowseIcon() != null) {
            return "<a><img src='" + fileUpload.getBrowseIcon() + "'></a>";
        }
        return this.getExtButtonCodeFragment(fileUpload.getId());
    }

    private String getExtButtonCodeFragment(String componentId) {
        String codeFragment = String.format("<table style='width: auto;' id='%1$s_btn_table' class='x-btn-wrap x-btn' border='0' cellpadding='0' cellspacing='0'><tbody><tr><td class='x-btn-left'><i>&nbsp;</i></td><td class='x-btn-center'><em unselectable='on'><button id='%1$s_button' class='x-btn-text' type='button'>" + this.getButtonValue() + "</button>" + "</em>" + "</td>" + "<td class='x-btn-right'>" + "<i>&nbsp;</i>" + "</td>" + "</tr>" + "</tbody>" + "</table>", componentId);
        return codeFragment;
    }

    private String getButtonValue() {
        return Resources._T((String)"UI_FILE_UPLOAD_BROWSE");
    }

    private void modifyFormToSupportFileUpload(FacesContext context, UIForm form, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String code = this.getFileUploadSupportCode(context, form, component);
        writer.write(code);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(((Object)((Object)this)).getClass().getSimpleName() + " : Form of id '" + form.getId() + "' is modified to support file upload, by javascript [\n" + code + "\n]");
        }
    }

    private String getFileUploadSupportCode(FacesContext context, UIForm form, UIComponent component) {
        return String.format("\n<script type=\"text/javascript\">\nfile_upload_cb_func=function(){};\nif(typeof(changeCbFunc) == 'undefined'){\nchangeCbFunc = function(source, url, params, immediate){\nreturn function(){\nvar form_var = OM.ajax.getParentForm(source);\nform_var.enctype = form_var.oldEnctype;\nform_var.target = form_var.oldTarget;\nform_var.action = form_var.oldAction;\nOM.ajax.ajaxSubmit(source, url, params, immediate);\n};\n}\n}\nvar currentTime = new Date().getTime()\nif(typeof(OM.ajax.ajaxSubmit) == 'undefined'){\nOM.ajax.ajaxSubmit = OM.ajax.submit;\n}\nif(typeof(OM.ajax.submit.overwrite) == 'undefined'){\nOM.ajax.submit = function(source, url, params, immediate) {\nvar requestId = Math.floor(Math.random()*0xFFFFFFFF);\nvar sourceForm = this.getParentForm(source);\nif (sourceForm && sourceForm.has_file_upload) {\nsourceForm.oldEnctype = sourceForm.enctype;\nsourceForm.oldTarget = sourceForm.target;\nsourceForm.oldAction = sourceForm.action;\nsourceForm.enctype = 'multipart/form-data';\nsourceForm.action = sourceForm.action + '&' + '" + REQUEST_PARAM_POST + "' + '=' + '" + component.getClientId(context) + "' + '&' + '" + "__view_delegate_request__" + "' + '=&_request_identifier=' + requestId;" + "\nsourceForm.target = sourceForm.file_upload_iframe_name;" + "%4$s" + "\nfile_upload_cb_func = changeCbFunc(source, url, params, immediate);" + "\nsourceForm.nonAjaxSubmit();" + "\n}else{" + "\nOM.ajax.ajaxSubmit(source, url, params, immediate);" + "\n}" + "\n};" + "\nOM.ajax.submit.overwrite=true;" + "\n}" + "\n//-->" + "\n</script>" + "\n<iframe id='%3$s' name='%3$s' style='display:none' onload='file_upload_cb_func();'></iframe>" + "\n<script type=\"text/javascript\">" + "\n<!--" + "\nif(Ext&&Ext.onReady){" + "\nExt.onReady(function(){" + "\nvar parentForm = document.getElementById('%2$s');" + "\nparentForm.has_file_upload=true;" + "\nparentForm.file_upload_iframe_name='%3$s';" + "\n});" + "\n}" + "\n//-->" + "\n</script>", FacesUtils.makeJavascriptIdentifier((String)form.getClientId(context)) + "_var", form.getClientId(context), this.getHiddenIFrameName(context, form), this.getProgressSupportCode(context, form));
    }

    private Object getProgressSupportCode(FacesContext context, UIForm form) {
        UIFileUploadProgress fileUploadProgress = (UIFileUploadProgress)((Object)FacesUtils.findComponent((UIComponent)form, UIFileUploadProgress.class));
        if (fileUploadProgress == null) {
            return "";
        }
        AjaxProgress progress = (AjaxProgress)((Object)fileUploadProgress.getChildren().get(2));
        return "\n" + FacesUtils.getJsvar((FacesContext)context, (UIComponent)progress) + ".start(requestId);";
    }

    private Object getHiddenIFrameName(FacesContext context, UIForm form) {
        return form.getClientId(context) + "_file_upload_iframe";
    }

    private boolean isFirstFileUploadComponent(FacesContext context, UIForm form, UIComponent component) {
        UIFileUpload firstFileUpload = this.findFirstFileUploadComponent((UIComponent)form);
        return firstFileUpload != null && component.getId().equals(firstFileUpload.getId());
    }

    private UIFileUpload findFirstFileUploadComponent(UIComponent component) {
        List children = component.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (children.get(i) instanceof UIFileUpload) {
                return (UIFileUpload)((Object)children.get(i));
            }
            UIFileUpload findInChildren = this.findFirstFileUploadComponent((UIComponent)children.get(i));
            if (findInChildren == null) continue;
            return findInChildren;
        }
        return null;
    }
}

