/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.html.impl.UIIFrame;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxIFrameRenderer
extends AjaxRendererBase {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxIFrameRenderer() {
        liteAttrCore.put("src", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String clientId = component.getClientId(context);
                String url = (String)component.getAttributes().get("src");
                String fixedURL = FacesUtils.fixURL((String)url);
                String script = null;
                script = fixedURL != null && fixedURL.trim().length() > 0 ? String.format("document.getElementById('%s').contentWindow.location.href='%s';\n", clientId, fixedURL) : String.format("document.getElementById('%s').contentWindow.location.href='about:blank';\n", clientId);
                out.writeScriptBlock(script);
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        UIIFrame iframe = (UIIFrame)component;
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.startElement("iframe", component);
        out.writeAttribute("id", (Object)iframe.getClientId(context), null);
        if (iframe.getAlign() != null) {
            out.writeAttribute("align", (Object)iframe.getAlign(), null);
        }
        if (iframe.getWidth() != null) {
            out.writeAttribute("width", (Object)iframe.getWidth(), null);
        }
        if (iframe.getHeight() != null) {
            out.writeAttribute("height", (Object)iframe.getHeight(), null);
        }
        if (iframe.getFrameborder() != null) {
            out.writeAttribute("frameborder", (Object)iframe.getFrameborder(), null);
        }
        if (iframe.getBorder() != null) {
            out.writeAttribute("border", (Object)iframe.getBorder(), null);
        }
        if (iframe.getName() != null) {
            out.writeAttribute("name", (Object)iframe.getName(), null);
        }
        if (iframe.getScrolling() != null) {
            out.writeAttribute("scrolling", (Object)iframe.getScrolling(), null);
        }
        if (iframe.getSrc() != null) {
            String fixSrc = FacesUtils.fixURL((String)iframe.getSrc());
            out.writeAttribute("src", (Object)fixSrc, null);
        }
        if (iframe.getStyle() != null) {
            out.writeAttribute("style", (Object)iframe.getStyle(), null);
        }
        if (iframe.getStyleClass() != null) {
            out.writeAttribute("class", (Object)iframe.getStyleClass(), null);
        }
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement("iframe");
    }

    public void load(UIIFrame iframe, String url) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)iframe, new String[]{"src"});
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        StringBuilder buf = new StringBuilder();
        this.encodeEnsureLoad(buf, component);
        this.encodeOnload(buf, component);
        resource.addInitScript(buf.toString());
    }

    private void encodeEnsureLoad(StringBuilder buf, UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        Formatter fmt = new Formatter(buf);
        fmt.format("%s(%s);", Aliases.getAlias((String)"OM.iframe.ensureIframeLoad"), HtmlEncoder.enquote((String)component.getClientId(context)));
    }

    private void encodeOnload(StringBuilder buf, UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        UIForm form = FacesUtils.getParentForm((UIComponent)component);
        String onload = (String)component.getAttributes().get("onload");
        if (onload != null) {
            if ((onload = onload.trim()).length() == 0) {
                onload = null;
            } else if (!onload.endsWith(";")) {
                onload = onload + ";";
            }
        }
        Formatter fmt = new Formatter(buf);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        if (form != null) {
            fmt.format("%s.on('%s','load',function(){", alias.alias("Ext.EventManager"), clientId);
            if (onload != null) {
                fmt.format("if(Ext.get('%s').src){%s}else{return false;}", clientId, onload);
            }
            fmt.format("}, this);", new Object[0]);
        } else if (onload != null) {
            fmt.format("%s.on('%s', 'load', function(){if(Ext.get('%s').src){%s}else{return false;}},this);\n", alias.alias("Ext.EventManager"), clientId, clientId, onload);
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.Base"};
    }
}

