/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.widget.menu.UILinkMenuItem;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxOutputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.MenuItemRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.MenuRendererHelper;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxLinkMenuItemRenderer
extends AjaxOutputRenderer
implements MenuItemRenderer {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxLinkMenuItemRenderer() {
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                if (RendererUtils.isDisabled((UIComponent)component)) {
                    out.writeScriptBlock(String.format("%s.disable();", jsvar));
                } else {
                    out.writeScriptBlock(String.format("%s.enable();", jsvar));
                }
            }
        });
        liteAttrCore.put("label", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String text = HtmlEncoder.enquote((String)MenuRendererHelper.getItemText(context, component, false), (Character)Character.valueOf('\''));
                out.writeScriptBlock(String.format("%s.setText(%s);", jsvar, text));
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public String getMenuItemInitScript(FacesContext context, UIComponent component, UIComponent parent) {
        String text = MenuRendererHelper.getItemText(context, component, false);
        String href = this.getHref(context, component);
        String target = (String)component.getAttributes().get("target");
        String handler = (String)component.getAttributes().get("onclick");
        StringBuilder script = new StringBuilder();
        Formatter fmt = new Formatter(script);
        String itemJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        String menuJsVar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("menuitem");
        script.append(RendererUtils.getJsvarAliasDef((String)itemJsVar, (Aliases)alias));
        fmt.format("%s=new %s(%s{", itemJsVar, alias.alias("Ext.menu.Item"), c.start());
        itemJsVar = alias.var(itemJsVar);
        MenuRendererHelper.encodeItemConfig(fmt, context, component, text, c);
        if (href != null) {
            fmt.format(",%s:%s", c.prop("href"), HtmlEncoder.enquote((String)href, (Character)Character.valueOf('\'')));
        }
        if (target != null) {
            fmt.format(",%s:%s", c.prop("hrefTarget"), HtmlEncoder.enquote((String)target, (Character)Character.valueOf('\'')));
        }
        if (handler != null) {
            fmt.format(",%s:function(){%s}", c.prop("handler"), handler);
        }
        fmt.format("}%s);", c.end());
        fmt.format("%s.addItem(%s);", menuJsVar, itemJsVar);
        return script.toString();
    }

    private String getHref(FacesContext context, UIComponent component) {
        StringBuilder buf = new StringBuilder();
        String value = this.getCurrentValue(context, component);
        if (value != null) {
            buf.append(value);
        }
        boolean q = value == null || value.indexOf(63) == -1;
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)kid;
            buf.append(q ? (char)'?' : '&');
            buf.append(param.getName());
            buf.append('=');
            buf.append(param.getValue());
            q = false;
        }
        if (buf.length() == 0) {
            return null;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, buf.toString());
        if (url.startsWith("http://")) {
            return url;
        }
        return context.getExternalContext().encodeResourceURL(url);
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UIMenu menu = MenuRendererHelper.getParentMenu(component);
        if (menu == null) {
            return;
        }
        ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]).addInitScript(this.getMenuItemInitScript(context, component, (UIComponent)menu));
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeAjaxChildren(UIComponent component) {
        return true;
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public void setDisabled(UILinkMenuItem item, boolean disabled) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)item, new String[]{"disabled"});
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

