/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.component.html.HtmlHead;
import org.operamasks.faces.component.html.HtmlPage;
import org.operamasks.faces.component.misc.UIEmulateIE7;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.HtmlPageRendererStub;
import org.operamasks.faces.internal.stub.component.UpdaterRendererStub;
import org.operamasks.faces.internal.stub.component.UpdaterStub;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.ajax.AjaxUpdateMarker;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.resource.SkinManager;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.user.ajax.PartialUpdateManager;
import org.operamasks.faces.util.CompRendererUtils;
import org.operamasks.faces.util.Repainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxPageRenderer
extends AjaxRendererBase
implements HtmlPageRendererStub {
    private static final String HTML_STRICT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String HTML_TRANSITIONAL = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    private static final String HTML_FRAMESET = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\" \"http://www.w3.org/TR/html4/frameset.dtd\">";
    private static final String XHTML_STRICT = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    private static final String XHTML_TRANSITIONAL = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private static final String XHTML_FRAMESET = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">";
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxPageRenderer() {
        liteAttrCore.put("title", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                String title = (String)component.getAttributes().get("title");
                if (title != null) {
                    out.writeScriptBlock("document.title='" + title + "';");
                }
            }
        });
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (CompRendererUtils.hasParentPage(component)) {
            return;
        }
        boolean isXHTML = this.fixupContentType(context);
        String lang = (String)component.getAttributes().get("lang");
        if (lang == null) {
            Locale locale = context.getViewRoot().getLocale();
            lang = locale.getLanguage().replace('_', '-');
        }
        String dir = (String)component.getAttributes().get("dir");
        String title = (String)component.getAttributes().get("title");
        ResponseWriter out = context.getResponseWriter();
        this.writeDocType(out, component, isXHTML);
        out.startElement("html", component);
        if (isXHTML) {
            out.writeAttribute("xmlns", (Object)"http://www.w3.org/1999/xhtml", null);
        }
        if (lang != null) {
            out.writeAttribute("lang", (Object)lang, "lang");
        }
        if (isXHTML && lang != null) {
            out.writeAttribute("xml:lang", (Object)lang, "lang");
        }
        if (dir != null) {
            out.writeAttribute("dir", (Object)dir, "dir");
        }
        out.write("\n");
        out.startElement("head", component);
        out.write("\n");
        if (title != null) {
            out.startElement("title", component);
            out.writeText((Object)title, "title");
            out.endElement("title");
            out.write("\n");
        }
        this.encodePageBegin(context, component);
        out.endElement("head");
        out.write("\n");
        this.encodeBodyBegin(context, component);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (CompRendererUtils.hasParentPage(component)) {
            return;
        }
        this.encodePageEnd(context, component);
        this.encodeBodyEnd(context, component);
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[0]);
        Boolean loadMask = (Boolean)component.getAttributes().get("loadMask");
        if (loadMask != null && loadMask.booleanValue() && !CompRendererUtils.hasParentPage(component)) {
            String clientId = component.getClientId(context);
            StringBuilder buf = new StringBuilder();
            Formatter fmt = new Formatter(buf);
            String loadingId = clientId + "_loading";
            String maskId = clientId + "_loadMask";
            String loadingVar = resource.allocVariable(component) + "_loading";
            String maskVar = resource.allocVariable(component) + "_mask";
            fmt.format("var %s=Ext.get('%s');", loadingVar, loadingId);
            fmt.format("var %s=Ext.get('%s');", maskVar, maskId);
            fmt.format("%s.setOpacity(.8);", maskVar);
            fmt.format("%s.shift({", maskVar);
            fmt.format("xy:%s.getXY(),", loadingVar);
            fmt.format("width:%s.getWidth(),", loadingVar);
            fmt.format("height:%s.getHeight(),", loadingVar);
            buf.append("remove:true,");
            Integer duration = (Integer)component.getAttributes().get("duration");
            if (duration == null) {
                duration = 1;
            }
            fmt.format("duration:%s,", duration);
            buf.append("opacity:.3,");
            buf.append("callback : function(){");
            fmt.format("%s.fadeOut({duration:.2,remove:true});}});", loadingVar);
            resource.addInitScript(fmt.toString());
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        this.buildAjaxUpdaterSubView(context);
        AjaxUpdateMarker marker = PartialUpdateManager.getInstance().getMarker();
        if (!marker.isOrganized()) {
            marker.organize(context);
        }
        Repainter.repaintChildren((FacesContext)context, (UIComponent)component);
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.encodeBegin(context);
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isRepaintNeeded(component) || uc.isSkipped(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.encodeEnd(context);
        cm.reset();
    }

    public void encodePageBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        HtmlHead head = (HtmlHead)((Object)FacesUtils.findComponent((UIComponent)context.getViewRoot(), HtmlHead.class));
        if (head != null && !head.getCache().booleanValue()) {
            out.write("<META HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\"/>");
            out.write("<META HTTP-EQUIV=\"Cache-Control\" CONTENT=\"no-cache\"/>");
            out.write("<META HTTP-EQUIV=\"Expires\" CONTENT=\"0\"/>");
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            response.setHeader("Cache-Control", "no-store");
            response.setHeader("Pragrma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
        if (head != null && Boolean.TRUE.equals(head.getMergeJs())) {
            context.getExternalContext().getRequestMap().put("__MERGE_JS", Boolean.TRUE);
        } else if (head != null && Boolean.FALSE.equals(head.getMergeJs())) {
            context.getExternalContext().getRequestMap().put("__MERGE_JS", Boolean.FALSE);
        }
        if (head != null && Boolean.TRUE.equals(head.getMergeCss())) {
            context.getExternalContext().getRequestMap().put("__MERGE_CSS", Boolean.TRUE);
        } else if (head != null && Boolean.FALSE.equals(head.getMergeCss())) {
            context.getExternalContext().getRequestMap().put("__MERGE_CSS", Boolean.FALSE);
        }
        UIEmulateIE7 emulateIE7 = (UIEmulateIE7)((Object)FacesUtils.findComponent((UIComponent)context.getViewRoot(), UIEmulateIE7.class));
        if (emulateIE7 != null) {
            out.write("<META HTTP-EQUIV=\"X-UA-Compatible\" CONTENT=\"IE=EmulateIE7\" />\n");
        }
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        if (!FacesUtils.isAjaxResponse((FacesContext)context)) {
            ComponentResource.registerJS((ResourceManager)rm, (String[])new String[]{"_ajax.js"});
            this.buildAjaxUpdaterSubView(context);
            UIViewRoot viewRoot = context.getViewRoot();
            rm.consumeResourceRegister(context, (UIComponent)viewRoot);
            rm.consumeInitScriptBegin(context, (UIComponent)viewRoot);
            rm.consumeContainerResources(context, (UIComponent)viewRoot);
            rm.consumeResources(context, (UIComponent)viewRoot);
            rm.consumeInitScriptEnd(context, (UIComponent)viewRoot);
            rm.encodeBegin(context);
        } else {
            this.buildAjaxUpdaterSubView(context);
            Repainter.repaintChildren((FacesContext)context, (UIComponent)component);
        }
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.encodeBegin(context);
    }

    public void encodePageEnd(FacesContext context, UIComponent component) throws IOException {
        ResourceManager.getInstance((FacesContext)context).encodeEnd(context);
        ComponentOperationManager cm = ComponentOperationManager.getInstance((FacesContext)context);
        cm.encodeEnd(context);
        cm.reset();
        ResponseWriter writer = context.getResponseWriter();
        if (writer instanceof AjaxHtmlResponseWriter) {
            ((AjaxHtmlResponseWriter)writer).writeState(context);
        }
    }

    private void encodeBodyEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("body");
        out.endElement("html");
        out.write("\n");
    }

    private String getOnload(FacesContext context, UIComponent component) {
        String resScript = ResourceManager.getInstance((FacesContext)context).getLoadScript(context);
        String userScript = (String)component.getAttributes().get("onload");
        return this.joinScript(resScript, userScript);
    }

    private String getOnunload(FacesContext context, UIComponent component) {
        String resScript = ResourceManager.getInstance((FacesContext)context).getUnloadScript(context);
        String userScript = (String)component.getAttributes().get("onunload");
        return this.joinScript(resScript, userScript);
    }

    private boolean fixupContentType(FacesContext context) {
        Object o;
        boolean isXHTML = false;
        String contentType = context.getResponseWriter().getContentType();
        if (contentType != null) {
            boolean bl = isXHTML = contentType.equals("text/xml") || contentType.equals("application/xhtml+xml") || contentType.equals("application/xml");
        }
        if (isXHTML && !FacesUtils.isAjaxResponse((FacesContext)context) && (o = context.getExternalContext().getResponse()) instanceof HttpServletResponse) {
            try {
                ((HttpServletResponse)o).setContentType("text/html");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return isXHTML;
    }

    private void writeDocType(ResponseWriter out, UIComponent component, boolean isXHTML) throws IOException {
        String doctype = (String)component.getAttributes().get("doctype");
        if (isXHTML) {
            if (doctype == null) {
                doctype = XHTML_STRICT;
            } else if (doctype.equals("strict")) {
                doctype = XHTML_STRICT;
            } else if (doctype.equals("transitional") || doctype.equals("loose")) {
                doctype = XHTML_TRANSITIONAL;
            } else if (doctype.equals("frameset")) {
                doctype = XHTML_FRAMESET;
            }
        } else if (doctype == null) {
            doctype = HTML_TRANSITIONAL;
        } else if (doctype.equals("strict")) {
            doctype = HTML_STRICT;
        } else if (doctype.equals("transitional") || doctype.equals("loose")) {
            doctype = HTML_TRANSITIONAL;
        } else if (doctype.equals("frameset")) {
            doctype = HTML_FRAMESET;
        }
        out.write(doctype);
        out.write("\n");
    }

    private String joinScript(String resScript, String userScript) {
        if (resScript != null && userScript != null) {
            if (!resScript.endsWith(";")) {
                resScript = resScript + ";";
            }
            return resScript + userScript;
        }
        if (resScript != null) {
            return resScript;
        }
        if (userScript != null) {
            return userScript;
        }
        return null;
    }

    private void buildAjaxUpdaterSubView(FacesContext context) {
        Iterator kids = FacesUtils.createChildrenIterator((UIComponent)context.getViewRoot(), (boolean)false);
        while (kids.hasNext()) {
            UpdaterStub updater;
            String subviewId;
            UIComponent kid = (UIComponent)kids.next();
            if (!(kid instanceof UpdaterStub) || (subviewId = (updater = (UpdaterStub)kid).getSubviewId()) == null || "".equals(subviewId) || !Boolean.FALSE.equals(updater.getFrame())) continue;
            try {
                UpdaterRendererStub renderer = (UpdaterRendererStub)FacesUtils.getRenderer((FacesContext)context, (UIComponent)kid);
                ViewHandler vh = context.getApplication().getViewHandler();
                if (!(vh instanceof ViewBuilder)) continue;
                renderer.buildSubviewTree(context, (ViewBuilder)vh, updater);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    private void encodeBodyBegin(FacesContext context, UIComponent component) throws IOException {
        String skin = SkinManager.getCurrentSkin((FacesContext)context);
        String styleClass = (String)component.getAttributes().get("styleClass");
        String skinClass = "skin-" + skin;
        if (styleClass != null) {
            skinClass = styleClass.indexOf(skinClass) != -1 ? styleClass : skinClass + " " + styleClass;
        }
        component.getAttributes().put("styleClass", skinClass);
        String onload = this.getOnload(context, component);
        String onunload = this.getOnunload(context, component);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("body", component);
        RendererUtils.writeIdAttributeIfNecessary((FacesContext)context, (ResponseWriter)out, (UIComponent)component);
        if (onload != null) {
            out.writeAttribute("onload", (Object)onload, "onunload");
        }
        if (onunload != null) {
            out.writeAttribute("onunload", (Object)onunload, "onunload");
        }
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"lang,dir,title,onload,onunload");
        out.write("\n");
        component.getAttributes().put("styleClass", styleClass);
        Boolean loadMask = (Boolean)component.getAttributes().get("loadMask");
        if (loadMask != null && loadMask.booleanValue()) {
            String clientId = component.getClientId(context);
            out.startElement("div", component);
            out.writeAttribute("id", (Object)(clientId + "_loadMask"), "clientId");
            out.writeAttribute("class", (Object)"loading-mask", "class");
            out.endElement("div");
            out.startElement("div", component);
            out.writeAttribute("id", (Object)(clientId + "_loading"), "clientId");
            out.writeAttribute("class", (Object)"loading", "class");
            out.startElement("div", component);
            out.writeAttribute("class", (Object)"loading-indicator", "class");
            String loadMaskText = ((HtmlPage)component).getLoadMaskText();
            if (loadMaskText == null) {
                loadMaskText = "Loading...";
            }
            out.write(loadMaskText);
            out.endElement("div");
            out.endElement("div");
        }
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }

    public boolean isRepaintable(UIComponent component) {
        return false;
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.Base"};
    }
}

