/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.form.impl.UICheckBox;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.component.form.impl.UISimpleHtmlEditor;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.render.html.HtmlResponseWriter;
import org.operamasks.faces.render.widget.ajax.AbstractFieldRenderer;

public class AjaxSimpleHtmlEditorRenderer
extends AbstractFieldRenderer {
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        if (component.getParent() instanceof ToolBar) {
            return;
        }
        UIField field = (UIField)component;
        this.beforeHtmlBegin(context, component);
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        String clientId = component.getClientId(context);
        out.startElement("div", component);
        out.writeAttribute("id", (Object)component.getOuterContainerId(context), null);
        String style = (String)field.getAttributes().get("style");
        String styleClass = (String)field.getAttributes().get("styleClass");
        out.writeAttribute("style", (Object)style, "style");
        out.writeAttribute("styleClass", (Object)styleClass, "styleClass");
        if (!Boolean.TRUE.equals(field.getHideLabel()) && field.getFieldLabel() != null) {
            out.startElement("label", component);
            if (field.getLabelStyle() != null) {
                out.writeAttribute("style", (Object)field.getLabelStyle(), null);
            } else {
                out.writeAttribute("class", (Object)"x-form-item-label", null);
            }
            if (field.getLabelSeparator() != null) {
                out.writeText((Object)(field.getFieldLabel() + field.getLabelSeparator()), (UIComponent)field, null);
            } else {
                out.writeText((Object)field.getFieldLabel(), (UIComponent)field, null);
            }
            out.endElement("label");
        }
        out.startElement("div", component);
        out.writeAttribute("class", (Object)"x-form-item", null);
        out.startElement("div", component);
        out.writeAttribute("class", (Object)"x-form-element", null);
        out.startElement(this.getHtmlMarkup(), component);
        out.writeAttribute("id", (Object)clientId, "clientId");
        out.writeAttribute("name", (Object)clientId, "clientId");
        String inputType = ((UIField)component).getInputType();
        if (!"password".equalsIgnoreCase(inputType)) {
            inputType = "text";
        }
        if (component instanceof UICheckBox) {
            inputType = "checkbox";
        }
        out.writeAttribute("type", (Object)inputType, null);
    }

    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (component.getParent() instanceof ToolBar) {
            return;
        }
        HtmlResponseWriter out = (HtmlResponseWriter)context.getResponseWriter();
        out.endElement(this.getHtmlMarkup());
        out.endElement("div");
        out.endElement("div");
        out.endElement("div");
        out.write("\n");
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.form", "Ext.Toolbar", "Ext.QuickTips", "Ext.menu.Menu", "Ext.ColorPalette", "Ext.ux.HtmlEditorAutoFit"};
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        attrs.remove("value");
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    protected void processExtConfig(FacesContext context, UIComponent component, ExtConfig config) {
        String fontFamilies;
        config.set("plugins", "new Ext.ux.HtmlEditorAutoFit()", true);
        UISimpleHtmlEditor field = (UISimpleHtmlEditor)component;
        if (field.getWidth() == null || field.getWidth() == 0) {
            config.set("width", 515);
        }
        if (field.getHeight() == null || field.getHeight() == 0) {
            config.set("height", 300);
        }
        if ((fontFamilies = field.getFontFamilies()) != null && fontFamilies.length() > 0) {
            config.set("fontFamilies", fontFamilies, true);
        }
    }

    protected String getHtmlMarkup() {
        return "textarea";
    }

    protected String getExtClass(UIComponent component) {
        return "Ext.form.HtmlEditor";
    }
}

