/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.widget.UISlider;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxInputRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxSliderRenderer
extends AjaxInputRenderer {
    private static final String PROXY_ID_SUFFIX = ":slider";
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxSliderRenderer() {
        liteAttrCore.put("disabled", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                boolean disabled = Boolean.TRUE.equals(((UISlider)component).getDisabled());
                if (disabled) {
                    out.writeScriptBlock(String.format("%s.setDisabled(%s);\n", jsvar, disabled));
                }
            }
        });
        liteAttrCore.put("unitIncrement", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Object unitIncrement = component.getAttributes().get("unitIncrement");
                if (unitIncrement != null) {
                    out.writeScriptBlock(String.format("%s.unitIncrement=%s;", jsvar, unitIncrement));
                }
            }
        });
        liteAttrCore.put("blockIncrement", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                Object blockIncrement = component.getAttributes().get("blockIncrement");
                if (blockIncrement != null) {
                    out.writeScriptBlock(String.format("%s.blockIncrement=%s;", jsvar, blockIncrement));
                }
            }
        });
        liteAttrCore.put("minimum", null);
        liteAttrCore.put("maximum", null);
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
    }

    @Override
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        String clientId = component.getClientId(context);
        String proxyId = clientId + PROXY_ID_SUFFIX;
        String value = this.getCurrentValue(context, component);
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)clientId, "clientId");
        RendererUtils.renderPassThruAttributes((ResponseWriter)out, (UIComponent)component, (String)"disabled,width,onchange");
        out.endElement("div");
        out.write("\n");
        if (component.getAttributes().get("proxy") == null) {
            out.startElement("input", null);
            out.writeAttribute("id", (Object)proxyId, null);
            out.writeAttribute("name", (Object)clientId, null);
            out.writeAttribute("type", (Object)"hidden", null);
            if (value != null) {
                out.writeAttribute("value", (Object)value, null);
            }
            out.endElement("input");
            out.write("\n");
        }
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        Set attrs = uc.getAttributeCandidates(component);
        if (attrs.contains("minimum")) {
            Object minimum = component.getAttributes().get("minimum");
            if (minimum != null) {
                out.writeScriptBlock(String.format("%s.setMinimum(%s);\n", jsvar, minimum));
            }
            attrs.remove("minimum");
        }
        if (attrs.contains("maximum")) {
            Object maximum = component.getAttributes().get("maximum");
            if (maximum != null) {
                out.writeScriptBlock(String.format("%s.setMaximum(%s);\n", jsvar, maximum));
            }
            attrs.remove("maximum");
        }
        if (uc.isUpdateValue(component)) {
            String value = this.getCurrentValue(context, component);
            if (value == null) {
                value = "";
            }
            out.writeScriptBlock(String.format("%s.setValue(%s);\n", jsvar, value));
            attrs.remove("value");
        }
        AttributeEncodeHelper.encodeLiteAttributes((FacesContext)context, (UIComponent)component, (AjaxResponseWriter)out, (String)jsvar, (Set)attrs, this.getLiteAttributes());
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.om.Slider"};
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        String clientId = component.getClientId(context);
        String jsvar = resource.allocVariable(component);
        String proxyId = (String)component.getAttributes().get("proxy");
        if (proxyId != null) {
            UIComponent proxy = FacesUtils.getForComponent((FacesContext)context, (String)proxyId, (UIComponent)component);
            if (proxy != null) {
                proxyId = proxy.getClientId(context);
            }
        } else {
            proxyId = clientId + PROXY_ID_SUFFIX;
        }
        Object orientation = component.getAttributes().get("orientation");
        Object width = component.getAttributes().get("width");
        Object minimum = component.getAttributes().get("minimum");
        Object maximum = component.getAttributes().get("maximum");
        Object unitIncrement = component.getAttributes().get("unitIncrement");
        Object blockIncrement = component.getAttributes().get("blockIncrement");
        Object disabled = component.getAttributes().get("disabled");
        String value = this.getCurrentValue(context, component);
        String link = this.getLink(context, component);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        fmt.format("%s=new Ext.om.Slider('%s',{proxy:'%s'", jsvar, clientId, proxyId);
        if (orientation != null) {
            fmt.format(",orientation:'%s'", orientation);
        }
        if (width != null) {
            fmt.format(",width:%s", width);
        }
        if (minimum != null) {
            fmt.format(",minimum:%s", minimum);
        }
        if (maximum != null) {
            fmt.format(",maximum:%s", maximum);
        }
        if (unitIncrement != null) {
            fmt.format(",unitIncrement:%s", unitIncrement);
        }
        if (blockIncrement != null) {
            fmt.format(",blockIncrement:%s", blockIncrement);
        }
        if (disabled != null) {
            fmt.format(",disabled:%s", disabled);
        }
        if (value != null && value.length() != 0) {
            fmt.format(",value:%s", value);
        }
        if (link != null) {
            fmt.format(",link:%s", link);
        }
        buf.append("});\n");
        String onchange = (String)component.getAttributes().get("onchange");
        if (onchange != null && onchange.length() != 0) {
            if (!onchange.endsWith(";")) {
                onchange = onchange + ";";
            }
            fmt.format("%s.on('change', function(){%s});\n", jsvar, onchange);
        }
        resource.addInitScript(buf.toString());
        resource.releaseVariable(jsvar);
    }

    private String getLink(FacesContext context, UIComponent component) {
        String link = (String)component.getAttributes().get("link");
        if (link == null) {
            return null;
        }
        if (link.indexOf(",") == -1) {
            UIComponent forLink = FacesUtils.getForComponent((FacesContext)context, (String)link, (UIComponent)component);
            if (forLink != null) {
                link = forLink.getClientId(context);
            }
            return "'" + link + "'";
        }
        String[] links = link.split(",");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < links.length; ++i) {
            UIComponent forLink = FacesUtils.getForComponent((FacesContext)context, (String)links[i], (UIComponent)component);
            if (forLink != null) {
                links[i] = forLink.getClientId(context);
            }
            buf.append(i == 0 ? "['" : ",'");
            buf.append(links[i]);
            buf.append("'");
        }
        buf.append("]");
        return buf.toString();
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

