/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.UIToolBar;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ResourceRenderer;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ContainerRenderUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.render.widget.helper.ToolBarHelper;

public class AjaxToolBarRenderer
extends AjaxRendererBase {
    public void encodeHtmlBegin(FacesContext context, UIComponent component) throws IOException {
        assert (context != null && component != null);
        if (!component.isRendered()) {
            return;
        }
        UIToolBar toolbar = (UIToolBar)component;
        String forId = toolbar.getTarget();
        if (forId != null && forId.length() > 0) {
            return;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("div", component);
        out.writeAttribute("id", (Object)AjaxToolBarRenderer.getDivId(context, component), "clientId");
        out.endElement("div");
    }

    private static String getDivId(FacesContext context, UIComponent toolbar) {
        String divId = toolbar.getClientId(context);
        return divId.equals(FacesUtils.getJsvar((FacesContext)context, (UIComponent)toolbar)) ? "div_" + divId : divId;
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.Toolbar"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void encodeResourceBegin(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        UIToolBar toolbar = (UIToolBar)component;
        String targetId = toolbar.getTarget();
        if (targetId != null && targetId.length() > 0) {
            return;
        }
        resource.addInitScript(AjaxToolBarRenderer.initScript(context, component));
    }

    private static String initScript(FacesContext context, UIComponent component) {
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("toolbar");
        ContainerRenderUtils.encodeItemInitScript((FacesContext)context, (UIComponent)component, (Formatter)fmt);
        ExtConfig config = new ExtConfig(component);
        config.set("renderTo", AjaxToolBarRenderer.getDivId(context, component));
        fmt.format("%s%s=new %s(%s{%s}%s);", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.Toolbar"), c.start(), config.toScript(c), c.end());
        return buf.toString();
    }

    private static String initScriptAsItem(FacesContext context, UIComponent component) {
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)component);
        Aliases alias = Aliases.getInstance((FacesContext)context);
        Aliases.ConfigBuilder c = alias.configBuilder("toolbar");
        ExtConfig config = new ExtConfig(component);
        String items = ToolBarHelper.encodeItemList(component);
        if (items.length() > 0) {
            config.set("items", items, true);
        }
        fmt.format("%s%s=new %s(%s{%s}%s)", RendererUtils.getJsvarAliasDef((String)jsvar, (Aliases)alias), jsvar, alias.alias("Ext.Toolbar"), c.start(), config.toScript(c), c.end());
        return buf.toString();
    }

    public void encodeInitScriptEnd(FacesContext context, ResourceManager rm, UIComponent component) throws IOException {
        UIToolBar toolbar = (UIToolBar)component;
        String targetId = toolbar.getTarget();
        if (targetId != null && targetId.length() > 0) {
            return;
        }
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        resource.addInitScript(ToolBarHelper.encodeAddItemScript(context, component));
    }

    public String encodeAsItem(UIToolBar toolbar, UIComponent container) {
        FacesContext ctxt = FacesContext.getCurrentInstance();
        return AjaxToolBarRenderer.initScriptAsItem(ctxt, (UIComponent)toolbar);
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        Boolean isNew;
        AjaxResponseWriter out = (AjaxResponseWriter)context.getResponseWriter();
        ResourceManager rm = ResourceManager.getInstance((FacesContext)context);
        ComponentResource resource = ComponentResource.getResourceInstance((ResourceManager)rm);
        ArrayList<String> js_dependencies = new ArrayList<String>();
        for (UIComponent child : component.getChildren()) {
            Renderer renderer;
            isNew = (Boolean)child.getAttributes().get("isNew");
            if (isNew == null || !isNew.booleanValue() || !((renderer = FacesUtils.getRenderer((FacesContext)context, (UIComponent)child)) instanceof ResourceRenderer) || ((ResourceRenderer)renderer).getDependedJSPackages(context, child) == null) continue;
            for (String name : ((ResourceRenderer)renderer).getDependedJSPackages(context, child)) {
                if (js_dependencies.contains(name)) continue;
                js_dependencies.add(name);
            }
        }
        for (String js_dependency : js_dependencies) {
            resource.addJSPackageDependency(js_dependency, true);
        }
        for (UIComponent child : component.getChildren()) {
            isNew = (Boolean)child.getAttributes().get("isNew");
            if (isNew == null || !isNew.booleanValue()) continue;
            String ajaxAddItemScript = ContainerRenderUtils.encodeAjaxAddItemScript((FacesContext)context, (UIComponent)component, (UIComponent)child);
            out.writeScript(ajaxAddItemScript);
            child.getAttributes().put("isNew", Boolean.FALSE);
        }
    }

    public boolean getEncodeHtmlChildren(UIComponent component) {
        return true;
    }

    public boolean getEncodeResourceChildren(UIComponent component) {
        return true;
    }
}

