/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.ajax;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.tree.impl.UITree;
import org.operamasks.faces.component.tree.impl.UITreeNode;
import org.operamasks.faces.developer.ajax.AttributeEncodeHelper;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.ajax.encoder.AjaxStyleEncoder;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.common.AjaxRendererBase;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.widget.helper.TreeRenderHelper;
import org.operamasks.faces.user.ajax.PartialUpdateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxTreeNodeRenderer
extends AjaxRendererBase {
    private static Map<String, LiteAttributeEncoder> liteAttrCore = new HashMap<String, LiteAttributeEncoder>();
    protected static Map<String, LiteAttributeEncoder> liteAttributes = Collections.unmodifiableMap(liteAttrCore);

    public AjaxTreeNodeRenderer() {
        liteAttrCore.put("checked", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                UITreeNode node = (UITreeNode)component;
                UITree tree = TreeRenderHelper.getTree(node);
                Boolean checked = node.getChecked();
                if (tree != null && checked != null) {
                    String treeJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
                    Formatter fmt = new Formatter(new StringBuffer());
                    fmt.format("var treeNode_toCheck=findNodeById(%s.getRootNode(),'%s');\n", treeJsvar, node.getId());
                    fmt.format("try{", new Object[0]);
                    fmt.format("if(treeNode_toCheck){treeNode_toCheck.getUI().setChecked(%s);", checked);
                    fmt.format("%s.getSelectionModel().fireEvent('selectionchange',%s.getSelectionModel(),treeNode_toCheck);", treeJsvar, treeJsvar);
                    fmt.format("}}catch(e){};\n", new Object[0]);
                    out.writeScriptBlock(fmt.toString());
                }
            }
        });
        liteAttrCore.put("icon", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                UITreeNode node = (UITreeNode)component;
                UITree tree = TreeRenderHelper.getTree(node);
                String icon = node.getIcon();
                if (tree != null && icon != null && icon.trim().length() > 0) {
                    String treeJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
                    Formatter fmt = new Formatter(new StringBuffer());
                    fmt.format("var treeNode_toIcon=findNodeById(%s.getRootNode(),'%s');\n", treeJsvar, node.getId());
                    fmt.format("try{if(treeNode_toIcon){treeNode_toIcon.getUI().getIconEl().src = '%s';}}catch(e){};\n", node.getIcon());
                    out.writeScriptBlock(fmt.toString());
                }
            }
        });
        liteAttrCore.put("text", new LiteAttributeEncoder(){

            public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
                UITreeNode node = (UITreeNode)component;
                UITree tree = TreeRenderHelper.getTree(node);
                String text = node.getText();
                if (tree != null && text != null) {
                    String treeJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
                    Formatter fmt = new Formatter(new StringBuffer());
                    fmt.format("var treeNode_toUpdate=findNodeById(%s.getRootNode(),'%s');\n", treeJsvar, node.getId());
                    fmt.format("if(treeNode_toUpdate){treeNode_toUpdate.setText('%s');}\n", node.getText());
                    out.writeScriptBlock(fmt.toString());
                }
            }
        });
        liteAttrCore.put("styleClass", null);
        liteAttrCore.put("style", (LiteAttributeEncoder)AjaxStyleEncoder.getInstance());
    }

    public String[] getDependedJSPackages(FacesContext context, UIComponent component) {
        return new String[]{"Ext.tree.TreePanel", "Ext.tree.CheckTreeNode"};
    }

    public String[] getDependedCSSPackages(FacesContext context, UIComponent component) {
        return new String[]{"All"};
    }

    public void reloadChildren(UITreeNode node) {
        UITree tree = TreeRenderHelper.getTree(node);
        if (tree != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            Formatter fmt = new Formatter(new StringBuffer());
            String jsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
            String jsvar_loader = jsvar + "_loader";
            fmt.format("updateTreeNode(%s, %s, '%s');\n", jsvar, jsvar_loader, node.getId());
            RendererUtils.addOperationScript((String)fmt.toString());
        }
    }

    public void remove(UITreeNode node) {
        UITree tree = TreeRenderHelper.getTree(node);
        if (tree != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            String treeJsvar = FacesUtils.getJsvar((FacesContext)context, (UIComponent)tree);
            Formatter fmt = new Formatter(new StringBuffer());
            fmt.format("var treeNode_toRemove=findNodeById(%s.getRootNode(),'%s');\n", treeJsvar, node.getId());
            fmt.format("if(treeNode_toRemove){treeNode_toRemove.remove();}\n", new Object[0]);
            fmt.format("var treeNode_toExpand=findNodeById(%s.getRootNode(),'%s');\n", treeJsvar, node.getParent().getId());
            fmt.format("if(treeNode_toExpand){treeNode_toExpand.expand();}\n", new Object[0]);
            RendererUtils.addOperationScript((String)fmt.toString());
        }
        node.getParent().getChildren().remove((Object)node);
    }

    public void add(UITreeNode parent, UITreeNode child) {
        FacesContext context = FacesContext.getCurrentInstance();
        Formatter fmt = new Formatter(new StringBuffer());
        fmt.format("var node=findNodeById(%s.getRootNode(),'%s');", FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent.getTree()), parent.getId());
        fmt.format("if(node){node.appendChild(new Ext.tree.TreeNode({", new Object[0]);
        fmt.format(TreeRenderHelper.getTreeNodeConfig(child, null), new Object[0]);
        fmt.format("}));node.expand();}\n", new Object[0]);
        RendererUtils.addOperationScript((String)fmt.toString());
    }

    public void setChecked(UITreeNode node, Boolean checked) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)node, new String[]{"checked"});
    }

    public void setIcon(UITreeNode node, String icon) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)node, new String[]{"icon"});
    }

    public void setText(UITreeNode node, String text) {
        PartialUpdateManager.getInstance().markAttributeUpdate((UIComponent)node, new String[]{"text"});
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if (uc.isSkipped(component) || uc.isRepaintNeeded(component)) {
            return;
        }
        Set attrs = uc.getAttributeCandidates(component);
        AttributeEncodeHelper.encodeLiteAttributes((UIComponent)component, (Set)attrs, this.getLiteAttributes());
    }

    public Map<String, LiteAttributeEncoder> getLiteAttributes() {
        return liteAttributes;
    }
}

