/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import org.operamasks.faces.component.Align;
import org.operamasks.faces.component.grid.GridColumn;
import org.operamasks.faces.component.grid.GridColumnModel;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.LoggerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColumnModelBuilder {
    private static Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");

    private ColumnModelBuilder() {
    }

    public static GridColumnModel constructColumns(GridColumnModel columnModel, UIComponent column, Class<? extends GridColumnModel> modelClass) {
        String summaryRenderer;
        Boolean wrap;
        String editorSelector;
        String styleClass;
        String style;
        Boolean requireEscape;
        String clientFormatter;
        Boolean hidable;
        Boolean hidden;
        Integer width;
        Boolean sortable;
        ValueExpression ve;
        String converterLiteral;
        String align;
        GridColumnModel resultModel;
        try {
            resultModel = columnModel != null ? columnModel : modelClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(modelClass.getName() + "is not instantiable", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(modelClass.getName() + "is not instantiable", ex);
        }
        String id = column.getId();
        GridColumn modelCol = new GridColumn(id);
        String type = (String)ColumnModelBuilder.getAttribute(column, "type");
        if (type != null) {
            modelCol.setType(type);
        }
        if ((align = (String)ColumnModelBuilder.getAttribute(column, "align")) != null) {
            modelCol.setAlign(Align.valueOf(align.toUpperCase()));
        }
        if ((converterLiteral = (String)ColumnModelBuilder.getAttribute(column, "converterLiteral")) != null) {
            modelCol.setConverter(converterLiteral);
        }
        if ((ve = column.getValueExpression("value")) != null) {
            modelCol.setValue(ve.getExpressionString());
        }
        if ((sortable = (Boolean)ColumnModelBuilder.getAttribute(column, "sortable")) != null) {
            modelCol.setEnableSort(sortable);
        }
        if ((width = (Integer)ColumnModelBuilder.getAttribute(column, "width")) != null) {
            modelCol.setWidth(width);
        }
        if ((hidden = (Boolean)ColumnModelBuilder.getAttribute(column, "hidden")) != null) {
            modelCol.setHidden(hidden);
        }
        if ((hidable = (Boolean)ColumnModelBuilder.getAttribute(column, "hidable")) != null) {
            modelCol.setHidable(hidable);
        }
        if ((clientFormatter = (String)ColumnModelBuilder.getAttribute(column, "clientFormatter")) != null && clientFormatter.length() > 0) {
            modelCol.setClientFormatter(clientFormatter);
        }
        if ((requireEscape = (Boolean)ColumnModelBuilder.getAttribute(column, "requireEscape")) == null) {
            requireEscape = Boolean.TRUE;
        }
        modelCol.setRequireEscape(requireEscape);
        Boolean fixed = (Boolean)ColumnModelBuilder.getAttribute(column, "fixed");
        if (fixed != null) {
            modelCol.setFixed(fixed);
        }
        if ((style = (String)ColumnModelBuilder.getAttribute(column, "style")) != null) {
            modelCol.setStyle(style);
        }
        if ((styleClass = (String)ColumnModelBuilder.getAttribute(column, "styleClass")) != null) {
            modelCol.setStyleClass(styleClass);
        }
        if ((editorSelector = (String)ColumnModelBuilder.getAttribute(column, "editorSelector")) != null) {
            modelCol.setEditorSelector(editorSelector);
        }
        if ((wrap = (Boolean)ColumnModelBuilder.getAttribute(column, "wrap")) == null) {
            wrap = Boolean.FALSE;
        }
        modelCol.setWrap(wrap);
        String summaryType = (String)ColumnModelBuilder.getAttribute(column, "summaryType");
        if (summaryType != null) {
            modelCol.setSummaryType(summaryType);
        }
        if ((summaryRenderer = (String)ColumnModelBuilder.getAttribute(column, "summaryRenderer")) != null) {
            modelCol.setSummaryRenderer(summaryRenderer);
        }
        modelCol.setAttachedConverter(((UIOutputColumn)column).getConverter());
        resultModel.put(modelCol);
        return resultModel;
    }

    private static <T> T getAttribute(UIComponent comp, String attributeName) {
        Object result;
        try {
            result = comp.getAttributes().get(attributeName);
        }
        catch (Exception ex) {
            logger.finer(ex.getClass().getSimpleName() + " (" + ex.getMessage() + ") occured while reading attribute '" + attributeName + "' on component '" + FacesUtils.getComponentDesc((UIComponent)comp) + "'.");
            return null;
        }
        return (T)result;
    }

    public static GridColumnModel constructColumns(GridColumnModel columnModel, UIComponent column) {
        return ColumnModelBuilder.constructColumns(columnModel, column, GridColumnModel.class);
    }
}

