/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.operamasks.faces.component.grid.DataSortEvent;
import org.operamasks.faces.component.grid.GridColumn;
import org.operamasks.faces.component.grid.GridColumnModel;
import org.operamasks.faces.component.grid.GridHeaderCell;
import org.operamasks.faces.component.grid.GridHeaderModel;
import org.operamasks.faces.component.grid.SortDirection;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.component.grid.impl.UIEditDataGrid;
import org.operamasks.faces.component.grid.provider.GridDataProvider;
import org.operamasks.faces.component.grid.provider.GridRowDataProvider;
import org.operamasks.faces.render.widget.helper.ColumnModelBuilder;
import org.operamasks.faces.render.widget.helper.DataProviderHelper;
import org.operamasks.faces.render.widget.helper.HeaderModelBuilder;
import org.operamasks.faces.render.widget.yuiext.ComponentOperationManager;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;

public class DataGridRenderHelper {
    public static final String HEADER_MODEL_SET_BY_FRAMEWORK = "HEADER_MODEL_SET_BY_FRAMEWORK";
    public static final String COLUMN_MODEL_SET_BY_FRAMEWORK = "COLUMN_MODEL_SET_BY_FRAMEWORK";
    public static final String JSON_ROOT = "records";
    public static final String JSON_TOTAL = "totalcount";
    public static final String JSON_PARAMS = "params";
    public static final String REQUEST_DATA_PARAM_POST = "_ajaxDataProxy_datagrid_POST";
    public static final String CALLBACK_FUNCTION = "callback";
    private static final String DATA_SORT_PARAM = "sort";
    private static final String DATA_SORT_DIR_PARAM = "dir";
    private static final Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");

    public static void addOperationScript(String script) {
        FacesContext context = FacesContext.getCurrentInstance();
        ComponentOperationManager.getInstance((FacesContext)context).addOperationScript(script);
    }

    public static void mergeColumn(UIDataGrid grid) {
        if (grid.getColumnModel() == null || Boolean.TRUE.equals(grid.getAttributes().get(COLUMN_MODEL_SET_BY_FRAMEWORK))) {
            if (grid.getColumnModel() != null && grid.getColumnModel().getColumnCount() > 0) {
                for (GridColumn column : grid.getColumnModel().getColumns()) {
                    grid.getColumnModel().removeColumn(column);
                }
            }
            for (UIComponent column : grid.getChildren()) {
                if (!(column instanceof UIOutputColumn)) continue;
                GridColumnModel columnModel = grid.getColumnModel();
                grid.setColumnModel(ColumnModelBuilder.constructColumns(columnModel, column));
            }
            grid.getAttributes().put(COLUMN_MODEL_SET_BY_FRAMEWORK, Boolean.TRUE);
        }
    }

    public static void mergeHeader(UIDataGrid grid) {
        if (grid.getHeaderModel() == null || Boolean.TRUE.equals(grid.getAttributes().get(HEADER_MODEL_SET_BY_FRAMEWORK))) {
            if (grid.getHeaderModel() != null && grid.getHeaderModel().getHeadersCount() > 0) {
                for (GridHeaderCell cell : grid.getHeaderModel().getHeader(0).getCells()) {
                    grid.getHeaderModel().getHeader(0).removeCell(cell);
                }
            }
            HashSet<String> columnIds = new HashSet<String>();
            for (UIComponent column : grid.getChildren()) {
                if (!(column instanceof UIOutputColumn)) continue;
                GridHeaderModel headerModel = grid.getHeaderModel();
                if (columnIds.contains(column.getId())) continue;
                grid.setHeaderModel(HeaderModelBuilder.constructHeaders(headerModel, column));
                columnIds.add(column.getId());
            }
            grid.getAttributes().put(HEADER_MODEL_SET_BY_FRAMEWORK, Boolean.TRUE);
        }
    }

    public static String loadData(FacesContext context, UIDataGrid grid, int start, int rows) {
        Object[] data;
        Boolean remoteSort;
        GridDataProvider provider = DataProviderHelper.getProvider(grid);
        int total = provider.getTotalCount();
        if (start < 0 || start >= total) {
            start = 0;
        }
        if (rows < 1) {
            rows = total;
        }
        provider.setStart(start);
        provider.setLimit(rows);
        GridColumnModel model = grid.getColumnModel();
        if (model == null) {
            DataGridRenderHelper.mergeColumn(grid);
            model = grid.getColumnModel();
        }
        if ((remoteSort = grid.getRemoteSort()) != null && remoteSort.booleanValue()) {
            DataGridRenderHelper.broadcastSortEvent(context, grid, provider);
        }
        if ((data = provider.getElements()) == null || data.length == 0 || rows == 0) {
            return "{records:[]}";
        }
        int maxRows = data.length;
        if (rows > maxRows) {
            rows = maxRows;
        }
        JSONObject json = new JSONObject();
        JSONArray jsonData = new JSONArray();
        GridRowDataProvider rowProvider = grid.getRowDataProvider();
        GridRowDataProvider defaultRowProvider = grid.getDefaultRowDataProvider();
        for (int curRow = 0; curRow < rows; ++curRow) {
            Object obj = data[curRow];
            JSONObject rowData = new JSONObject();
            for (GridColumn column : model.getColumns()) {
                Converter converter;
                Object rowValue = null;
                if (rowProvider != null) {
                    rowValue = rowProvider.getLabel(obj, column);
                }
                if (rowValue == null) {
                    rowValue = defaultRowProvider.getLabel(obj, column);
                }
                if ((converter = DataGridRenderHelper.getConverter(context, column)) != null) {
                    rowValue = converter.getAsString(context, (UIComponent)grid, rowValue);
                }
                if (rowValue != null && !(rowValue instanceof Number)) {
                    rowValue = rowValue.toString();
                }
                rowData.put((Object)column.getId(), rowValue);
                rowData.put((Object)"_serverRowIndex", (Object)(start + curRow));
            }
            jsonData.add((Object)rowData);
        }
        if (grid instanceof UIEditDataGrid) {
            ((UIEditDataGrid)grid).setClientRows(rows);
        }
        json.put((Object)JSON_TOTAL, (Object)total);
        json.put((Object)JSON_ROOT, (Object)jsonData);
        JSONObject params = new JSONObject();
        params.put((Object)"start", (Object)start);
        json.put((Object)JSON_PARAMS, (Object)params);
        return json.toString();
    }

    private static Converter getConverter(FacesContext context, GridColumn column) {
        String converterId;
        Converter converter = column.getAttachedConverter();
        if (converter == null && (converterId = column.getConverter()) != null) {
            converter = context.getApplication().createConverter(converterId);
        }
        return converter;
    }

    private static void broadcastSortEvent(FacesContext context, UIDataGrid grid, GridDataProvider provider) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String sortColumnId = (String)requestMap.get(DATA_SORT_PARAM);
        GridColumn column = grid.getColumnModel().getColumn(sortColumnId);
        if (column == null) {
            return;
        }
        String direction = (String)requestMap.get(DATA_SORT_DIR_PARAM);
        DataSortEvent event = new DataSortEvent((UIComponent)grid, column, SortDirection.valueOf(direction));
        grid.broadcast(event);
        if (provider != null) {
            provider.sort(column, SortDirection.valueOf(direction));
        }
    }
}

