/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.component.grid.UIIdColumn;
import org.operamasks.faces.component.grid.UIInputColumn;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.component.grid.impl.UIDataGrid;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.org.json.simple.JSONArray;
import org.operamasks.org.json.simple.JSONObject;
import org.operamasks.resources.Resources;
import org.operamasks.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRendererHelper {
    public static final Object SERVER_ROW_INDEX = "_serverRowIndex";
    public static final String CALLBACK_FUNCTION = "callback";
    public static final String GRID_STATE_PARAM = "_selfstate";
    public static final String JSON_TOTAL = "totalcount";
    public static final String JSON_ROOT = "records";
    public static final String JSON_VIEWSTATE = "viewState";
    public static final String JSON_PARAMS = "params";

    private DataRendererHelper() {
    }

    public static List<UIColumn> getColumns(UIComponent component) {
        ArrayList<UIColumn> result = new ArrayList<UIColumn>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
            result.add((UIColumn)kid);
        }
        return result;
    }

    public static List<UIColumn> getOutputColumns(UIComponent component) {
        ArrayList<UIColumn> result = new ArrayList<UIColumn>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIOutputColumn) || !kid.isRendered()) continue;
            result.add((UIOutputColumn)kid);
        }
        return result;
    }

    public static UIOutputColumn getOutputColumnById(UIComponent component, String id) {
        for (UIComponent kid : component.getChildren()) {
            String columnId;
            if (!(kid instanceof UIOutputColumn) || !kid.isRendered() || (columnId = kid.getId()) == null || !columnId.equals(id)) continue;
            return (UIOutputColumn)kid;
        }
        return null;
    }

    public static List<UIInputColumn> getInputColumns(UIComponent component) {
        ArrayList<UIInputColumn> result = new ArrayList<UIInputColumn>();
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIInputColumn) || !kid.isRendered()) continue;
            result.add((UIInputColumn)kid);
        }
        return result;
    }

    public static String getIdColumn(UIComponent component) {
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIIdColumn) || !kid.isRendered()) continue;
            return kid.getId();
        }
        return null;
    }

    public static String encodeRecordDefinition(List<UIColumn> columns) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (i > 0) {
                buf.append(",");
            }
            buf.append('\'').append(column.getId()).append('\'');
        }
        if (buf.length() > 0) {
            buf.append(',').append('\'').append(SERVER_ROW_INDEX).append('\'');
        }
        return buf.toString();
    }

    public static String encodeRecordValue(List<UIColumn> columns, Object rowData, StringBuilder modified, String modifiedVar) {
        Map<String, Method> preData = new HashMap();
        if (rowData != null) {
            if (rowData instanceof Map) {
                preData = (Map)rowData;
            } else {
                Class<?> rowClass = rowData.getClass();
                try {
                    PropertyDescriptor[] props;
                    BeanInfo beanInfo = Introspector.getBeanInfo(rowClass);
                    for (PropertyDescriptor prop : props = beanInfo.getPropertyDescriptors()) {
                        if (prop.getReadMethod() == null) continue;
                        preData.put(prop.getName(), prop.getReadMethod());
                    }
                }
                catch (IntrospectionException e) {
                    // empty catch block
                }
            }
        }
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            UIColumn column = columns.get(i);
            String columnId = column.getId();
            buf.append(columnId).append(":");
            Object value = preData.get(columnId);
            if (value instanceof Method) {
                try {
                    value = ((Method)value).invoke(rowData, new Object[0]);
                }
                catch (Exception e) {
                    value = null;
                }
            }
            if (value != null) {
                String val = FacesUtils.getFormattedValue((FacesContext)FacesContext.getCurrentInstance(), (UIComponent)column, value);
                modified.append(modifiedVar).append("['").append(columnId).append("']");
                modified.append("='").append(val).append("';\n");
                buf.append("'").append(val).append("'");
                continue;
            }
            buf.append("null");
        }
        if (buf.length() > 0) {
            buf.append(",").append(SERVER_ROW_INDEX).append(":null");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public static String createRecord(List<UIColumn> columns) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append("{ name:");
            UIColumn column = columns.get(i);
            buf.append('\'').append(column.getId()).append("'}");
        }
        if (buf.length() > 0) {
            buf.append(",{").append("name:'").append(SERVER_ROW_INDEX).append("'}");
        }
        buf.append("]");
        return buf.toString();
    }

    public static String encodeArrayData(FacesContext context, UIData data, List<UIColumn> columns) {
        return DataRendererHelper.encodeArrayData(context, data, columns, data.getFirst(), data.getRows());
    }

    public static String encodeArrayData(FacesContext context, UIData data, List<UIColumn> columns, int rowIndex, int rows) {
        StringBuilder buf = new StringBuilder();
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            if (curRow > 0) {
                buf.append(",\n");
            }
            buf.append("[");
            for (int i = 0; i < columns.size(); ++i) {
                UIColumn column = columns.get(i);
                Object value = DataRendererHelper.getColumnValue(context, data, column);
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(HtmlEncoder.enquote((String)value.toString()));
            }
            buf.append("]");
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        return buf.toString();
    }

    public static JSONArray encodeJsonData(FacesContext context, UIData data, List<UIColumn> columns) {
        return DataRendererHelper.encodeJsonData(context, data, columns, data.getFirst(), data.getRows());
    }

    public static JSONArray encodeJsonData(FacesContext context, UIData data, List<UIColumn> columns, int rowIndex, int rows) {
        JSONArray json = new JSONArray();
        int curRow = 0;
        while (rows == 0 || curRow < rows) {
            data.setRowIndex(rowIndex);
            if (!data.isRowAvailable()) break;
            JSONObject rowData = new JSONObject();
            for (UIColumn column : columns) {
                Object value = DataRendererHelper.getColumnValue(context, data, column);
                String key = column.getId();
                if (key != null) {
                    rowData.put((Object)column.getId(), value);
                    continue;
                }
                throw new FacesException(Resources._T((String)"MVB_MISSING_COMPONENT_ATTRIBUTE", (Object[])new Object[]{FacesUtils.getComponentDesc((UIComponent)column), "id"}));
            }
            rowData.put(SERVER_ROW_INDEX, (Object)rowIndex);
            json.add((Object)rowData);
            ++curRow;
            ++rowIndex;
        }
        data.setRowIndex(-1);
        return json;
    }

    public static void sendJsonData(FacesContext context, JSONObject json) throws IOException {
        ExternalContext ectx = context.getExternalContext();
        HttpServletResponse response = (HttpServletResponse)ectx.getResponse();
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("text/json;charset=UTF-8");
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String callback = (String)paramMap.get(CALLBACK_FUNCTION);
        String script = json.toString();
        if (callback != null) {
            script = callback.concat("(").concat(script).concat(");");
        }
        response.getWriter().write(script);
        context.responseComplete();
    }

    public static Object getColumnValue(FacesContext context, UIData data, UIColumn column) {
        Object value;
        if (column instanceof ValueHolder && ((value = ((ValueHolder)column).getValue()) != null || column.getValueExpression("value") != null)) {
            String style = (String)column.getAttributes().get("style");
            String styleClass = (String)column.getAttributes().get("styleClass");
            if (style != null || styleClass != null) {
                String text = "<span";
                if (style != null) {
                    text = text + " style=" + HtmlEncoder.enquote((String)style, (Character)Character.valueOf('\"'));
                }
                if (styleClass != null) {
                    text = text + " class=\"" + styleClass + "\"";
                }
                text = text + ">" + FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)column, (Object)value) + "</span>";
                return text;
            }
            if (((ValueHolder)column).getConverter() != null) {
                return FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)column, (Object)value);
            }
            if (value instanceof Number) {
                return value;
            }
            return FacesUtils.getFormattedValue((FacesContext)context, (UIComponent)column, (Object)value);
        }
        return FacesUtils.encodeComponentChildren((FacesContext)context, (UIComponent)column);
    }

    public static String getColumnHeader(UIColumn column) {
        Object header = column.getAttributes().get("columnHeader");
        if (header != null) {
            return header.toString();
        }
        UIComponent facet = column.getHeader();
        if (facet != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            return FacesUtils.encodeComponent((FacesContext)context, (UIComponent)facet);
        }
        return null;
    }

    public static void registerSelectionModel() {
        ResourceManager rm = ResourceManager.getInstance((FacesContext)FacesContext.getCurrentInstance());
        ComponentResource.registerJS((ResourceManager)rm, (String[])new String[]{"Ext.grid.SelectionModel2"});
    }

    public static String loadData(FacesContext context, UIData data, int row, int col) {
        int rows;
        int rowIndex;
        List<UIColumn> columns = DataRendererHelper.getColumns((UIComponent)data);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        int totalRows = data.getRowCount();
        String startParam = (String)paramMap.get("start");
        if (startParam != null) {
            rowIndex = Integer.parseInt(startParam);
            data.setFirst(rowIndex);
        } else {
            rowIndex = data.getFirst();
        }
        String limitParam = (String)paramMap.get("limit");
        if (limitParam != null) {
            rows = Integer.parseInt(limitParam);
            data.setRows(rows);
        } else {
            rows = data.getRows();
        }
        JSONArray gridData = DataRendererHelper.encodeJsonData(context, data, columns, rowIndex, rows);
        JSONObject json = new JSONObject();
        json.put((Object)JSON_TOTAL, (Object)totalRows);
        json.put((Object)JSON_ROOT, (Object)gridData);
        JSONObject params = new JSONObject();
        params.put((Object)"start", (Object)rowIndex);
        params.put((Object)"row", (Object)row);
        params.put((Object)"col", (Object)col);
        json.put((Object)JSON_PARAMS, (Object)params);
        String callback = (String)paramMap.get(CALLBACK_FUNCTION);
        String script = json.toString();
        if (callback != null) {
            script = callback.concat("(").concat(script).concat(");");
        }
        return script;
    }

    public static String encodeGridState(FacesContext context, UIDataGrid grid) throws IOException {
        Object state = grid.processSaveState(context);
        List<UIColumn> columns = DataRendererHelper.getOutputColumns((UIComponent)grid);
        Object[] states = new Object[columns.size() + 1];
        states[0] = state;
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            states[i + 1] = column.processSaveState(context);
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(new GZIPOutputStream(bout));
        out.writeObject(states);
        out.close();
        byte[] bytes = bout.toByteArray();
        return Base64.encode((byte[])bytes);
    }

    public static void decodeGridState(FacesContext context, UIDataGrid grid, String viewString) throws IOException, ClassNotFoundException {
        byte[] bytes = Base64.decode((String)viewString);
        InputStream bin = new ByteArrayInputStream(bytes);
        bin = new GZIPInputStream(bin);
        final ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ObjectInputStream in = new ObjectInputStream(bin){

            protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                return Class.forName(desc.getName(), true, contextLoader);
            }
        };
        Object state = in.readObject();
        Object[] states = (Object[])state;
        for (int i = 0; i < states.length; ++i) {
            if (i == 0) {
                grid.processRestoreState(context, states[0]);
                continue;
            }
            UIOutputColumn output = new UIOutputColumn();
            output.processRestoreState(context, states[i]);
            grid.getChildren().add(output);
        }
    }
}

