/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.widget.UIDataView;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataViewRenderHelper {
    public static void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator<UIComponent> kids = DataViewRenderHelper.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                DataViewRenderHelper.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    private static Iterator<UIComponent> getChildren(UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            return new RenderedChildIterator(component.getChildren().iterator());
        }
        List empty = Collections.emptyList();
        return empty.iterator();
    }

    public static String getTemplate(FacesContext context, UIComponent component) {
        UIDataView dataView = (UIDataView)component;
        String template = dataView.getTemplate();
        if (template != null) {
            return template;
        }
        UIComponent facet = (UIComponent)component.getFacets().get("template");
        if (facet != null) {
            return FacesUtils.encodeComponent((FacesContext)context, (UIComponent)facet);
        }
        return null;
    }

    public static void encodeViewConfig(Formatter fmt, UIDataView view, ComponentResource resource, Aliases.ConfigBuilder c) {
        UIComponent empty = view.getFacet("empty");
        if (empty != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            String emptyText = FacesUtils.encodeComponent((FacesContext)context, (UIComponent)empty);
            fmt.format(",%s:%s", c.prop("emptyText"), HtmlEncoder.enquote((String)emptyText));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenderedChildIterator
    implements Iterator<UIComponent> {
        Iterator<UIComponent> childIterator;
        UIComponent child;
        boolean hasNext;

        RenderedChildIterator(Iterator<UIComponent> childIterator) {
            this.childIterator = childIterator;
            this.update();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public UIComponent next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            UIComponent temp = this.child;
            this.update();
            return temp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void update() {
            while (this.childIterator.hasNext()) {
                UIComponent comp = this.childIterator.next();
                if (!comp.isRendered()) continue;
                this.child = comp;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
            this.child = null;
        }
    }
}

