/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.operamasks.faces.component.widget.UIDrawImage;
import org.operamasks.util.Utils;

public class DrawImageHelper
implements Serializable {
    private static final long serialVersionUID = 7296338326431031087L;
    public static final String DRAW_IMAGE_PARAM = "org.operamasks.faces.DrawImage";
    private String id;
    private String type;
    private String width;
    private String height;
    private boolean alpha;
    private Object value;
    private MethodExpression draw;
    private transient UIDrawImage component;

    public DrawImageHelper(UIDrawImage component) {
        this.component = component;
        FacesContext context = FacesContext.getCurrentInstance();
        this.id = component.getClientId(context);
        this.type = component.getType();
        this.width = component.getWidth();
        this.height = component.getHeight();
        this.alpha = component.getAlpha();
        this.value = component.getValue();
        this.draw = component.getDrawMethod();
        if (this.value == null && this.draw == null) {
            this.value = "resource:/META-INF/resource/ext/skin/default/yuiext/images/s.gif";
        }
        if (this.draw != null && (this.width == null || this.width.length() == 0 || this.height == null || this.height.length() == 0)) {
            throw new FacesException("UIDrawImage: Missing width or height attribute.");
        }
        if (this.type == null) {
            this.type = this.alpha ? "image/png" : "image/jpeg";
        }
    }

    public String getType() {
        return this.type;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public boolean isAlpha() {
        return this.alpha;
    }

    public Object getValue() {
        return this.value;
    }

    public MethodExpression getDraw() {
        return this.draw;
    }

    public void save(FacesContext context) {
        ExternalContext ectx = context.getExternalContext();
        ectx.getSessionMap().put(DrawImageHelper.idkey(this.id), this);
    }

    public static DrawImageHelper restore(FacesContext context) {
        ExternalContext ectx = context.getExternalContext();
        String id = (String)ectx.getRequestParameterMap().get(DRAW_IMAGE_PARAM);
        if (id != null && ectx.getSession(false) != null) {
            return (DrawImageHelper)ectx.getSessionMap().get(DrawImageHelper.idkey(id));
        }
        return null;
    }

    public void clear(FacesContext context) {
        ExternalContext ectx = context.getExternalContext();
        if (ectx.getSession(false) != null) {
            ectx.getSessionMap().remove(DrawImageHelper.idkey(this.id));
        }
    }

    private static String idkey(String id) {
        return "org.operamasks.faces.DrawImage_" + id;
    }

    public void encode(FacesContext context, OutputStream stream) throws IOException {
        if (this.value != null) {
            this.encodeValue(this.value, stream);
        } else if (this.draw != null) {
            BufferedImage image = this.drawImage(context);
            this.writeImage(image, stream);
        }
    }

    private void encodeValue(Object obj, OutputStream out) throws IOException {
        if (obj instanceof RenderedImage) {
            this.writeImage((RenderedImage)obj, out);
        } else if (obj instanceof byte[]) {
            out.write((byte[])obj);
        } else if (obj instanceof InputStream) {
            this.writeStream((InputStream)obj, out);
        } else if (obj instanceof URL) {
            this.writeStream(((URL)obj).openStream(), out);
        } else if (obj instanceof String) {
            InputStream input;
            String path = (String)obj;
            if (path.startsWith("resource:")) {
                if ((path = path.substring(9)).startsWith("/")) {
                    path = path.substring(1);
                }
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                input = loader.getResourceAsStream(path);
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                path = context.getApplication().getViewHandler().getResourceURL(context, path);
                if (Utils.isAbsoluteURL((String)path)) {
                    input = new URL(path).openStream();
                } else {
                    String contextPath = context.getExternalContext().getRequestContextPath();
                    if (path.startsWith(contextPath)) {
                        path = path.substring(contextPath.length());
                    }
                    input = context.getExternalContext().getResourceAsStream(path);
                }
            }
            if (input == null) {
                throw new FileNotFoundException("Resource not found: " + path);
            }
            this.writeStream(input, out);
        }
    }

    private void writeStream(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = in.read(buf)) != -1) {
            out.write(buf, 0, n);
        }
        in.close();
    }

    private BufferedImage drawImage(FacesContext context) {
        int imageWidth = Integer.parseInt(this.width);
        int imageHeight = Integer.parseInt(this.height);
        int imageType = this.alpha ? 2 : 1;
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, imageType);
        Graphics g = image.getGraphics();
        try {
            this.draw.invoke(context.getELContext(), new Object[]{g, imageWidth, imageHeight});
        }
        catch (ELException ex) {
            throw new FacesException((Throwable)ex);
        }
        g.dispose();
        return image;
    }

    private void writeImage(RenderedImage image, OutputStream stream) throws IOException {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByMIMEType(this.type);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (writer == null) {
            throw new FacesException("Invalid MIME type: " + this.type);
        }
        ImageOutputStream output = ImageIO.createImageOutputStream(stream);
        writer.setOutput(output);
        writer.write(image);
        output.flush();
        writer.dispose();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.value != null && !(this.value instanceof Serializable)) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            this.encodeValue(this.value, buf);
            this.value = buf.toByteArray();
        }
    }

    public UIDrawImage getComponent() {
        return this.component;
    }
}

