/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Formatter;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.component.widget.menu.UIMenu;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.HtmlRenderer;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.util.HtmlEncoder;

public class MenuRendererHelper {
    public static UIMenu getParentMenu(UIComponent component) {
        for (component = component.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof UIMenu)) continue;
            return (UIMenu)component;
        }
        return null;
    }

    public static void encodeItemConfig(Formatter fmt, FacesContext context, UIComponent item, String text, Aliases.ConfigBuilder c) {
        String icon = MenuRendererHelper.getItemIcon(context, item);
        String styleClass = (String)item.getAttributes().get("styleClass");
        String disabledClass = (String)item.getAttributes().get("disabledClass");
        String activeClass = (String)item.getAttributes().get("activeClass");
        String iconClass = (String)item.getAttributes().get("iconClass");
        fmt.format("%s:%s", c.prop("text"), HtmlEncoder.enquote((String)text, (Character)Character.valueOf('\'')));
        if (icon != null) {
            fmt.format(",%s:%s", c.prop("icon"), HtmlEncoder.enquote((String)icon, (Character)Character.valueOf('\'')));
        }
        if (HtmlRenderer.isDisabled((UIComponent)item)) {
            fmt.format(",%s:true", c.prop("disabled"));
        }
        if (iconClass != null) {
            fmt.format(",%s:'%s'", c.prop("iconCls"), iconClass);
        }
        if (styleClass != null) {
            fmt.format(",%s:'%s'", c.prop("itemCls"), styleClass);
        }
        if (disabledClass != null) {
            fmt.format(",%s:'%s'", c.prop("disabledClass"), disabledClass);
        }
        if (activeClass != null) {
            fmt.format(",%s:'%s'", c.prop("activeClass"), activeClass);
        }
    }

    public static String getItemText(FacesContext context, UIComponent item, boolean fromValue) {
        String style;
        Object value;
        String text = (String)item.getAttributes().get("label");
        if (text == null && fromValue && (value = item.getAttributes().get("value")) != null) {
            text = value.toString();
        }
        if (text == null) {
            text = MenuRendererHelper.getInnerItemText(context, item);
        }
        if ((style = (String)item.getAttributes().get("style")) != null && style.length() != 0) {
            text = "<span style=" + HtmlEncoder.enquote((String)style, (Character)Character.valueOf('\"')) + ">" + text + "</span>";
        }
        return text;
    }

    static String getInnerItemText(FacesContext context, UIComponent item) {
        ResponseWriter curWriter = context.getResponseWriter();
        StringWriter strWriter = new StringWriter();
        ResponseWriter bufWriter = curWriter.cloneWithWriter((Writer)strWriter);
        try {
            context.setResponseWriter(bufWriter);
            for (UIComponent kid : item.getChildren()) {
                kid.encodeAll(context);
            }
            context.setResponseWriter(curWriter);
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
        return strWriter.toString();
    }

    public static String getItemIcon(FacesContext context, UIComponent item) {
        return RendererUtils.getIcon((UIComponent)item);
    }
}

