/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.webapp.layout;

import java.io.StringWriter;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.layout.UIFaceletSlot;
import org.operamasks.faces.component.layout.UITemplateContainer;
import org.operamasks.faces.layout.LayoutContext;
import org.operamasks.faces.layout.LayoutManager;

public class TemplateBuilder {
    private FacesContext context;
    private UIComponent container;
    private StringWriter writer;

    public static TemplateBuilder newBuilder(FacesContext context) {
        LayoutContext lc = LayoutContext.getCurrentInstance((FacesContext)context);
        LayoutManager layout = lc.getLayoutManager();
        if (!(layout instanceof UIComponent)) {
            return null;
        }
        UIComponent container = null;
        for (UIComponent component : ((UIComponent)layout).getChildren()) {
            if (!(component instanceof UITemplateContainer)) continue;
            container = component;
            break;
        }
        if (container == null) {
            return null;
        }
        return new TemplateBuilder(context, container);
    }

    public TemplateBuilder(FacesContext context, UIComponent container) {
        this.context = context;
        this.container = container;
        this.writer = new StringWriter();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public UIFaceletSlot addFaceletSlot() {
        this.addVerbatim();
        UIFaceletSlot slot = new UIFaceletSlot();
        slot.setId(this.createId());
        this.container.getChildren().add(slot);
        return slot;
    }

    public UIFaceletSlot addFaceletSlot(String name) {
        UIFaceletSlot slot = this.addFaceletSlot();
        slot.setName(name);
        return slot;
    }

    public UIFaceletSlot addFaceletSlot(int index) {
        UIFaceletSlot slot = this.addFaceletSlot();
        slot.setIndex(index);
        return slot;
    }

    public void addUIComponent(UIComponent component) {
        this.addVerbatim();
        this.container.getChildren().add(component);
    }

    private void addVerbatim() {
        StringBuffer buffer = this.writer.getBuffer();
        if (buffer.length() == 0) {
            return;
        }
        String value = buffer.toString();
        buffer.delete(0, buffer.length());
        UIOutput verbatim = this.createVerbatim(value);
        this.container.getChildren().add(verbatim);
    }

    private UIOutput createVerbatim(String value) {
        UIOutput verbatim = (UIOutput)this.context.getApplication().createComponent("javax.faces.HtmlOutputText");
        verbatim.setId(this.createId());
        verbatim.setTransient(true);
        verbatim.getAttributes().put("escape", Boolean.FALSE);
        verbatim.setValue((Object)value);
        return verbatim;
    }

    private String createId() {
        return this.context.getViewRoot().createUniqueId();
    }

    public void close() {
        this.addVerbatim();
    }
}

