/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.webapp.layout;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.operamasks.faces.webapp.layout.TemplateBuilder;

public class TemplateServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        TemplateBuilder builder = TemplateBuilder.newBuilder(context);
        if (builder == null) {
            return;
        }
        String template = this.readTemplate(request, response);
        if (template == null) {
            return;
        }
        TemplateProcessor processor = new TemplateProcessor(builder, template);
        processor.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
        if (path == null) {
            return null;
        }
        if (pathInfo != null) {
            path = path.concat(pathInfo);
        }
        InputStream ins = null;
        StringWriter sw = null;
        Reader in = null;
        try {
            int c;
            ins = this.getServletContext().getResourceAsStream(path);
            sw = new StringWriter();
            String charset = request.getParameter("charset");
            if (charset == null && (charset = response.getCharacterEncoding()) == null) {
                charset = "ISO-8859-1";
            }
            in = new InputStreamReader(ins, charset);
            while ((c = in.read()) != -1) {
                sw.write(c);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (ins != null) {
                ins.close();
            }
        }
        return sw.toString();
    }

    private static final class TemplateProcessor {
        private TemplateBuilder builder;
        private String template;
        private int pos;
        private int next;

        TemplateProcessor(TemplateBuilder builder, String template) {
            this.builder = builder;
            this.template = template;
            this.pos = 0;
            this.next = -1;
        }

        public void process() throws IOException {
            while (true) {
                this.next = this.template.indexOf(36, this.pos);
                if (this.next == -1) {
                    this.passthrough();
                    this.builder.close();
                    return;
                }
                this.passthrough();
                ++this.next;
                if (this.nextchar() == 123) {
                    int end = this.template.indexOf(125, this.next);
                    if (end == -1) {
                        ++this.next;
                        this.passthrough();
                        continue;
                    }
                    String expr = this.template.substring(this.next - 1, end + 1);
                    this.pos = this.next = end + 1;
                    this.eval(expr);
                    continue;
                }
                String keyword = this.keyword();
                if (keyword == null) {
                    this.passthrough();
                    continue;
                }
                if (keyword.equals("slot")) {
                    String param = this.param();
                    if (param == null || param.length() == 0) {
                        this.builder.addFaceletSlot();
                    } else if (param.startsWith("\"") && param.endsWith("\"")) {
                        param = param.substring(1, param.length() - 1);
                        this.builder.addFaceletSlot(param);
                    } else {
                        try {
                            int index = Integer.parseInt(param);
                            this.builder.addFaceletSlot(index);
                        }
                        catch (NumberFormatException ex) {
                            this.passthrough();
                            continue;
                        }
                    }
                    this.pos = this.next;
                    continue;
                }
                this.passthrough();
            }
        }

        private int nextchar() {
            if (this.next < this.template.length()) {
                return this.template.charAt(this.next);
            }
            return -1;
        }

        private void passthrough() throws IOException {
            if (this.next == -1) {
                this.next = this.template.length();
            }
            if (this.next > this.pos) {
                this.builder.getWriter().write(this.template.substring(this.pos, this.next));
            }
            this.pos = this.next;
        }

        private void whitespace() {
            char c;
            while (this.next < this.template.length() && Character.isWhitespace(c = this.template.charAt(this.next))) {
                ++this.next;
            }
        }

        private String keyword() {
            char c;
            int start = this.next;
            while (this.next < this.template.length() && Character.isLetter(c = this.template.charAt(this.next))) {
                ++this.next;
            }
            if (this.next > start) {
                return this.template.substring(start, this.next);
            }
            return null;
        }

        private String param() {
            int start = this.next++;
            int begStr = -1;
            int endStr = -1;
            this.whitespace();
            if (this.nextchar() == 40) {
                this.whitespace();
                int c = this.nextchar();
                if (c == 34) {
                    begStr = this.next++;
                    endStr = this.template.indexOf(34, this.next);
                    if (endStr != -1) {
                        this.next = ++endStr;
                    }
                } else if (Character.isDigit(c)) {
                    begStr = this.next;
                    while (++this.next < this.template.length() && Character.isDigit((char)(c = (int)this.template.charAt(this.next)))) {
                    }
                    endStr = this.next;
                } else if (c == 41) {
                    ++this.next;
                    return "";
                }
                if (begStr != -1 && endStr != -1) {
                    this.whitespace();
                    if (this.nextchar() == 41) {
                        ++this.next;
                        return this.template.substring(begStr, endStr);
                    }
                }
            }
            this.next = start;
            return null;
        }

        private void eval(String expr) throws IOException {
            FacesContext context = FacesContext.getCurrentInstance();
            String value = (String)context.getApplication().evaluateExpressionGet(context, expr, String.class);
            if (value != null) {
                this.builder.getWriter().write(value);
            }
        }
    }
}

