/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.operamasks.org.jfree.chart.axis.CategoryAxis;
import org.operamasks.org.jfree.chart.axis.ValueAxis;
import org.operamasks.org.jfree.chart.entity.EntityCollection;
import org.operamasks.org.jfree.chart.event.RendererChangeEvent;
import org.operamasks.org.jfree.chart.plot.CategoryPlot;
import org.operamasks.org.jfree.chart.plot.PlotOrientation;
import org.operamasks.org.jfree.chart.renderer.category.AreaRenderer;
import org.operamasks.org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.operamasks.org.jfree.data.DataUtilities;
import org.operamasks.org.jfree.data.Range;
import org.operamasks.org.jfree.data.category.CategoryDataset;
import org.operamasks.org.jfree.data.general.DatasetUtilities;
import org.operamasks.org.jfree.ui.RectangleEdge;
import org.operamasks.org.jfree.util.PublicCloneable;

public class StackedAreaRenderer
extends AreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3595635038460823663L;
    private boolean renderAsPercentages;

    public StackedAreaRenderer() {
        this(false);
    }

    public StackedAreaRenderer(boolean renderAsPercentages) {
        this.renderAsPercentages = renderAsPercentages;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean asPercentages) {
        this.renderAsPercentages = asPercentages;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset dataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(dataset);
    }

    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        EntityCollection entities;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        double total = 0.0;
        if (this.renderAsPercentages) {
            total = DataUtilities.calculateColumnTotal(dataset, column);
            value /= total;
        }
        double xx1 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double previousHeightx1 = this.getPreviousHeight(dataset, row, column);
        double y1 = value + previousHeightx1;
        RectangleEdge location = plot.getRangeAxisEdge();
        double yy1 = rangeAxis.valueToJava2D(y1, dataArea, location);
        g2.setPaint(this.getItemPaint(row, column));
        g2.setStroke(this.getItemStroke(row, column));
        if (column == 0) {
            if (pass == 1 && this.isItemLabelVisible(row, column)) {
                this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, xx1, yy1, y1 < 0.0);
            }
        } else {
            Number previousValue = dataset.getValue(row, column - 1);
            if (previousValue != null) {
                double xx0 = domainAxis.getCategoryMiddle(column - 1, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
                double y0 = previousValue.doubleValue();
                if (this.renderAsPercentages) {
                    total = DataUtilities.calculateColumnTotal(dataset, column - 1);
                    y0 /= total;
                }
                double previousHeightx0 = this.getPreviousHeight(dataset, row, column - 1);
                double previousHeightxx0 = rangeAxis.valueToJava2D(previousHeightx0, dataArea, location);
                double previousHeightxx1 = rangeAxis.valueToJava2D(previousHeightx1, dataArea, location);
                double yy0 = rangeAxis.valueToJava2D(y0 += previousHeightx0, dataArea, location);
                if (pass == 0) {
                    Polygon p = null;
                    PlotOrientation orientation = plot.getOrientation();
                    if (orientation == PlotOrientation.HORIZONTAL) {
                        p = new Polygon();
                        p.addPoint((int)yy0, (int)xx0);
                        p.addPoint((int)yy1, (int)xx1);
                        p.addPoint((int)previousHeightxx1, (int)xx1);
                        p.addPoint((int)previousHeightxx0, (int)xx0);
                    } else if (orientation == PlotOrientation.VERTICAL) {
                        p = new Polygon();
                        p.addPoint((int)xx0, (int)yy0);
                        p.addPoint((int)xx1, (int)yy1);
                        p.addPoint((int)xx1, (int)previousHeightxx1);
                        p.addPoint((int)xx0, (int)previousHeightxx0);
                    }
                    g2.setPaint(this.getItemPaint(row, column));
                    g2.setStroke(this.getItemStroke(row, column));
                    g2.fill(p);
                } else if (this.isItemLabelVisible(row, column)) {
                    this.drawItemLabel(g2, plot.getOrientation(), dataset, row, column, xx1, yy1, y1 < 0.0);
                }
            }
        }
        if ((entities = state.getEntityCollection()) != null) {
            Rectangle2D.Double shape = new Rectangle2D.Double(xx1 - 3.0, yy1 - 3.0, 6.0, 6.0);
            this.addItemEntity(entities, dataset, row, column, shape);
        }
    }

    protected double getPreviousHeight(CategoryDataset dataset, int series, int category) {
        double result = 0.0;
        double total = 0.0;
        if (this.renderAsPercentages) {
            total = DataUtilities.calculateColumnTotal(dataset, category);
        }
        for (int i = 0; i < series; ++i) {
            Number n = dataset.getValue(i, category);
            if (n == null) continue;
            double v = n.doubleValue();
            if (this.renderAsPercentages) {
                v /= total;
            }
            result += v;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackedAreaRenderer)) {
            return false;
        }
        StackedAreaRenderer that = (StackedAreaRenderer)obj;
        if (this.renderAsPercentages != that.renderAsPercentages) {
            return false;
        }
        return super.equals(obj);
    }
}

