if (!window.OM) {var OM = {};}

//Ajax global ajax
if (!OM.ajax) {OM.ajax = {};}

if(!OM.ajax.SubmitAction){
	OM.ajax.SubmitAction = function(url, immediate, clientId, formId, groupId){
		this.permParams = {};
		this.tempParams = {};
		this.url = url;
		this.immediate = immediate;
		this.clientId = clientId;
		this.formId = formId;
		this.groupId = groupId;
		//标识临时的额外参数列表是否为空
		this.markTempParams = false;
	}
	
	OM.ajax.SubmitAction.prototype={
			addPermParam: function(key, value){
				this.permParams[key] = value;
			},
			
			addParam: function(key, value){
				this.markTempParams = true;
				this.tempParams[key] = value;
			},
			
			getTargetForm : function(groupId){
				var result = null;
				for(var i=0;i<document.forms.length;i++){
	        		if(groupId == document.forms[i].groupId){
	        			return document.forms[i];
	        		}
				}
			},
			
			getParentForm : function(obj) {
		        if (typeof obj == 'string')
		            obj = document.getElementById(obj);
		        var parent = obj;
		        while (parent && parent.nodeName.toLowerCase() != 'form') {
		            parent = parent.parentNode;
		        }
		        return parent;
		    },
			
			clearTempParams: function(){
				//清空临时额外参数列表并重置标记
				this.tempParams = {};
				this.markTempParams = false;
			},
			
			submit : function(){
				var target = null;
				if(this.formId){
					target = this.getParentForm(this.formId);
				} else {
					//取到某个groupId相同的form，将其作为target,否则target为null,即为无form提交
					if(this.groupId){
						target = this.getTargetForm(this.groupId);
					}
				}
				var params = [];
				var k,v;
				for (k in this.permParams) {
               		v = this.permParams[k];
               		v = (v == undefined) ? '' : encodeURIComponent(v);
               		params.push(encodeURIComponent(k) + '=' + v);
				}
				for (k in this.tempParams) {
               		v = this.tempParams[k];
               		v = (v == undefined) ? '' : encodeURIComponent(v);
               		params.push(encodeURIComponent(k) + '=' + v);
				}
				if(this.markTempParams === true){
					params.push(encodeURIComponent('_markTempParams_') + '=');
				}
				params.push(encodeURIComponent(this.clientId) + "=");
				OM.ajax.submit(target, this.url, params, this.immediate, this.clientId);
			}
	};
}