/*
 * $Id: ajax-debug.js,v 1.18 2010/07/06 03:25:06 patrick Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 */ 

var _IS_MSIE = window.navigator && navigator.userAgent.toLowerCase().indexOf("msie") != -1 && navigator.userAgent.toLowerCase().indexOf("opera") == -1;
var _IS_OPERA = window.navigator && navigator.userAgent.toLowerCase().indexOf("opera") != -1;
var _IS_FIREFOX = window.navigator && navigator.userAgent.toLowerCase().indexOf("firefox") != -1;

if (!String.prototype.trim) {
    String.prototype.trim = function() {
        return this.replace(/^\s*(.*?)\s*$/, "$1");
    }
}

if (!Array.prototype.contains) {
    Array.prototype.contains = function(newValue){
        for (var item in this){
            if(this[item] == newValue) return true;
        }
        return false;
	}
}

if (!window.OM) {var OM = {};}

//Ajax global event
if (!OM.event) {OM.event = {};}
OM.event.listenerList = function() {
	this._listeners = {};
}
OM.event.listenerList.prototype = {
	set : function(name, fn) {
		this._listeners[name] = fn;
	},

	clear : function() {
		this._listeners.clear();
	},

	remove : function(name) {
		delete this._listeners[name];
	}
}

OM.event.beforeSubmit = function() {}
OM.event.beforeSubmit.prototype = new OM.event.listenerList(); 
OM.event.beforeSubmit.prototype.action = function(source) {
	for (var key in this._listeners) {
		this._listeners[key](source);
	}
}

OM.event.afterResponse = function() {}
OM.event.afterResponse.prototype = new OM.event.listenerList(); 
OM.event.afterResponse.prototype.action = function(source) {
	for (var key in this._listeners) {
		this._listeners[key](source);
	}
}

OM.ajax = {
    RENDER_ID_PARAM : "org.operamasks.faces.RenderId",

    getRequest : function() {
        if (window.XMLHttpRequest) {
            return new XMLHttpRequest();
        } else if (window.ActiveXObject) {
            try {
                return new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                return new ActiveXObject("Microsoft.XMLHTTP");
            }
        }
    },

    requestParams : {},

    addRequestParameter : function(k,v) {
        this.requestParams[k] = v;
    },

    removeRequestParameter : function(k) {
        delete this.requestParams[k];
    },
    
    addFieldParameter : function(params, field) {
        if (!field.type)
            return;

        var key = encodeURIComponent(field.name);
        switch (field.type) {
        case 'checkbox':
        	var encodedValue;
        	if (field.checked) {
        		encodedValue = encodeURIComponent(field.value);
            } else {
            	encodedValue = 'off';
            }
            params.push(key + '=' + encodedValue);
            break;
        case 'radio':
            if (field.checked) {
                params.push(key + '=' + encodeURIComponent(field.value));
            }
            break;
        case 'select-multiple':
            for (var i = 0; i < field.options.length; i++) {
                var opt = field.options[i];
                if (opt.selected) {
                    params.push(key + '=' + encodeURIComponent(opt.value));
                }
            }
            break;
        case 'button':
        case 'submit':
        case 'reset':
            break;
        case 'hidden':
            if (field.name != 'javax.faces.ViewState')
                params.push(key + '=' + encodeURIComponent(field.value));
            break;
        default:
            params.push(key + '=' + encodeURIComponent(field.value));
            break;
        }
    },

    buildParameterList : function(args, form, swClientId) {
        var params = new Array();

        if (args) {
            if (args instanceof Array) {
                params = params.concat(args);
            } else if (typeof args == 'object') {
                for (var k in args) {
                    var v = args[k];
                    v = (v == undefined) ? '' : encodeURIComponent(v);
                    params.push(encodeURIComponent(k) + '=' + v);
                }
            }
        }
        
        if (form) {
            var elems = form.elements;
            if (elems != null) {
                for (var p=0; p<elems.length; p++) {
                    this.addFieldParameter(params, elems[p]);
                }
            }
        } else if(swClientId) {
            var ele = document.getElementById(swClientId);
            if (typeof swClientId == 'string' && ele) {
            	this.addFieldParameter(params, ele);
            	// find combo hidden input
            	var ve = document.getElementById(swClientId + "_value");
            	if(ve != null && (ve.nodeName != null && ve.nodeName.toLowerCase() == 'input') && (ve.type == 'hidden')) {
            		this.addFieldParameter(params, ve);
            	}
            }
        }

        for (var k in this.requestParams) {
            var v = this.requestParams[k];
            v = (v == undefined) ? '' : encodeURIComponent(v);
            params.push(encodeURIComponent(k) + "=" + v);
        }

        return params;
    },

    getParentForm : function(obj) {
        if (typeof obj == 'string')
            obj = document.getElementById(obj);
        var parent = obj;
        while (parent && parent.nodeName.toLowerCase() != 'form') {
            parent = parent.parentNode;
        }
        return parent;
    },

    actionId : null,
    viewId : null,
    viewState : null,
    renderKitId : null,
    beforeSubmit : new OM.event.beforeSubmit(),
    afterResponse : new OM.event.afterResponse(),

    buildQuery : function(form, params, swClientId) {
        params = this.buildParameterList(params, form, swClientId);
        if (this.viewId)
            params.push('javax.faces.ViewId=' + encodeURIComponent(this.viewId));
        if (this.viewState)
            params.push('javax.faces.ViewState=' + this.viewState.replace(/\+/g, '%2b'));
        if (this.renderKitId)
            params.push('javax.faces.RenderKitId=' + this.renderKitId);
        return params.join('&');
    },

    submit : function(source, url, params, immediate, swClientId, sw /*source widget*/) {
        var form = this.getParentForm(source);
        var _queueReq, cb;
        try {
        if (form) {
            _queueReq = form.queueReq;
            cb = form._callback;
            if (cb && cb.inprogress && !_queueReq)
                return false;
            if (cb && cb.onsubmit && cb.onsubmit.call(form) === false)
                return false;
            if (!immediate && form._validateBeforeSubmit && !(this.validateForm(form) & this.validateGroupForms(form)))
                return false;
            if (sw && !_queueReq) {
            	cb.sw = sw;
            }
            if (!url) url = form.action;
        } else {
            if (!url) url = this.actionId;
        }
        this.beforeSubmit.action(sw || source, url, params, form);

		if (typeof params == 'object'){
            if(!(params instanceof Array)) {
                var _params = [];
                for (var k in params) {
                    _params.push(encodeURIComponent(k) + '=' + (params[k] ? encodeURIComponent(params[k]) : ''));
                }
                params = _params;;
            }
			
            if(immediate != undefined)
                params.push("immediate=" + immediate);
            if(swClientId != undefined)
                params.push("sourceWidgetClientId=" + swClientId);
        }
        var query = this.buildQuery(form, params, swClientId);
		query = this.buildGroupParameterList(form, query);
        this.sendRequest(url, query, cb, {queueReq : _queueReq, sw : sw, formId : form?form.id:null, groupId  : form?form.groupId:null});
        return false;
        } finally {
        	form = null;
        	sw = null;
        }
    },
    
    clearSubmitStatus : function(source){
    	var form = this.getParentForm(source);
        var cb = null;
        if (form) {
            cb = form._callback;
            cb.inprogress = false;
        }
	},
    
    buildGroupParameterList : function(form, query){
    	if(form && form.groupId){
        	for(var i=0;i<document.forms.length;i++){
        		if(form.groupId == document.forms[i].groupId && form != document.forms[i]){
        			var f = this.buildParameterList({},document.forms[i]);
        			query += '&' + f.join('&');
        		}
        	}
        }
        return query;
    },

    action : function(source, url, actionId, immediate, delay, swClientId, eventParams) {
        var params = [encodeURIComponent(actionId) + '='];
        if(typeof eventParams == 'object' && eventParams instanceof Array) {
        	params = params.concat(eventParams);
        }
        if (delay || delay==null) {
        	window.setTimeout(function() {
        		OM.ajax.submit(source, url, params, immediate, swClientId);
        	}, 50);
        } else {
        	OM.ajax.submit(source, url, params, immediate, swClientId);
        }
    },
    
    sendRequest : function(url, query, cb, context) {
    	
        if (window.LOG) {
        	LOG.clear();
        	LOG.debug("AJAX request ("+ query.length + ")", query);
        }

        if (cb) {
            if (cb.onbeforerequest && cb.onbeforerequest.call(cb.scope||cb, cb) == false)
                return;
            cb.inprogress = true;
        }

        // extract render ID from query string
        var renderId = '';
        var begin = query.indexOf(this.RENDER_ID_PARAM);
        if (begin != -1) {
            begin += this.RENDER_ID_PARAM.length + 1;
            var end = query.indexOf('&', begin);
            if (end == -1) end = query.length;
            renderId = query.substring(begin, end);
        }

        var req = this.getRequest();
        this.updateStatus(renderId, true);
        if (context && context.queueReq) {
            var ajaxReq = new OM.ajax.AjaxRequest(req, url, query, context.formId, context.groupId, context.sw, function() { OM.ajax._onStateChange(renderId, ajaxReq, cb);});  
            if (!OM.ajax.queueScanner.isStarted()) {
                OM.ajax.queueScanner.start();
            }
            ajaxReq.sendReq();
        } else {
            req.onreadystatechange = function() { OM.ajax._onStateChange(renderId, req, cb); };
            req.open('POST', url, true);
            req.setRequestHeader('X-Requested-By', 'XMLHttpRequest');
            req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
            req.send(query);
        }
    },

    _onStateChange : function(renderId, _req, cb) {
        var req = _req.xmlReq || _req;
        if (req.readyState == 4) {
            var sw = null;
            var isTimeout = undefined;
            if (_req.xmlReq) {
                sw = _req.sw;
                isTimeout = _req.isTimeout();
            } else if (cb && cb.sw){
                sw = cb.sw;
            }
            
            this.afterResponse.action(sw, req);
            
            if (!isTimeout) {
                if (cb && cb.handleResponse) {
                    try {
                        cb.handleResponse.call(cb.scope||cb, cb, req);
                    } finally {
                        cb.inprogress = false;
                        req.onreadystatechange = OM.SC.np;
                        this.updateStatus(renderId, false);
                    }
                    return;
                }
    
                var success = true;
                try {
                    var status = req.status;
                    var response = req.responseText;
                    
                    var scriptAndServerLog = response.split('[__OM_$serverLog_$separator]');
                    response = scriptAndServerLog[0];
                    var serverLog = null;
                    
                    if (scriptAndServerLog[1])
                        serverLog = scriptAndServerLog[1];                  
    
                    if (status == 200) {
                        var header = req.getResponseHeader('Content-Type');
                        if ((header || '').match(/^text\/javascript/i)) {
                            // If logger is opened, eval response in single-step mode
                            if (window.LOG) {
                                LOG.debug("AJAX response (" + response.length + ")", response);
                                LOG.debug("eval script: ", response);
                                eval(response);
                                if (serverLog)
                                    LOG.debug("server log: ", serverLog);
                            } else {
                                eval(response);
                            }
                        } else {
                            this.showPage(response);
                        }
                    } else if (status == 301 || status == 302) {
                        window.location = req.getResponseHeader('Location');
                    } else {
                        success = false;
                        this.showPage(response);
                    }
                } catch (e) {
                    success = false;
                    if (window.LOG) LOG.error(e.message);
                    else throw e;
                } finally {
                    // Avoid memory leak in MSIE: clean up the oncomplete event heandler
                	req.onreadystatechange = OM.SC.np;
                    this.updateStatus(renderId, false);
    
                    if (cb) {
                        cb.inprogress = false;
                        if (success && cb.onsuccess) {
                            cb.onsuccess.call(cb.scope||cb, cb);
                        } else if (!success && cb.onfailure) {
                            cb.onfailure.call(cb.scope||cb, cb);
                        }
                        if (cb.oncomplete) {
                            cb.oncomplete.call(cb.scope||cb, cb);
                        }
                    }
                }
            } else {
                if (cb && cb.ontimeout) 
                    cb.ontimeout.call(cb.scope||cb, cb);
            }
        
            /*
             req.onreadystatechange = function() {};
             this.updateStatus(renderId, false);
             */
            if (_req.xmlReq) {
                var queue = this.QueueManager.getQueue(_req.queueId);
                if (queue) {
                    if (_req === queue.getOldestElement()) {
                        queue.dequeue();
                    }
                    queue.clearTimeoutReq();
                    if (queue.getOldestElement()) {
                        queue.getOldestElement().sendReq();
                    }
                }
            }
        }
    },

    showPage : function(html) {
        window.setTimeout(function() {
            if (_IS_MSIE) {
                // fix for stupid IE bug, load page and activate all scripts
                var h = window.onerror;
                document.open('text/html');
                window.onerror = function(){return true;}
                document.write(html);
                window.onerror = h;
                document.close();
                window.location.reload(false);
            } else {
                document.open('text/html');
                document.write(html);
                document.close();
            }
        }, 50);
    },

    initForm : function(form, callback, groupId, queueReq, timeout) {
        if (callback) {
            callback.scope = form;
            form._callback = callback;
        }
        form.nonAjaxSubmit = form.submit; // save old submit method
        form.submit = function() {
            return OM.ajax.submit(form);
        };
        form.onsubmit = function() {
            return OM.ajax.submit(form, form.action, callback.params, true);
        };
        if(groupId){
        	form.groupId = groupId;
        }
        if (queueReq) {
            form.queueReq = queueReq;
            form.timeout = timeout || 0;
        }
    },

    initValidation : function(formid, id, field) {
        var v = document.forms[formid]._validators;
        if (v) {
            for (var i = 0; i < v.length; i++) {
                if (v[i]._id == id) {
                    v[i].srcField = field;
                }
            }
        }
    },

    _statusTargets : new Array(),

    addStatusTarget : function(renderId, observer) {
        if (renderId == null) renderId = '';

        for (var i = 0; i < this._statusTargets.length; i++) {
            var target = this._statusTargets[i];
            if (target.renderId == renderId) {
                target.observers.push(observer);
                return;
            }
        }

        var target = new Object();
        target.count = 0;
        target.renderId = renderId;
        target.observers = [observer];
        this._statusTargets.push(target);
    },

    updateStatus : function(renderId, start) {
        for (var i = 0; i < this._statusTargets.length; i++) {
            var target = this._statusTargets[i];
            if (target.renderId == '' || target.renderId == renderId) {
                target.count += start ? 1 : -1;
                this._updateStatusTargets(target);
            }
        }
    },

    _updateStatusTargets : function(target) {
        var event = (target.count > 0) ? "onstart" : "onstop";
        for (var i = 0; i < target.observers.length; i++) {
            var o = target.observers[i];
            if (typeof o[event] == 'function') {
                o[event]();
            }
        }
    },

    _loadedUris : [],

    isScriptLoaded : function(uri) {
        if (this._loadedUris[uri]) {
            return true;
        }
        var head = document.getElementsByTagName("head")[0];
        var els = head.getElementsByTagName("script");
        for (var i = 0; i < els.length; i++) {
            var src = els[i].src;
            if (src) {
                var x = src.length - uri.length;
                if (x >= 0 && src.lastIndexOf(uri) == x) {
                    this._loadedUris[uri] = true;
                    return true;
                }
            }
        }
        return false;
    },
    
    each : function(array, fn, scope){
        if(typeof array.length == "undefined" || typeof array == "string"){
            array = [array];
        }
        for(var i = 0, len = array.length; i < len; i++){
            if(fn.call(scope || array[i], array[i], i, array) === false){ return i; };
        }
    },
    
    fixSingleJsUri: function(uri){
    	var pos = uri.indexOf('/resource/_$js/');
    	var singleJsPaths = uri.substring(pos+'/resource/_$js/'.length).split(';');
    	var uriPrefix = uri.substring(0,uri.indexOf('/resource/') + '/resource/'.length);
    	this.each(singleJsPaths, function(item, index, allItems){
    		var fixUri = uriPrefix + item.replace(/\|/g,'/') + '.js';
    		if (OM.ajax._loadedUris[fixUri]) {
    			delete allItems[index];
            }
    	});
    	var head = document.getElementsByTagName("head")[0];
        var els = head.getElementsByTagName("script");
        for (var i = 0; i < els.length; i++) {
            var src = els[i].src;
            if (src && src.indexOf('/_global/resource/_$js/') > -1) {
            	var loadedSingleJsPaths = src.substring(src.lastIndexOf('/')+1).split(';');
            	for(var j=0, jlen=loadedSingleJsPaths.length;j<jlen;j++){
            		var loadedSingleJsPath = loadedSingleJsPaths[j];
            		this.each(singleJsPaths, function(item, index, allItems){
            			if(item === loadedSingleJsPath){
            				delete allItems[index];
            			}
            		});
            	}
            }
        }
        var resultSingleJsPaths = [];
        for(var k=0,klen=singleJsPaths.length;k<klen;k++){
        	if(singleJsPaths[k]){
        		resultSingleJsPaths.push(singleJsPaths[k]);
        	}
        }
        if(resultSingleJsPaths.length > 0){
        	return uriPrefix + '_$js/' + resultSingleJsPaths.join(';');
        } else {
        	return null;
        }
    },

    loadScript : function(uri) {
        // return when the uri is not a LocaleResource and the uri had load
        if (uri.indexOf('/resource/ext/locale/') < 0 && this.isScriptLoaded(uri)) {
            return;
        }
        
        if (uri.indexOf('/resource/_$js/') > -1){
        	uri = this.fixSingleJsUri(uri);
        	if(uri === null){
        		return;
        	}
        }

        var req = this.getRequest();
        req.open('GET', uri, false);
        req.send(null);

        var status = req.status;
        if (status != 200) {
            var err = Error("Unable to load "+uri+", status:"+status);
            err.status = status;
            err.responseText = req.responseText;
            throw err;
        } else {
            eval(req.responseText);
            if(uri.indexOf('/resource/_$js/') > -1){
            	var pos = uri.indexOf('/resource/_$js/');
            	var singleJsPaths = uri.substring(pos+'/resource/_$js/'.length).split(';');
            	var uriPrefix = uri.substring(0,uri.indexOf('/resource/') + '/resource/'.length);
            	this.each(singleJsPaths, function(item, index, allItems){
            		var fixUri = uriPrefix + item.replace(/\|/g,'/') + '.js';
            		OM.ajax._loadedUris[fixUri] = true;
            		if (window.LOG) LOG.debug("Loaded "+uri);
            	});
            } else {
            	this._loadedUris[uri] = true;
            	if (window.LOG) LOG.debug("Loaded "+uri);
            }
        }
    },

    isStylesheetLoaded : function(uri) {
    	if (this._loadedUris[uri]) {
            return true;
        }
    	
        var head = document.getElementsByTagName("head")[0];
        var els = head.getElementsByTagName("link");
        for (var i = 0; i < els.length; i++) {
            var el = els[i];
            if (el.rel == "stylesheet" && el.type == "text/css" && el.href) {
                var x = el.href.length - uri.length;
                if (x >= 0 && el.href.lastIndexOf(uri) == x) {
                    return true;
                }
            }
        }
        return false;
    },
    
    fixSingleCssUri: function(uri){
    	var pos = uri.lastIndexOf('/');
    	var singleCssPaths = uri.substring(pos+1).replace('.dcss','').split(';');
    	var uriPrefix = uri.substring(0,pos+1);
    	this.each(singleCssPaths, function(item, index, allItems){
    		var fixUri = uriPrefix + item.replace(/\|/g,'/') + '.css';
    		if (OM.ajax._loadedUris[fixUri]) {
    			delete allItems[index];
            }
    	});
    	var head = document.getElementsByTagName("head")[0];
        var els = head.getElementsByTagName("link");
        for (var i = 0; i < els.length; i++) {
            var src = els[i].src;
            if (src && src.indexOf('.dcss') > -1) {
            	var loadedSingleCssPaths = src.substring(src.lastIndexOf('/')+1).replace('.dcss','').split(';');
            	for(var j=0, jlen=loadedSingleCssPaths.length;j<jlen;j++){
            		var loadedSingleCssPath = loadedSingleCssPaths[j];
            		this.each(singleCssPaths, function(item, index, allItems){
            			if(item === loadedSingleCssPath){
            				delete allItems[index];
            			}
            		});
            	}
            }
        }
        var resultSingleCssPaths = [];
        for(var k=0,klen=singleCssPaths.length;k<klen;k++){
        	if(singleCssPaths[k]){
        		resultSingleCssPaths.push(singleCssPaths[k]);
        	}
        }
        if(resultSingleCssPaths.length > 0){
        	return uriPrefix + resultSingleCssPaths.join(';') + '.dcss';
        } else {
        	return null;
        }
    },
    
    

    loadStylesheet : function(uri,id,cls) {
        if (this.isStylesheetLoaded(uri))
            return;
        
        if (uri.indexOf('.dcss') > -1){
        	uri = this.fixSingleCssUri(uri);
        	if(uri === null){
        		return;
        	}
        }

        var css = document.createElement("link");
        css.setAttribute("rel", "stylesheet");
        css.setAttribute("type", "text/css");
        css.setAttribute("href", uri);
        if (id) css.id = id;
        if (cls) css.className = cls;
        document.getElementsByTagName("head")[0].appendChild(css);
        if(uri.indexOf('.dcss') > -1){
        	var pos = uri.lastIndexOf('/');
        	var singleCssPaths = uri.substring(pos+1).replace('.dcss','').split(';');
        	var uriPrefix = uri.substring(0,pos+1);
        	this.each(singleCssPaths, function(item, index, allItems){
        		var fixUri = uriPrefix + item.replace(/\|/g,'/') + '.css';
        		this._loadedUris[fixUri] = true;
            	if (window.LOG) LOG.debug("Loaded "+fixUri);
        	});
        } else {
        	this._loadedUris[uri] = true;
        	if (window.LOG) LOG.debug("Loaded "+uri);
        }
    },
    
    _showExceptions : true,
    
    _exceptions : new Array(),

    _END_:0
};


OM.ajax.beforeSubmit.set("disableButton", function(source){
	if (source && source.disable && 
		typeof source.allowReEnter !== "undefiend" && source.allowReEnter === false) {
		source.disable();
	}
});

OM.ajax.afterResponse.set("disableButton", function(source){
	if (source && source.enable && !source.allowReEnter &&
        typeof source.allowReEnter !== "undefiend" && source.allowReEnter === false && !window.closed && source.serverDisabled !== "undefined" && source.serverDisabled === false) {
        source.enable();
    }
    if(source && source.serverDisabled !== 'undefined'){
        source.serverDisabled = false;
    }
});


// Ajax utilitity functions
OM.F = function(id,p,v) {
    var el = document.getElementById(id);
    if (el) el[p] = v;
}
OM.S = function(id,v) {
    var el = document.getElementById(id);
    if (el) el.style.cssText = v;
}
OM.T = function(id,v) {
    var el = document.getElementById(id);
    if (el) el.innerHTML = v;
}

OM.H = function(id,html) {
    var el = document.getElementById(id);
    if (!el) return;

    var inspId = id + "_" + new Date().getTime();
    html += "<span id='" + inspId + "'></span>";

    var timer = null;
    var count = 0;
    var loadScripts = function() {
        var insp = document.getElementById(inspId);
        if (!insp) {
            if (++count > 10) {
                if (timer) window.clearInterval(timer);
            }
            return;
        }

        insp.parentNode.removeChild(insp);
        if (timer) window.clearInterval(timer);

        var re = /(?:<script(?:[^>]*)?>)(?:((\n|\r)*?)<!--)?((\n|\r|.)*?)(?:<\/script>)/img;
        var m;
        while (m = re.exec(html)) {
            var s = m[3];
            if (s && s.length > 0) {
                if (window.LOG) LOG.debug("eval script", s);
                try {
                    eval(s);
                } catch (e) {
                    if (window.LOG) LOG.error(e.message);
                }
            }
        }
    };

    el.innerHTML = html.replace(/(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)/img, "");
    if (document.getElementById(inspId)) {
        loadScripts();
    } else {
        timer = window.setInterval(loadScripts, 500);
    }
};

OM.O = function(id,html) {
    var el = document.getElementById(id);
    if (!el) return;

    var inspId = id + "_" + new Date().getTime();
    html += "<span id='" + inspId + "'></span>";

    var timer = null;
    var count = 0;
    var loadScripts = function() {
        var insp = document.getElementById(inspId);
        if (!insp) {
            if (++count > 10) {
                if (timer) window.clearInterval(timer);
            }
            return;
        }

        insp.parentNode.removeChild(insp);
        if (timer) window.clearInterval(timer);

        var re = /(?:<script(?:[^>]*)?>)(?:((\n|\r)*?)<!--)?((\n|\r|.)*?)(?:<\/script>)/img;
        var m;
        while (m = re.exec(html)) {
            var s = m[3];
            if (s && s.length > 0) {
                if (window.LOG) LOG.debug("eval script", s);
                try {
                    eval(s);
                } catch (e) {
                    if (window.LOG) LOG.error(e.message);
                }
            }
        }
    };

    if (_IS_MSIE) {
    	el.outerHTML = html.replace(/(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)/img, "");
    } else {
        var r=el.ownerDocument.createRange();
        r.setStartBefore(el);
        var df=r.createContextualFragment(html.replace(/(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)/img, ""));
        el.parentNode.replaceChild(df,el);
    }
    if (document.getElementById(inspId)) {
        loadScripts();
    } else {
        timer = window.setInterval(loadScripts, 500);
    }
};

OM.SEL = function(id,items) {
    var el = document.getElementById(id);
    if (el) el = el.firstChild;
    if (el && el.options) {
        var opts = el.options;
        for (var i = 0; i < opts.length; i++) {
            opts[i].selected = false;
        }
        for (var i = 0; i < items.length; i++) {
            opts[items[i]].selected = true;
        }
    }
}

OM.E = function(f) {
	try {
		f();
	} catch (e) {
		OM.ajax._exceptions[OM.ajax._exceptions.length] = e;
	}
}

OM.L = function() {
    if (OM.ajax._exceptions.length == 0 || !OM.ajax._showExceptions) {
    	OM.ajax._exceptions = new Array();
        return;
    }
	var errMsgZone = document.createElement("div");
	errMsgZone.className="x-errzone";
	errMsgZone.id = "x-errzone";
	document.body.appendChild(errMsgZone);
	var ih = "<div class='x-err-close' onclick='OM.L.close()'></div><p class='x-errzone-title'>Exceptions occurred when executing javascript:</p>";
	for (idx in OM.ajax._exceptions) {
	    var e=OM.ajax._exceptions[idx];
	    if (!(e instanceof Error)) continue;
		ih += "<div class='x-err-item x-err-item-";
		ih += (idx%2==0)?"even":"odd";
		ih += "'>";
		for (pro in e) {
			if (pro == "stack") 
			    e[pro] = "<ul><li>" + e[pro].replace(/@/g, "</li><li>@")+"</li></ul>";
			ih += "<span class='x-err-"+pro+"'><label>"+pro+":</label>"+e[pro]+"</span>";
		}
		ih += "</div>";
	}
	errMsgZone.innerHTML = ih;
	OM.ajax._exceptions = new Array();
}

OM.L.close = function() {
	document.getElementById("x-errzone").style.display = "none";
}

OM.execClientScript = function(script,clientWindowHandle) {
	if(!clientWindowHandle){
		clientWindowHandle = window;
	}
	if(clientWindowHandle.contentWindow){
		clientWindowHandle = clientWindowHandle.contentWindow;
	}
	clientWindowHandle.eval(script);
}

OM.CB = function(keys) {
	return function(config) {
		var result = new Object();
		for (var name in config) {
			var idx = parseInt(name);
			if (!isNaN(idx)) {
				result[keys[idx]] = config[name];
			} else {
				result[name] = config[name];
			}
		}
		return result;
	};
}

OM.bldES = function(immediate) {
	if (!immediate) immediate = false;
	return function(form, param, clientId, sw) {
		var params;
		if (typeof param === 'string') {
			params = new Object();
			params[clientId] = param;
		} else {
			params = param;
		}
		OM.ajax.submit(form, null, params, immediate, clientId, sw)
	}
}

OM.ES = OM.bldES(false);
OM.ESI = OM.bldES(true);

OM.updateFormValidateFieldIds = function(formId, fieldId) {
	var fieldIds = document.forms[formId]._clientValidateFieldIds;
    if (typeof fieldIds != 'undefined' && fieldIds instanceof Array) 
    	fieldIds.push(fieldId);
}

OM.buildClientValidator = function(validators) {
	return function(value){
		for(var n = 0; n < validators.length; n++){
			var result = validators[n].validate(value);
			if(result===true){
				continue;
			} else {
			    return result;
			}
	    }
        return true;
    }
}

OM.buildDateMenuOnSelect = function(formName, clientId) {
	return function(o,d) {
		if(typeof(OM.ajax.getParentForm(formName)[clientId])=='undefined'){
			var createdInput = document.createElement('input');
			createdInput.type='hidden';
			createdInput.id=clientId;
			createdInput.name=clientId;
			createdInput.value= d.format('m/d/Y');
			OM.ajax.getParentForm(formName).appendChild(createdInput);
		}else{
			OM.ajax.getParentForm(formName)[clientId].value=d.format('m/d/Y');
	    }
	}
}

OM.buildToolTipRenderer = function(txt) {
	return function(c) {Ext.QuickTips.register({target: c.getEl(),text: txt});}
}

OM.applyToMarkup = function(jsvar, clientId) {
    if(Ext.get(clientId)) {
        jsvar.applyToMarkup(clientId);
    }
}

// -------------------------------------
// Updater support
// -------------------------------------
OM.ajax.Updater = function(url, renderId, loaded) {
    this.loaded = loaded;
    this.update = function(once) {
        if (!(once && this.loaded)) {
            OM.ajax.submit(null, url, [OM.ajax.RENDER_ID_PARAM+'='+renderId], true);
            this.loaded = true;
        }
    }
}

// -------------------------------------
// Timer support
// -------------------------------------
OM.ajax.Timer = function(id,url,delay,period) {
    this.id = id;
    this.url = url;
    this.delay = delay;
    this.period = period;
    this.form = null;
    this.params = new Array();
    this.ontimeout = null;

    var _self = this;
    this._callback = function() { _self._onTimerEvent(); }
}

OM.ajax.Timer.prototype = {
    scheduled : false,
    cancelled : false,
    requested : false,

    addParameter : function(name, value) {
        this.params.push(encodeURIComponent(name) + '=' + encodeURIComponent(value));
    },

    schedule : function() {
        if (!this.scheduled && !this.requested) {
            this.cancelled = false;
            this.scheduled = true;
            window.setTimeout(this._callback, this.delay);
        }
    },

    cancel : function() {
        this.cancelled = true;
    },

    _onTimerEvent : function() {
        this.scheduled = false;
        if (!this.cancelled) {
            if (typeof this.ontimeout == 'function') {
                this.cancelled = (this.ontimeout() == false);
            }
            if (!this.cancelled && this.period > 0) {
                this.requested = true;
                this._sendRequest();
            }
        }
    },

    _sendRequest : function() {
        var params = new Array();
        params.push(encodeURIComponent(this.id) + '=');
        params = params.concat(this.params);

        var query = OM.ajax.buildQuery(this.form, params);
        OM.ajax.sendRequest(this.url, query, {scope:this, oncomplete:this._onComplete}, {});
    },

    _onComplete : function() {
        this.requested = false;
        if (!this.cancelled && this.period > 0) {
            this.scheduled = true;
            window.setTimeout(this._callback, this.period);
        }
    }
};

// -------------------------------------
// conversationActivator support
// -------------------------------------

OM.ajax.ConversationActivator = function(url, delay, period, timeout) {
    this.url = url;
    this.delay = delay;
    this.period = period;
    this.timeout = timeout;
    this.params = new Array();
    
    var _self = this;
    this._callback = function() { _self._onTimerEvent(); }
}

OM.ajax.ConversationActivator.prototype = {
    scheduled : false,
    cancelled : false,
    requested : false,
    
    addParameter : function(name, value) {
        this.params.push(encodeURIComponent(name) + '=' + encodeURIComponent(value));
    },

    schedule : function() {
        if (!this.scheduled && !this.requested) {
            this.cancelled = false;
            this.scheduled = true;
            window.setTimeout(this._callback, this.delay);
        }
    },

    cancel : function() {
        this.cancelled = true;
    },

    _onTimerEvent : function() {
        this.scheduled = false;
        if (!this.cancelled && this.period > 0) {
            this.requested = true;
            this._sendRequest();
        }
    },

    _sendRequest : function() {
        var query = this.params.join('&');
        var req = OM.ajax.getRequest();
        var activatorObj = this;
        req.onreadystatechange = function() {
        	var reqObj = req.xmlReq || req;
            if (reqObj.readyState == 4) {
            	activatorObj._onComplete();
            }
        };
        req.open('POST', this.url, true);
        req.setRequestHeader('X-Requested-By', 'XMLHttpRequest');
        req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
        req.send(query);
    },

    _onComplete : function() {
        this.requested = false;
        if (!this.cancelled && this.period > 0) {
            this.scheduled = true;
            window.setTimeout(this._callback, this.period);
        }
    }
}
// -------------------------------------
// Progress support
// -------------------------------------
OM.ajax.Progress = function(id, url, interval) {
    this.id = id;
    this.url = url;
    this.interval = interval || 1000;
    this.params = new Array();

    this.state = "stopped";
    this.phase = 0;
    this.percentage = 0;
    this.message = null;
    this._timer = null;
    this.requestId = null;
}

OM.ajax.Progress.prototype.addParameter = function(name,value) {
    this.params.push(encodeURIComponent(name) + '=' + encodeURIComponent(value));
}

OM.ajax.Progress.prototype.setAutoStart = function() {
    var _self = this;
    var autoStart = function() {
        window.setTimeout(function() { _self.start(); }, 100);
    }

    if (window.addEventListener) { // for DOM Level 2
        window.addEventListener('load', autoStart, false);
    } else if (window.attachEvent) { // for IE
        window.attachEvent('onload', autoStart);
    }
}

OM.ajax.Progress.prototype.isRunning = function() {
    return this.state == 'running';
}
OM.ajax.Progress.prototype.isStopped = function() {
    return this.state == 'stopped';
}
OM.ajax.Progress.prototype.isPaused = function() {
    return this.state == 'paused';
}
OM.ajax.Progress.prototype.isCompleted = function() {
    return this.state == 'completed';
}
OM.ajax.Progress.prototype.isFailed = function() {
    return this.state == 'failed';
}

OM.ajax.Progress.prototype.start = function(rid) {
	if (rid) {
		this.requestId = rid;
	} else {
		this.requestId = null;
	}
    if (!this.isRunning())
        this._sendRequest('start');
}

OM.ajax.Progress.prototype.stop = function() {
    if (this.isRunning() || this.isPaused())
        this._sendRequest('stop');
}

OM.ajax.Progress.prototype.pause = function() {
    if (this.isRunning())
        this._sendRequest('pause');
}

OM.ajax.Progress.prototype.resume = function() {
    if (this.isPaused())
        this._sendRequest('resume');
}

OM.ajax.Progress.prototype.poll = function() {
    if (this.isRunning())
        this._sendRequest('poll');
}

OM.ajax.Progress.prototype._sendRequest = function(action) {
    if (this._timer != null)
        window.clearTimeout(this._timer);

    var params = new Array();
    params.push(encodeURIComponent(this.id) + '=' + action);
    if (this.requestId) {
    	params.push("_request_identifier=" + this.requestId);
    }
    params = params.concat(this.params);
    var query = OM.ajax.buildQuery(null, params);
    OM.ajax.sendRequest(this.url, query, null, {});
}

OM.ajax.Progress.prototype._handleResponse = function(params) {
    this.state = params.state;
    this.phase = params.phase;
    this.percentage = params.percentage;
    this.message = params.message;

    if (typeof this.onstatechange == 'function') {
        this.onstatechange();
    }

    if (this.isRunning()) {
        var _self = this;
        this._timer = window.setTimeout(function(){_self.poll();}, this.interval);
    }
}

// -------------------------------------
// Client side validator support
// -------------------------------------
OM.ajax.validateForm = function(f) {
    var clientValidateFieldIds = f._clientValidateFieldIds;
	if (!clientValidateFieldIds)
		return true;

	// reset validator messages
	for (var n = 0; n < clientValidateFieldIds.length; n++) {
		var fieldCmp = Ext.getCmp(clientValidateFieldIds[n]);
		fieldCmp.clearInvalid();
	}

	var result = true;
	var focusField = null;
	for (var n = 0; n < clientValidateFieldIds.length; n++) {
		var fieldCmp = Ext.getCmp(clientValidateFieldIds[n]);
		var validateResult = fieldCmp.validate();
		if (validateResult === false) {
			result = false;
			if (focusField == null)
				focusField = fieldCmp;
		}
	}
	if (focusField && focusField.focus) {
		focusField.focus();
	}
	return result;
}

OM.ajax.validateGroupForms = function(f) {
    var result = true;
	if(f && f.groupId){
        	for(var i=0;i<document.forms.length;i++){
        		if(f.groupId == document.forms[i].groupId && f != document.forms[i]){
        			result = this.validateForm(document.forms[i]) && result;
        		}
        	}
    }
    return result;
}


Validator = function (message) {
    this._message = message;
}

Validator.prototype._validate = function(value){
	return true;
}

Validator.prototype.validate = function(value){
	if(this._validate(value)){
		return true;
	} else {
		return this._message;
	}
}

ClientValidator = function(message,validateFunc){
    this._message = message;
	this._validateFunc = validateFunc;
}

ClientValidator.prototype = new Validator();

ClientValidator.prototype._validate = function(value){
	var result = this._validateFunc.call(this,value);
	if(result === true)
	  	return true;
	if(result !== false)
	   this._message = result;
	return false;
}

IntegerValidator = function(message, minValue, maxValue) {
    this._message = message;
    this._minValue = minValue;
    this._maxValue = maxValue;
}

IntegerValidator.prototype = new Validator();

IntegerValidator.prototype._validate = function(v){
    if (v.length == 0)
        return true;
    if (!/^[-+]?\d+$/.test(v))
        return false;
    if (this._minValue == null && this._maxValue == null)
        return true;
    var value = parseInt(v);
    if (isNaN(value))
        return false;
    if (this._minValue != null && value < this._minValue)
        return false;
    if (this._maxValue != null && value > this._maxValue)
        return false;
    return true;
}

FloatValidator = function(message, minValue, maxValue) {
    this._message = message;
    this._minValue = minValue;
    this._maxValue = maxValue;
}

FloatValidator.prototype = new Validator();

FloatValidator.prototype._validate = function(v) {
    if (v.length == 0)
        return true;
    if (!/^[-+]?(\d+|\d+\.\d*|\d*\.\d+)([eE][-+]?\d+)?$/.test(v))
        return false;
    if (this._minValue == null && this._maxValue == null)
        return true;
    var value = parseFloat(v);
    if (isNaN(value))
        return false;
    if (this._minValue != null && value < this._minValue)
        return false;
    if (this._maxValue != null && value > this._maxValue)
        return false;
    return true;
}

RequiredValidator = function(message, trim) {
    this._message = message;
    this._trim = trim;
}

RequiredValidator.prototype = new Validator();

RequiredValidator.prototype._validate = function(v) {
    if (this._trim) v = v.trim();
    return v.length > 0;
}

LengthValidator = function(message, minimum, maximum) {
    this._message = message;
    this._minimum = minimum;
    this._maximum = maximum;
}

LengthValidator.prototype = new Validator();

LengthValidator.prototype._validate = function(v) {
    if(v.length == 0)
        return true;
    if (this._minimum != null && v.length < this._minimum)
        return false;
    if (this._maximum != null && v.length > this._maximum)
        return false;
    return true;
}

RegexpValidator = function(message, pattern) {
	 this._message = message;
    this._pattern = new RegExp(pattern);
}

RegexpValidator.prototype = new Validator();

RegexpValidator.prototype._validate = function(v) {
    return v.length == 0 || this._pattern.test(v);
}

DateValidator = function (message, format) {
    this._message = message;
    this._format = format;
}

DateValidator.prototype = new Validator();

// ------------------------
// Ajax Request Queue
// ------------------------

// Queue
OM.ajax.Queue = function() {
     this.queue = [];
     this.queueSpace = 0;
     this.timeout = -1;
}
OM.ajax.Queue.prototype.getSize = function getSize() {
     return this.queue.length - this.queueSpace;
};
OM.ajax.Queue.prototype.enqueue = function enqueue(element) {
    this.queue.push(element);
};
OM.ajax.Queue.prototype.dequeue = function dequeue() {
    var element = undefined;
    if (this.queue.length) {
        element = this.queue[this.queueSpace];
        element && element.clearState();
        if (++this.queueSpace * 2 >= this.queue.length) {
            this.queue = this.queue.slice(this.queueSpace);
            this.queueSpace = 0;
        }
    }
    return element;
};
OM.ajax.Queue.prototype.getOldestElement = function getOldestElement() {
    return this.getSize() && this.queue[this.queueSpace];
};
   
OM.ajax.Queue.prototype.clearTimeoutReq = function clearTimeoutReq() {
    if (!this.getSize())
        return;
    var oldestReq = this.getOldestElement();
    while (oldestReq) {
        if (!oldestReq.isTimeout()) {
            break;
        }
        this.dequeue();
        oldestReq = this.getOldestElement();
    }
};

// Ajax Request
OM.ajax.AjaxRequest = function(req, url, query, formId, groupId, sw, cb) {
    this.xmlReq = req;
    this.url = url;
    this.query = query;
    this.sendTime = new Date();
    this.formId = formId;
    this.queueId = groupId || formId;
    this.fromQueue = false;
    this.sw = sw;
    this.cb = cb;
    this.sended = false;
}
OM.ajax.AjaxRequest.prototype.sendReq = function() {
    var queue = OM.ajax.QueueManager.getQueue(this.queueId);
    if (!queue) {
        queue = OM.ajax.QueueManager.createQueue(this.queueId);
    }
    
    var _form = document.getElementById(this.formId); 
    if (_form && queue.timeout !== 0 && _form.timeout > queue.timeout) {
        queue.timeout = _form.timeout;
    }
    
    if (queue.getSize() && !this.fromQueue) {
        queue.enqueue(this);
        this.fromQueue = true;
        return;
    }
    if (!this.fromQueue) {
        queue.enqueue(this);
        this.fromQueue = true;
    }
    
    this.xmlReq.onreadystatechange = this.cb;
    this.xmlReq.open('POST', this.url, true);
    this.xmlReq.setRequestHeader('X-Requested-By', 'XMLHttpRequest');
    this.xmlReq.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
    this.xmlReq.send(this.query);
    this.sended = true;
    this.clearState();
}

OM.ajax.AjaxRequest.prototype.clearState = function() {
    /*avoid memory leak*/
    delete this.cb; 
}

OM.ajax.AjaxRequest.prototype.isTimeout = function() {
    var timeout = OM.ajax.QueueManager.getQueue(this.queueId).timeout;
    var now = new Date();
    return timeout != 0 && (now.getTime() - this.sendTime.getTime() > timeout);
}

// Queue Manager
OM.ajax.QueueManager = new function() {
    var queues = {};
    this.createQueue = function(id) {
        return queues[id] || (queues[id] = new OM.ajax.Queue());
    }; 
    
    this.removeQueue = function(id) {
    	if (queues[id])
        queues[id] && (queues[id] = undefined);
    };
    
    this.cleanUpQueues = function(){
        for (var i in queues) {
            queues[i].clearTimeoutReq();
            var oldestEle = queues[i].getOldestElement();
            if (oldestEle && !oldestEle.sended) {
                oldestEle.sendReq();
            }
        }
    };
    
    this.getQueue = function(id) {
        return queues[id];
    };
}();

// Queue Scanner
OM.ajax.queueScanner = new function(){
    var started = false;
    var scanner = undefined;
    this.isStarted = function() {
        return this.started;
    };
         
    this.start = function() {
        if (!started) {
            this.scanner = window.setInterval(OM.ajax.QueueManager.cleanUpQueues, 1000);
            this.started = true;
        }
    };

    this.stop = function() {
        if (this.scanner) {
            this.scanner.clearInterval();
            this.scanner = undefined;
            this.started = false;
        }
    };
}();


if (!OM.layout) {OM.layout = {};}
OM.layout.fixPercentSize = function(parentJsvar,clientId,targetJsvar,pureDecimal,property){
    var isWidth=false;
    if(property == 'width')
    	isWidth=true;
    if(clientId && !parentJsvar){
        var parentNode=Ext.get(clientId).findParentNode('',1,true)||Ext.getBody(); 
        if(isWidth){ 
            targetJsvar.setWidth(Math.round(parentNode.getWidth()*pureDecimal));
        }else{
            targetJsvar.setHeight(Math.round(parentNode.getHeight()*pureDecimal));
        }
    }else{
        if(!clientId && parentJsvar){
            if(isWidth){ 
                targetJsvar.setWidth(Math.round(parentJsvar.getSize().width*pureDecimal));
            }else{
                targetJsvar.setHeight(Math.round(parentJsvar.getSize().height*pureDecimal));
            }
        }else{
            return false;
        }
	}
}

if (!OM.iframe) {OM.iframe = {};}
OM.iframe.ensureIframeLoad = function(iframeId){
    window.setTimeout(function(){
        var iframeEle = document.getElementById(iframeId);
		if(iframeEle.contentWindow.location.href=='about:blank' && iframeEle.src != 'about:blank'){
			iframeEle.src=iframeEle.src;
		}
	}, 100);
}

//shortcuts
OM.SC = {
	//Combo shortcuts
	addComboTip: 
		function(jsvar) {
 			var tooltip = new Ext.ToolTip({
 					target: jsvar.el,
 					html: jsvar.el.getValue(),
 					autohide: true
 				});
 			jsvar.on('select', function(combo, record, index){
 				tooltip.body && (tooltip.body.dom.innerHTML = record.data.text);
 			});
		},
    comboStore:
    	function() {
			return new Ext.data.SimpleStore({fields:['text','value'], data:[]});
		},
	buildComboRecord:
		function(record) {
			var r = new Array();
			for (var i = 0; i < record.length; i++) {
				r.push(new Ext.data.Record({text:record[i][0],value:record[i][1]}));
			}
			return r;
		},
	clearCmp:
		function(clientId) {
			Ext.getCmp(clientId) && typeof(Ext.getCmp(clientId).destroy) == 'function' && Ext.getCmp(clientId).destroy();
		},
	comboExtraConfig:
		function(jsvar) {
			var cmp = null;
			return function(value) {
				if (!cmp) {
					cmp = window[jsvar];
					delete jsvar;
				}
				try {
					var data = cmp.store.data;
					for (var i=0;i < data.length;i++){
						var item = data.get(i).data;
						if (item.value == value) {return item.text;}
					}
				} catch(e) {}
				return value
			}
		},
	//KeyBinding shotcuts
	canelIEDefault:
		function(e) {
			Ext.EventObject.stopEvent();
			if(Ext.isIE) e.browserEvent.keyCode = 0;
		},
	//RadioGroup shortcuts
	radioGroupStateChanger:
		function(items) {
			return function(item) {
				for (var i=0;i<items.length;i++) {
					var t = items[i];
					(t!=item) && (t.checked=false); 
				}
			}
		},
	//Tree shortcuts
	registerTreeEvent:
		function(tree,eventName,clientId,ajaxAction) {
			if (typeof ajaxAction == "function") {
				tree.on(eventName, function(node){buildEventParams(eventName,node,clientId,tree);ajaxAction(node);});
			} else {
				tree.on(eventName, function(node){buildEventParams(eventName,node,clientId,tree);});
			}
		},
	registerTreeOnSelect:
		function(tree,clientId,selectHandler) {
			if (typeof selectHandler == "function") {
				tree.getSelectionModel().on('selectionchange',function(selectionModel,node){buildEventParams('select', node, clientId, tree);selectHandler(selectionModel,node);});
			} else {
				tree.getSelectionModel().on('selectionchange',function(selectionModel,node){buildEventParams('select', node, clientId, tree);});
			}
		},
	registerTreeOnLoad:
		function(loader,jsvar,clientId) {
			var tree = window[jsvar];
			loader.on('load',function(node){
				var isExpandAll = window[jsvar+'IsExpandAll'];
				if(isExpandAll){
					isExpandAll=false;
					return;
				};
				buildEventParams('check',tree.getRootNode(),clientId,tree);});
		},
	//datagrid
	addGridRowResizeHandler:
		function(grid) {
			grid.getView().on('refresh',function(){
				grid.getEl().select('.x-grid3-body').first().select('.x-grid3-row',true).each(function(){
					var rowDivEl = this;
					new Ext.Resizable(rowDivEl, {
						handles: 's',
						minHeight: 20,
						listeners :{'resize':function(resizeObj, width, height, e){rowDivEl.select('.x-grid3-row-table').first().setHeight(height);}}});
				});
			});
		},
	//actionId
	actionId:
		function() {
			return OM.ajax.actionId;
		},
	
	//paginglink
		pagingLinkCallback:
			function(ds) {
			return function(start,limit) {
				ds.load({params:{start:start,limit:limit}});
			}
		},
	//requestParam
		addRequestParameter : function(k,v) {
			OM.ajax.addRequestParameter(k, v);
		},
		
		removeRequestParameter: function(k) {
			OM.ajax.removeRequestParameter(k);
		},
		
	//tabLayout
		setTabOnChange : function(tab, clientId) {
			tab.on('tabchange',function(tabPanel, panel){
				for(var i=0;i<tabPanel.items.items.length;i++){
					if(panel.id==tabPanel.items.items[i].id){
						document.getElementById(clientId).value=i;break;
					}
				}
			});
		},
		
		np : function() {}
}