if (Ext.DatePicker) {
	Ext.override(Ext.DatePicker, {
		update : function(date){
			var vd = this.activeDate;
			this.activeDate = date;
			if (vd && this.el) {
				var t = date.getTime();
				if (vd.getMonth() == date.getMonth()
						&& vd.getFullYear() == date.getFullYear()) {
					this.cells.removeClass("x-date-selected");
					this.cells.each(function(c) {
								if (c.dom.firstChild.dateValue == t) {
									c.addClass("x-date-selected");
									/*
									 * setTimeout(function(){
									 * try{c.dom.firstChild.focus();}catch(e){} },
									 * 50);
									 */
									return false;
								}
							});
					return;
				}
			}
			var days = date.getDaysInMonth();
			var firstOfMonth = date.getFirstDateOfMonth();
			var startingPos = firstOfMonth.getDay() - this.startDay;

			if (startingPos <= this.startDay) {
				startingPos += 7;
			}

			var pm = date.add("mo", -1);
			var prevStart = pm.getDaysInMonth() - startingPos;

			var cells = this.cells.elements;
			var textEls = this.textNodes;
			days += startingPos;

			// convert everything to numbers so it's fast
			var day = 86400000;
			var d = (new Date(pm.getFullYear(), pm.getMonth(), prevStart))
					.clearTime();
			var today = new Date().clearTime().getTime();
			var sel = date.clearTime().getTime();
			var min = this.minDate
					? this.minDate.clearTime()
					: Number.NEGATIVE_INFINITY;
			var max = this.maxDate
					? this.maxDate.clearTime()
					: Number.POSITIVE_INFINITY;
			var ddMatch = this.disabledDatesRE;
			var ddText = this.disabledDatesText;
			var ddays = this.disabledDays ? this.disabledDays.join("") : false;
			var ddaysText = this.disabledDaysText;
			var format = this.format;

			var setCellClass = function(cal, cell) {
				cell.title = "";
				var t = d.getTime();
				var hol = d;
				cell.firstChild.dateValue = t;
				if (t == today) {
					cell.className += " x-date-today";
					cell.title = cal.todayText;
				}
				if (t == sel) {
					cell.className += " x-date-selected";
					/*
					 * setTimeout(function(){
					 * try{cell.firstChild.focus();}catch(e){} }, 50);
					 */
				}
				// disabling
				if (t < min) {
					cell.className = " x-date-disabled";
					cell.title = cal.minText;
					return;
				}
				if (t > max) {
					cell.className = " x-date-disabled";
					cell.title = cal.maxText;
					return;
				}
				if (ddays) {
					if (ddays.indexOf(d.getDay()) != -1) {
						cell.title = ddaysText;
						cell.className = " x-date-disabled";
					}
				}
				if (ddMatch && format) {
					var fvalue = d.dateFormat(format);
					if (ddMatch.test(fvalue)) {
						cell.title = ddText.replace("%0", fvalue);
						cell.className = " x-date-disabled";
					}
				}
				// set the holiday tooltip
                for(var i = 0; i < cal.holidays.length; i ++) {
                    var holiday = cal.holidays[i].split(",");
                    if(hol.format("md") === holiday[0]) {
                        cell.title = holiday[1];
                    }
                }
			};

			var i = 0;
			for (; i < startingPos; i++) {
				textEls[i].innerHTML = (++prevStart);
				d.setDate(d.getDate() + 1);
				cells[i].className = "x-date-prevday";
				setCellClass(this, cells[i]);
			}
			for (; i < days; i++) {
				intDay = i - startingPos + 1;
				textEls[i].innerHTML = (intDay);
				d.setDate(d.getDate() + 1);
				cells[i].className = "x-date-active";
				setCellClass(this, cells[i]);
			}
			var extraDays = 0;
			for (; i < 42; i++) {
				textEls[i].innerHTML = (++extraDays);
				d.setDate(d.getDate() + 1);
				cells[i].className = "x-date-nextday";
				setCellClass(this, cells[i]);
			}

			this.mbtn.setText(this.monthNames[date.getMonth()] + " "
					+ date.getFullYear());

			if (!this.internalRender) {
				var main = this.el.dom.firstChild;
				var w = main.offsetWidth;
				this.el.setWidth(w + this.el.getBorderWidth("lr"));
				Ext.fly(main).setWidth(w);
				this.internalRender = true;
				// opera does not respect the auto grow header center column
				// then, after it gets a width opera refuses to recalculate
				// without a second pass
				if (Ext.isOpera && !this.secondPass) {
					main.rows[0].cells[1].style.width = (w - (main.rows[0].cells[0].offsetWidth + main.rows[0].cells[2].offsetWidth))
							+ "px";
					this.secondPass = true;
					this.update.defer(10, this, [date]);
				}
			}
		}
	});
}