Ext.ux.HtmlEditorAutoFit = function(){
    var htmlEditor;
    this.init = function(tp){
        htmlEditor = tp;
        htmlEditor.onRender = onRender;
        htmlEditor.getDocMarkup = getDocMarkup;
    }
    
    function getDocMarkup(){
        return '<html><head><style type="text/css">body{border:0;margin:0;padding:3px;height:96%;cursor:text;}</style></head><body></body></html>';
    }

    function onRender(ct, position){
        Ext.form.HtmlEditor.superclass.onRender.call(this, ct, position);
        this.el.dom.style.border = '0 none';
        this.el.dom.setAttribute('tabIndex', -1);
        this.el.addClass('x-hidden');
        if(Ext.isIE){ // fix IE 1px bogus margin
            this.el.applyStyles('margin-top:-1px;margin-bottom:-1px;')
        }
        this.wrap = this.el.wrap({
            cls:'x-html-editor-wrap', cn:{cls:'x-html-editor-tb'}
        });
		this.el.dom.style.width = "100%";
		var width = this.width || this.wrap.dom.parentNode.clientWidth;
		var height = this.height || this.wrap.dom.parentNode.clientHeight;
		this.wrap.dom.style.width = (width - 2) + "px";
		this.wrap.dom.style.height = (height - 2) + "px";
		if(Ext.isIE){
			this.wrap.dom.style.width = width + "px";
			this.wrap.dom.style.height = height + "px";
		}
        this.createToolbar(this);

        this.tb.items.each(function(item){
           if(item.itemId != 'sourceedit'){
                item.disable();
            }
        });

        var iframe = document.createElement('iframe');
        iframe.name = Ext.id();
        iframe.frameBorder = 'no';
		iframe.style.width = "100%";
		iframe.style.height = (this.wrap.dom.clientHeight - 26) + "px";
        iframe.src=(Ext.SSL_SECURE_URL || "javascript:false");

        this.wrap.dom.appendChild(iframe);

        this.iframe = iframe;

        if(Ext.isIE){
            iframe.contentWindow.document.designMode = 'on';
            this.doc = iframe.contentWindow.document;
            this.win = iframe.contentWindow;
        } else {
            this.doc = (iframe.contentDocument || window.frames[iframe.name].document);
            this.win = window.frames[iframe.name];
            this.doc.designMode = 'on';
        }
        this.doc.open();
        this.doc.write(this.getDocMarkup())
        this.doc.close();

        var task = { // must defer to wait for browser to be ready
            run : function(){
                if(this.doc.body || this.doc.readyState == 'complete'){
                    Ext.TaskMgr.stop(task);
                    this.doc.designMode="on";
                    this.initEditor.defer(10, this);
                }
            },
            interval : 10,
            duration:10000,
            scope: this
        };
        Ext.TaskMgr.start(task);
    }
};