Ext.namespace("Ext.ux.plugins");

Ext.ux.plugins.XGrid = function(config) {
	Ext.apply(this, config);
};

Ext.extend(Ext.ux.plugins.XGrid, Ext.util.Observable, {
    init: function(grid){
    	Ext.grid.CheckboxSelectionModel.override({
            initEvents : function(){
                Ext.grid.CheckboxSelectionModel.superclass.initEvents.call(this);
                this.grid.on('render', function(){
                    var view = this.grid.getView();
                    view.mainBody.on('mousedown', this.onMouseDown, this);
                    if(this.singleSelect) {
                        var hcell = new Ext.Template(
		                    '<td ',
		                    '{rowspan}',
		                    ' {colspan} ',
		                    'class="x-grid3-hd x-grid3-cell x-grid3-td-{id}" ',
		                    'style="{style}"><div {tooltip} {attr} ',
		                    'class="x-grid3-hd-inner" ',
		                    'unselectable="on" style="{istyle}">', 
		                    this.grid.enableHdMenu ? '<a class="x-grid3-hd-btn" href="#"></a>' : '',
		                    '{value}<img class="x-grid3-sort-icon" src="', Ext.BLANK_IMAGE_URL, '" />',
		                    "</div></td>"
		                    );
		                grid.view.templates.hcell = hcell;
                        this.header = '<div style="background:none">&#160;</div>';
                        this.headerCls = '';
                        var doms = Ext.fly(view.innerHd).select('.x-grid3-hd-checker');
                        if (doms && doms.elements.length > 0) {
                            for(var cnt = 0; cnt < doms.elements.length; cnt++) {
    	                        var dom = doms.elements[cnt];
    	                        Ext.fly(dom).removeClass('x-grid3-hd-checker');
	                            //Ext.DomHelper.applyStyles(dom, 'background:none');
                            }
                        }
                    }
                    else {
                        Ext.fly(view.innerHd).on('mousedown', this.onHdMouseDown, this);
                    }    
        
                }, this);
            },
            renderer : function(v, p, record){
                return '<div class="x-grid3-row-checker" unselectable="on">&#160;</div>';
            }
        });
    	this.grid = grid;
		this.view = this.grid.getView();
		this.view.grid = grid;
        this.view.initElements = this.initElements.createDelegate(this);
        this.view.layout = this.layout.createDelegate(this);
        this.grid.render = this.render.createDelegate(this);
        this.view.beforeColMenuShow = this.beforeColMenuShow.createDelegate(this.grid.view);
        this.view.getRows = this.getRows.createDelegate(this);
        this.view.findCell = this.findCell.createDelegate(this.grid.view);
        this.view.doRender = this.doRender.createDelegate(this.grid.view);
        this.view.updateColumnHidden = this.updateColumnHidden.createDelegate(this.grid.view);
        this.view.getColumnWrap = this.getColumnWrap.createDelegate(this.grid.view);
        this.view.getColumnData = this.getColumnData.createDelegate(this.grid.view);
        var cm = this.grid.getColumnModel();
        this.initWrapTemplates();
        if(cm.headers.length > 1) {
            this.initTemplates();
            this.initMethodDelegate();
            this.grid.on("columnresize", this.onColumnresize, this);
        }
 	},
    render : function(container, position){
        if(!this.grid.rendered && this.grid.fireEvent("beforerender", this) !== false){
            if((!container && this.grid.el) || typeof container == "string"){
                var elId = container ? container : this.grid.el;
                var c = document.getElementById(elId);
                if (!c.style.height) {
                    c.style.height = '100%';
                }
                this.grid.originWidth = c.offsetWidth;
                this.grid.originHeight = c.offsetHeight;
                this.grid.el = Ext.get(elId);
                container = this.grid.el.dom.parentNode;
                this.grid.allowDomMove = false;
            }
            this.grid.container = Ext.get(container);
            if(this.grid.ctCls){
                this.grid.container.addClass(this.grid.ctCls);
            }
            this.grid.rendered = true;
            if(position !== undefined){
                if(typeof position == 'number'){
                    position = this.grid.container.dom.childNodes[position];
                }else{
                    position = Ext.getDom(position);
                }
            }
            this.grid.onRender(this.grid.container, position || null);
            if(this.grid.autoShow){
                this.grid.el.removeClass(['x-hidden','x-hide-' + this.grid.hideMode]);
            }
            if(this.grid.cls){
                this.grid.el.addClass(this.grid.cls);
                delete this.grid.cls;
            }
            if(this.grid.style){
                this.grid.el.applyStyles(this.grid.style);
                delete this.grid.style;
            }
            this.grid.fireEvent("render", this);
            this.grid.afterRender(this.grid.container);
            if(this.grid.hidden){
                this.grid.hide();
            }
            if(this.grid.disabled){
                this.grid.disable();
            }

            this.grid.initStateEvents();
        }
        return this;
    },

    layout : function(){
        if(!this.view.mainBody){
            return; // not rendered
        }
        var g = this.view.grid;
        var c = g.getGridEl(), cm = this.view.cm,
                expandCol = g.autoExpandColumn,
                gv = this;
        if( Ext.isIE && this.grid.originHeight>0) {
            // 此处不知为什么要设高度，暂时屏蔽，以解决http://www.operamasks.org/jira/browse/AOM-259
            // c.setHeight(this.grid.originHeight);
        }
        var csize = c.getSize(true);
        var vw = csize.width;

        if(vw < 20 || csize.height < 20){ // display: none?
            return;
        }

        if(g.autoHeight){
            if( Ext.isIE) {
                this.view.el.dom.style.width = '100%';
                this.view.scroller.dom.style.width = '100%';
                c.dom.style.height = 'auto';
            }
            if (this.view.innerHd) {     
                this.view.innerHd.style.width = (vw) + 'px';     
            }
            this.view.scroller.dom.style.overflow = 'auto';
        }else{
            if( Ext.isIE) {
                this.view.el.setSize('100%', csize.height);
    
                var hdHeight = this.view.mainHd.getHeight();
                var vh = csize.height - (hdHeight);

    
                this.view.scroller.setSize(vw, vh);
                if(this.view.innerHd){
                    this.view.innerHd.style.width = '100%';
                }
            }    
            else {
                this.view.el.setSize(csize.width, csize.height);
    
                var hdHeight = this.view.mainHd.getHeight();
                var vh = csize.height - (hdHeight);
    
                this.view.scroller.setSize(vw, vh);
                if(this.view.innerHd){
                    this.view.innerHd.style.width = (vw)+'px';
                }
            }
        }
        if(this.view.forceFit){
            if(this.view.lastViewWidth != vw){
                this.view.fitColumns(false, false);
                this.view.lastViewWidth = vw;
            }
        }else {
            this.view.autoExpand();
        }
        this.view.onLayout(vw, vh);
    },
    initTemplates: function(){
        this.view.initTemplates.call(this);
        var cm = this.grid.getColumnModel();
        this.view.templates = {
            header : new Ext.Template(
                    '<table border="0" cellspacing="0" cellpadding="0" style="{tstyle};' + (cm.headers.length>1?'table-layout: auto;':'') +'">',
                    '<thead>',
                    '{headers}',
                    '</thead>',
                    "</table>"
                    ),
            hcell : new Ext.Template(
                    '<td ',
                    '{rowspan}',
                    ' {colspan} ',
                    'class="x-grid3-hd x-grid3-cell x-grid3-td-{id}" ',
                    'style="{style}"><div {tooltip} {attr} ',
                    'class="x-grid3-hd-inner x-grid3-hd-{id}" ',
                    'unselectable="on" style="{istyle}">', 
                    this.grid.enableHdMenu ? '<a class="x-grid3-hd-btn" href="#"></a>' : '',
                    '{value}<img class="x-grid3-sort-icon" src="', Ext.BLANK_IMAGE_URL, '" />',
                    "</div></td>"
                    ),
            ghcell : new Ext.Template(
                    '<td ',
                    '{rowspan}',
                    ' {colspan} ',
                    'class="x-grid3-hd" ',
                    'style="border-bottom:1px solid #D0D0D0;{style}"><div {tooltip} {attr} ',
                    'class="x-grid3-hd-inner" ',
                    'unselectable="on" style="{istyle}">', 
                    this.grid.enableHdMenu ? '<a class="x-grid3-hd-btn" href="#"></a>' : '',
                    '{value}<img class="x-grid3-sort-icon" src="', Ext.BLANK_IMAGE_URL, '" />',
                    "</div></td>"
                    )

        };
    },
    
    initWrapTemplates: function(){
    	if(typeof(this.view.templates) == 'undefined'){
    		this.view.initTemplates.call(this.view);
    	}
        this.view.templates.cell  = new Ext.Template(
                    '<td class="x-grid3-col {x-grid3-cell} x-grid3-td-{id} {css}" style="{style}" tabIndex="0" {cellAttr}>',
                    this.grid.selectable?'<div class="{x-grid3-cell-inner} x-grid3-col-{id}" unselectable="off" {attr}>{value}</div>':'<div class="{x-grid3-cell-inner} x-grid3-col-{id}" unselectable="on" {attr}>{value}</div>',
                    "</td>"
                    );
    	this.view.cellSelectorWrap = 'td.x-grid3-cell-wrap';
    },
    
    // private
    getRows : function(){
        return this.view.hasRows() ? Ext.DomQuery.select('.x-grid3-row',this.view.mainBody.dom) : [];
    },
    
    // private
    findCell : function(el){
        if(!el){
            return false;
        }
        return (this.fly(el).findParent(this.cellSelector, 3))||(this.fly(el).findParent(this.cellSelectorWrap, 3));
    },
    
    // private
    getColumnWrap : function(col, isHeader){
    	return this.cm.config[col].wrap;
    },
    
    getColumnData : function(){
        // build a map for all the columns
        var cs = [], cm = this.cm, colCount = cm.getColumnCount();
        for(var i = 0; i < colCount; i++){
            var name = cm.getDataIndex(i);
            cs[i] = {
                name : (typeof name == 'undefined' ? this.ds.fields.get(i).name : name),
                renderer : cm.getRenderer(i),
                id : cm.getColumnId(i),
                style : this.getColumnStyle(i),
                wrap : this.getColumnWrap(i)
            };
        }
        return cs;
    },
    
    doRender : function(cs, rs, ds, startRow, colCount, stripe){
        var ts = this.templates, ct = ts.cell, rt = ts.row, last = colCount-1;
        var tstyle = 'width:'+this.getTotalWidth()+';';
        if(this.grid.rowInitHeight){
            tstyle=tstyle+"height:"+this.grid.rowInitHeight+"px;";
        }
        // buffers
        var buf = [], cb, c, p = {}, rp = {tstyle: tstyle}, r;
        for(var j = 0, len = rs.length; j < len; j++){
            r = rs[j]; cb = [];
            if(typeof(r) === 'undefined') continue;
            var rowIndex = (j+startRow);
            for(var i = 0; i < colCount; i++){
                c = cs[i];
                p.id = c.id;
                p.css = i == 0 ? 'x-grid3-cell-first ' : (i == last ? 'x-grid3-cell-last ' : '');
                p.attr = p.cellAttr = "";
                p.style = c.style;
                p.value = c.renderer(r.data[c.name], p, r, rowIndex, i, ds);
                
                if(p.value == undefined || p.value === "") p.value = "&#160;";
                if(r.dirty && typeof r.modified[c.name] !== 'undefined'){
                    p.css += ' x-grid3-dirty-cell';
                }
                if(c.wrap&&Ext.isIE){
                	p['x-grid3-cell'] = 'x-grid3-cell-wrap';
                	p['x-grid3-cell-inner'] = 'x-grid3-cell-inner-wrap';
                } else {
                	p['x-grid3-cell'] = 'x-grid3-cell';
                	p['x-grid3-cell-inner'] = 'x-grid3-cell-inner';
                }
                cb[cb.length] = ct.apply(p);
            }
            var alt = [];
            if(stripe && ((rowIndex+1) % 2 == 0)){
                alt[0] = "x-grid3-row-alt";
            }
            if(r.dirty){
                alt[1] = " x-grid3-dirty-row";
            }
            rp.cols = colCount;
            if(this.getRowClass){
                alt[2] = this.getRowClass(r, rowIndex, rp, ds);
            }
            rp.alt = alt.join(" ");
            rp.cells = cb.join("");
            buf[buf.length] =  rt.apply(rp);
        }
        return buf.join("");
    },
    
    // private
    updateColumnHidden : function(col, hidden){
        var tw = this.getTotalWidth();

        this.innerHd.firstChild.firstChild.style.width = tw;
        if (!this.merged) {
            this.mainBody.dom.style.width = tw;
        } else {
            this.mainBody.dom.style.width = (this.cm.getTotalWidth() + 1)+'px';
        }

        var cm = this.grid.getColumnModel();
        var hm = cm.headers;
        
        var rowsDom = Ext.query('tr', this.innerHd.firstChild.firstChild);
        var isShowSelectionModel = true;
        if(hm[0] && hm[0][0]){
        	isShowSelectionModel = (hm[0][0].id == "numberer" || hm[0][0].id == "checker"); 
        }
        for (var k = 0; k < hm.length - 1; k++) {
        	var header = hm[k];
        	var rowDom = rowsDom[k];
        	for (var i = 0, j = 0, len = header.length; i < len; i++) {
        		var rm = header[i];

        		var tdDom = rowDom.children[i];
        		if (rm.id == "numberer" || rm.id == "checker") {
        			continue;
        		} else {
        			if (rm.colspan == undefined) {
        				j = j + 1;
        			} else {
        				j = rm.colspan + j;
        			}
        			if (isShowSelectionModel?j >= col: j > col) {
        				if (hidden) {
    						if (tdDom.colSpan == undefined  || tdDom.colSpan == 1) {
    							tdDom.style.display = "none";
    						} else {
    							tdDom.colSpan = tdDom.colSpan - 1;
    						}
        					break;
        				} else {
        					if (tdDom.colSpan == 1 && tdDom.style.display == "none") {
        						tdDom.style.display = "";
        					} else {
        						tdDom.colSpan = tdDom.colSpan + 1;
        					}
        					break;
        				}
        			}
        		}
        	}
        }
        
        
        var display = hidden ? 'none' : '';
        var hd = this.getHeaderCell(col);
        hd.style.display = display;

        var ns = this.getRows();
        for(var i = 0, len = ns.length; i < len; i++){
            ns[i].style.width = tw;
            if(this.merged){
                var cellEl = this.getCell(i, col);
                if(cellEl){
                    cellEl.style.display=display;
                }
            }else{
                ns[i].firstChild.style.width = tw;
                ns[i].firstChild.rows[0].childNodes[col].style.display = display;
            }
        }

        this.onColumnHiddenUpdated(col, hidden, tw);

        delete this.lastViewWidth; // force recalc
        this.layout();
    },
    
    initMethodDelegate: function() {
        var view = this.grid.getView();
        view.renderHeaders = this.renderHeaders.createDelegate(this);
        view.getColumnStyle = this.getColumnStyle.createDelegate(this);
        view.getHeaderCell = this.getHeaderCell.createDelegate(this);
        view.updateSortIcon = this.updateSortIcon.createDelegate(this);
        var cm = this.grid.getColumnModel();
        cm.moveColumn = this.moveColumn.createDelegate(this);
        /*
        view.getColumnWidth = this.getColumnWidth.createDelegate(this);
        view.getTotalWidth = this.getTotalWidth.createDelegate(this);
        */
    },

    moveColumn : function(oldIndex, newIndex){
        var cm = this.grid.getColumnModel();
        var c = cm.config[oldIndex];
        if (this.realCM) {
            var rm1 = this.realCM[oldIndex];
            var rm2 = this.realCM[newIndex];
            if ( (!rm1.rowspan && !rm2.rowspan) || (rm1.rowspan == rm2.rowspan)) {
                cm.config.splice(oldIndex, 1);
                cm.config.splice(newIndex, 0, c);
                cm.dataMap = null;
                this.columnMoved = true;
                cm.fireEvent("columnmoved", cm, oldIndex, newIndex);
                this.columnMoved = false;
            }
        } else {
            cm.config.splice(oldIndex, 1);
            cm.config.splice(newIndex, 0, c);
            cm.dataMap = null;
            this.columnMoved = true;
            cm.fireEvent("columnmoved", cm, oldIndex, newIndex);
            this.columnMoved = false;
        }
    },
    
    renderHeaders : function(){
        var cm = this.grid.getColumnModel();
        var hm = cm.headers;
        var ts = this.view.templates;
        var ct = ts.hcell;
        var tHeaderRow = new Ext.Template(
            '<tr class="x-grid3-hd-row">{cells}</tr>'
        );
        this.realCM = this.processRealColumnModel();
        /*
        for(var i = 0, len = this.realCM.length; i < len; i++){
            var config = cm.config[i];
            rm = this.realCM[i];
            //rm.style = this.getColumnStyle(i, true, rm);
            //rm.id = config ? config.id : rm.id;
            if (config) {
                rm.header = config.header;
            }
        }
        */

        var  rs = [];
        
        var colIndex = 0;
        for(var k = 0; k < hm.length; k++) {
            var header = hm[k];
            var cb = [];
            for(var i = 0, len = header.length; i < len; i++){
                var p = {};
                var rm = header[i];
                p.id = rm.id ? rm.id : i;
                p.value = rm.header || "";
                //p.value = this.findHeaderFromConfig(rm.id, rm.header) || "";
                p.style = rm.style || ""; // this.view.getColumnStyle(i, true, rm);
                //p.style = rm.style || ;
                
                if (this.view.merged && Ext.isIE && 'numberer' === cm.config[i].id && k === 0) {
                        var w = cm.getColumnWidth(i) - 2;
                        p.style += 'width:' + w + 'px;'; 
                } else if (!this.view.merged && Ext.isIE6 && 'numberer' === cm.config[i].id && k === 0) {
                    var w = cm.getColumnWidth(i) - 2;
                    p.style += 'width:' + w + 'px;';
                }
                
                p.tooltip = cm.getColumnTooltip(i);
                if (rm.rowspan) {
                    p.rowspan = 'rowspan=' + rm.rowspan;
                }
                if (rm.colspan && rm.colspan > 1) {
                    var colspan = rm.colspan;
                    /*
                    var w = 0;
                    for (var c = 0; c < colspan; c++) {
                        var subCM = cm.config[colIndex+c];
                        if (subCM) {
                            w += cm.getColumnWidth(colIndex+c);
                        }
                    }
                    */
                    var style = '';
                    //style += 'width:'+w+'px;';
                    
                    var align = rm.align;
                    if(align){
                        style += 'text-align:'+align+';';
                    } else {
                        style += 'text-align:center;';
                    }
                    p.style = style;
                    var headerIndex = 0;
                    for(var s=0; s< i; s++) {
                    	if (header[s].colspan == undefined) {
                    		headerIndex = headerIndex + 1;
                    	} else {
                    		headerIndex = headerIndex + header[s].colspan;
                    	}
                    }
                    if(header[0].id=="numberer" || header[0].id=="checker"){
                    	headerIndex = headerIndex - 1;
                    }
                    var tdColspan = rm.colspan;
                    for(var s=0; s < rm.colspan; s++) {
                    	if(cm.isHidden(headerIndex + s)){
                        	tdColspan = tdColspan - 1;
                        }
                    }
                    p.colspan = 'colspan=' + tdColspan;
                }
                
                if (rm.colspan && rm.colspan > 1) {
	                if (rm.align == 'right'){
	                    //p.istyle = 'padding-right:16px';
	                } else {
	                    delete p.istyle;
	                }
	             } else {
                    if (rm.align == 'left' || rm.align == 'right'){
                        p.istyle = 'text-align:' + rm.align + ';';
                        if(rm.align == 'right') {
                            p.istyle += 'padding-right:16px;';
                        }
                    }else if(cm.headers.length > 1) {
                        p.istyle = 'text-align:center;';
                    }
                }
                if (typeof(rm.id) != typeof(undef)) {
                    cb[cb.length] = ct.apply(p);
                    colIndex++ ;
                } else {
                    cb[cb.length] = ts.ghcell.apply(p);
                }
            }
            rs[rs.length] = tHeaderRow.apply({cells: cb.join("")});
        }

        //var data = ts.header.apply({headers:rs.join("")});
        var data = ts.header.apply({headers:rs.join(""), tstyle:'width:'+this.view.getTotalWidth()+';'});
        
        //document.getElementById("testdata").value=data;
        return data;
    },
    
    processRealColumnModel : function() {
        var cm = this.grid.getColumnModel();
        if (!cm.headers) {
            return cm.config;
        }
        var hm = cm.headers;
        var rows = hm.length;
        var realModels = [];
        var tmp = [];
        for (var i = 0; i < rows; i++) {
            tmp.push([]);
        }
        for (var k = 0; k < rows; k++) {
            var header = hm[k];
            for(var i = 0, len = header.length; i < len; i++){
                var p = header[i];
                
                var position = this.pushInto(tmp[k], p);
                
                if (p.rowspan && p.rowspan > 0) {
                    for (var r = 1; r < p.rowspan; r++) {
                        tmp[k + r][position] = p;
                    }
                }
                
                if (p.colspan && p.colspan > 0) {
                    for (var c = 0; c < p.colspan - 1; c++) {
                        position = this.pushInto(tmp[k], p);
                        if (p.rowspan && p.rowspan > 0) {
                            for (var r = 1; r < p.rowspan; r++) {
                                tmp[k + r][position] = p;
                            }
                        }
                    }
                }
            }
        }
        
        for (var i = 0; i < tmp[tmp.length-1].length; i++) {
            realModels.push(tmp[tmp.length-1][i]);
        }

        delete tmp;
        
        for(var i = 0, len = realModels.length; i < len; i++){
            var config = cm.config[i];
            rm = realModels[i];
            rm.style = this.getColumnStyle(i, true, rm);
            rm.id = config ? config.id : rm.id;
            if (config) {
                if (this.columnMoved) {
                    rm.header = config.header;
                } else {
                    config.header = rm.header;
                }

            }
        }
        return realModels;
    },
    
    pushInto : function(arrayObj, obj) {
        for (var i = 0; i < arrayObj.length; i++) {
            if (!arrayObj[i]) {
                arrayObj[i] = obj;
                return i;
            }
        }
        arrayObj.push(obj);
        return arrayObj.length - 1;
    },

    getColumnStyle : function(col, isHeader, realModel){
        var cm = this.grid.getColumnModel();
        var view = this.grid.getView();
        var style = !isHeader ? (cm.config[col].css || '') : '';
        if (Ext.isIE) {
            var w = cm.getColumnWidth(col);
            //w = isHeader ? w : w + 2;
	        if(this.view.merged){
            	w = w - 2;
            }
            style += 'width:'+w+'px;';
        } else {
            style += 'width:'+this.view.getColumnWidth(col)+';';
        }
        if(this.grid.selectable){
            style += '-moz-user-select:text;';
        }
        if(cm.isHidden(col)){
            style += 'display:none;';
        }
        var align = cm.config[col].align;
        if (realModel && realModel.align) {
            align = realModel.align;
        }
        if (align) {
            style += 'text-align:'+align+';';
        } else if(col > 0){
            if(cm.headers.length > 1){
                style += 'text-align:center;';
            }
        }
        return style;
    },
    
    getHeaderCell : function(index){
        var view = this.grid.getView();
        //modified by xuxinjie@apusic.com
        //in order to get correct header column in multi-header grid, modify getHeaderCell function here
        var hds = view.mainHd.select('.x-grid3-cell');
        var hdDom = hds.item(index).dom;
        var hdItem = view.mainHd.select('.x-grid3-td-' + index).item(0);
        return hdItem ? hdItem.dom : hdDom ;
    },
    
    updateSortIcon : function(col, dir){
        var sc = this.view.sortClasses;
        var hds = this.view.mainHd.select('.x-grid3-cell').removeClass(sc);
        //modified by xuxinjie@apusic.com
        //in order to get correct header column in multi-header grid, modify getHeaderCell function here
        //hds.item(col).addClass(sc[dir == "DESC" ? 1 : 0]);
        this.view.mainHd.select('.x-grid3-td-' + col).item(0).addClass(sc[dir == "DESC" ? 1 : 0]);
    },
    
    
    onColumnresize : function(col, width){
        var cm = this.grid.getColumnModel();
        this.grid.reconfigure(this.grid.store,cm);
    },
    
    beforeColMenuShow : function(){
		this.colMenu.columnHeight = Ext.getBody().dom.clientHeight ? Ext.getBody().dom.clientHeight : 300;
        var cm = this.cm,  colCount = cm.getColumnCount();
        this.colMenu.removeAll();
        
        if ( !this.colMenu.keyNav ) {
            this.colMenu.keyNav = new Ext.menu.MenuNav( this );
        }
        
        if ( this.colMenu.plain ) {
            this.colMenu.el.addClass("x-menu-plain");
        }
        
        if ( this.colMenu.cls ) {
            this.colMenu.el.addClass( this.cls );
        }
		
		if(!this.colMenu.focusEl){
        this.colMenu.focusEl = this.colMenu.el.createChild({
            cls: "x-menu-focus",
            href: "#",
            onclick: "return false;",
            tabIndex:"-1",
            tag: "a"
        });
        }
        
        this.colMenu.el.setStyle({
            'background': '',
            'margin': '0',
            'padding': '0'
        });
        
        if(this.colMenu.containerEl){
        	this.colMenu.containerEl.remove();
        }
        this.colMenu.containerEl = this.colMenu.el.createChild({
            cls: "x-column-menu",
            tag: "div"
        });
        
        if(this.colMenu.ul){
        	this.colMenu.ul.remove();
        }


		var columnEl = null;
        var ul = null;
        var li = null;
        
        for(var i = 0; i < colCount; i++){
            if(cm.config[i].fixed !== true && cm.config[i].hideable !== false){
            if(this.merged){
                    if(this.grid.mergedColumnIds&&this.grid.mergedColumnIds.length>0){
                        if(this.grid.mergedColumnIds.indexOf(cm.getColumnId(i)) !== -1){
                            continue;
                        }
                    }
            }
            if ( ul == null || ul.getHeight() >= this.colMenu.columnHeight ) {
                columnEl = this.colMenu.containerEl.createChild({
                    cls: "x-menu-list",
                    tag: "div"
                });

                ul = columnEl.createChild({
                    tag: "ul"
                });
                
                ul.on("click", this.colMenu.onClick, this.colMenu);
                ul.on("mouseover", this.colMenu.onMouseOver, this.colMenu);
                ul.on("mouseout", this.colMenu.onMouseOut, this.colMenu);
            }
            
            li = document.createElement("li");
            li.className = "x-menu-list-item";
            
            ul.dom.appendChild( li );
            
            var item = new Ext.menu.CheckItem({
                    id: "col-"+cm.getColumnId(i),
                    text: cm.getColumnHeader(i),
                    checked: !cm.isHidden(i),
                    hideOnClick:false,
                    disabled: cm.config[i].hideable === false
                });
            this.colMenu.items.add(item);
            
            item.render(li, this.colMenu);
            }
        }
        if(this.colMenu.containerEl.child('.x-menu-list:last')){
        	this.colMenu.containerEl.child('.x-menu-list:last').setHeight(this.colMenu.containerEl.child('.x-menu-list:first').getComputedHeight() );
        }
        this.colMenu.el.setStyle({
        	'width':''
        });
    },
    initElements : function(){
        var E = Ext.Element;

        var el = this.view.grid.getGridEl().dom.firstChild;
        var cs = el.childNodes;

        this.view.el = new E(el);

        this.view.mainWrap = new E(cs[0]);
        this.view.mainHd = new E(this.view.mainWrap.dom.firstChild);

        if(this.view.grid.hideHeaders){
            this.view.mainHd.setDisplayed(false);
        }

        this.view.innerHd = this.view.mainHd.dom.firstChild;
        this.view.scroller = new E(this.view.mainWrap.dom.childNodes[1]);
        if(this.view.forceFit){
            this.view.scroller.setStyle('overflow-x', 'hidden');
        }
        this.view.mainBody = new E(this.view.scroller.dom.firstChild);

        this.view.focusEl = new E(this.view.scroller.dom.childNodes[1]);
        this.view.focusEl.swallowEvent("click", true);

        this.view.resizeMarker = new E(cs[1]);
        this.view.resizeProxy = new E(cs[2]);
    }
});

Ext.ux.plugins.PasswordColumnRenderer = function(v, p, record){
    var pass = "";
    for(var i=0; i<v.length; i++) {
        pass += "●";
    }
    return pass;
}

Ext.ux.plugins.CheckColumnRenderer = function(v, p, record){ 
    p.css += ' x-grid3-check-col-td';  
    return '<div class="x-grid3-check-col'+((v==='true'||v===true)?'-on':'')+' x-grid3-cc-'+this.id+'">&#160;</div>'; 
};
 
Ext.ux.plugins.CheckColumn = function(config){
    Ext.apply(this, config);
}

Ext.ux.plugins.CheckColumn.prototype ={
    init : function(grid){ 
        this.grid = grid; 
        this.grid.on('render', function(){ 
            var view = this.grid.getView(); 
               view.mainBody.on('mousedown', this.onMouseDown, this); 
            }, this); 
    }, 
    
    onMouseDown : function(e, t){ 
        if(t.className && t.className.indexOf('x-grid3-cc-') != -1){ 
            //e.stopEvent();
            if(this.grid instanceof Ext.grid.EditorGridPanel) {
	            var index = this.grid.getView().findRowIndex(t); 
	            var record = this.grid.store.getAt(index);
	            var colId = t.className.substring(t.className.indexOf('x-grid3-cc-')+'x-grid3-cc-'.length);
	            this.dataIndex = this.grid.getColumnModel().getColumnById(colId).dataIndex;
	            record.set(this.dataIndex, (record.data[this.dataIndex]==='false'||record.data[this.dataIndex]===false)?true:false);
	        } 
        }
    }
};

if (!window.OM) {window.OM = {};}
window.OM.grid = {
	escapeColumn : function(val) {
		return Ext.util.Format.htmlEncode(val);
	},
	wrap :function(val) {
		if(typeof(val) == 'string'){
			return val.replace(/\n/ig, "<br/>");	
		}
	},
	innerValueAutoMerge: function(mergedColumns){
        var rowCount = this.getStore().getCount();
        var columnCount = this.getColumnModel().getColumnCount();
        var rowspans = new Array();
        for(var i=0,m=rowCount;i<m;i++){
            var currentRowspan = new Array();
            for(var j=0,n=columnCount;j<n;j++){
                currentRowspan.push(0);
            }
            rowspans.push(currentRowspan);
        }
        
        var getCellValue = function(grid, store, i, dataIndex){
            return store.getAt(i).get(dataIndex);
        };
        
        var recursionMerge = function(grid, store, dataIndexes, rowspans, mergeColumnIndex, sameStart, processRows){
            var dataIndex = dataIndexes[mergeColumnIndex];
            var oldValue = null;
            for(var i=sameStart,n=processRows;i<=n;i++){
                if (i < n) {
                    var currentValue = null;
                    currentValue = getCellValue(grid, store, i, dataIndex);
                    if (oldValue != null && currentValue != oldValue) {
                        if (mergeColumnIndex + 1 < dataIndexes.length) {
                            recursionMerge(grid, store, dataIndexes, rowspans, mergeColumnIndex + 1, sameStart, i);
                        }
                        sameStart = i;
                    }
                    rowspans[sameStart][grid.getColumnModel().findColumnIndex(dataIndexes[mergeColumnIndex])]++;
                    oldValue = currentValue;
                } else {
                    if (mergeColumnIndex + 1 < dataIndexes.length) {
                        recursionMerge(grid, store, dataIndexes, rowspans, mergeColumnIndex + 1, sameStart, processRows);
                    }
                }
            }
        };
        
        var mergeColumnIndex = 0;
        var sameStart = 0;
        var processRows = rowCount;
        recursionMerge(this, this.getStore(), mergedColumns, rowspans, mergeColumnIndex, sameStart, processRows);
        

        
        for(var i=0,m=rowCount;i<m;i++){
            for(var j=0,n=columnCount;j<n;j++){
                var currentRowspan = rowspans[i][j];
                if(currentRowspan > 1){
                    /*
                    if(typeof(this.mergedColumnIds) == 'undefined'){
                        this.mergedColumnIds = new Array();
                    }
                    this.mergedColumnIds.push(this.getColumnModel().getColumnId(j));
                    */
                    var targetCell = this.getView().mainBody.select('.x-grid3-row').item(i).select('.x-grid3-td-'+(j)).first(); 
                    if(targetCell){
                        targetCell.addClass('x-grid3-merged-cell');
                        targetCell.dom.rowSpan = currentRowspan;
                        targetCell.child('.x-grid3-cell-inner').setHeight(targetCell.getHeight(true));
                        //targetCell.child('.x-grid3-cell-inner').dom.style.lineHeight = (targetCell.child('.x-grid3-cell-inner').getHeight() - 2 * (currentRowspan - 1)) + "px";
                        if(targetCell.getHeight(true) > 6){
                            targetCell.child('.x-grid3-cell-inner').setStyle('line-height',targetCell.getHeight(true)-6+'px');
                        }
                        for(var k=1,o=currentRowspan;k<o;k++){
                            var cellToRemove = this.getView().mainBody.select('.x-grid3-row').item(i+k).select('.x-grid3-td-'+(j)).first(); 
                            if(cellToRemove){
                                cellToRemove.remove();
                            }
                        }
                    }   
                }
            }
        }
    },
    
    valueAutoMerge: function(grid, mergedColumns){
        grid.getStore().on('load', function(){OM.grid.innerValueAutoMerge.apply(grid,[mergedColumns]);}, this , {single:true});
        grid.getView().on('refresh', function(){OM.grid.innerValueAutoMerge.apply(grid,[mergedColumns]);}, this);
    },
    innerFreeMerge: function(rowStart, columnStart, rowEnd, columnEnd, label){
        if(this.getView().merged){
            if(this.getColumnModel().getColumnById('numberer')) {
                columnStart += 1;
                columnEnd += 1;
            }
            var store = this.getStore();
            var columnModel = this.getColumnModel();
            if(rowEnd >= store.getCount()){
                rowEnd = store.getCount()-1;
            }
            if(columnEnd >= columnModel.getColumnCount()){
                columnEnd = columnModel.getColumnCount()-1;
            }
            var rows = this.getView().mainBody.select('.x-grid3-row');
            if(rowStart <= rows.getCount()){
                var startRow = rows.item(rowStart);
                var tds = startRow.select('.x-grid3-td-'+(columnStart));
                if(tds){
                    if(typeof(this.mergedColumnIds) == 'undefined'){
                        this.mergedColumnIds = new Array();
                    }
                    for(var i=columnStart,n=columnEnd;i<=n;i++){
                        this.mergedColumnIds.push(this.getColumnModel().getColumnId(i));
                    }
                    var targetCell = tds.first();
                    var rowspan = rowEnd-rowStart+1;
                    var columnspan = columnEnd-columnStart+1;
                    targetCell.addClass('x-grid3-merged-cell');
                    targetCell.dom.rowSpan = rowspan;
                    targetCell.dom.colSpan = columnspan;
                    targetCell.dom.style.width="auto";
                    if(label.length > 0){
                        //targetCell.update('<div class="x-grid3-cell-inner" unselectable="on">' + label+ '</div>');
                        targetCell.child('.x-grid3-cell-inner').dom.innerHTML = label;
                    }
                    targetCell.child('.x-grid3-cell-inner').setHeight(targetCell.getHeight(true));
                    //targetCell.child('.x-grid3-cell-inner').dom.style.lineHeight = (targetCell.child('.x-grid3-cell-inner').getHeight() - 2 * rowspan + 3) + "px";
                    if(targetCell.getHeight(true) > 6){
                        targetCell.child('.x-grid3-cell-inner').setStyle('line-height',targetCell.getHeight(true)-6+'px');
                    }
                    for(var i=rowStart,m=rowEnd;i<=m;i++){
                        for(var j=columnStart,n=columnEnd;j<=n;j++){
                            if(i===rowStart&&j===columnStart){
                                continue;
                            }
                            var cellToRemove = rows.item(i).select('.x-grid3-td-'+(j)).first(); 
                            if(cellToRemove){
                                cellToRemove.remove();
                            }
                        }
                    }
                }
            }
        }
    },
    freeMerge: function(grid, rowStart, columnStart, rowEnd, columnEnd, label){
        grid.getStore().on('load', function(){OM.grid.innerFreeMerge.apply(grid,[rowStart,columnStart, rowEnd, columnEnd, label]);}, this , {single:true});
        grid.getView().on('refresh', function(){OM.grid.innerFreeMerge.apply(grid,[rowStart,columnStart, rowEnd, columnEnd, label]);}, this);
    },
    fillback: function(grid, row, field, value){
        var gridStore = grid.getStore();
        var r = gridStore.getAt(row);
        if(r){
            r.set(field, value);
        }
    }
};

