if (!window.OM) {
	var OM = {};
} 

OM.SwfUpload = {
	i18n : function(){}, 
	
	fileQueueError : function(file, errorCode, message)  {
	    if (OM.SwfUpload.execMethod(this.customSettings.om_queued_error, this, [file, errorCode, message]))
	       return;
	
		switch (errorCode) {
			case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
				alert(String.format(this.customSettings.om_queueLimitMessage || OM.SwfUpload.i18nMessage.queueLimitExceeded, message));
				return;
			case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
				alert(this.customSettings.om_fileSizeLimitMessage || OM.SwfUpload.i18nMessage.fileExceedSizeLimit);
				return;
			case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
				alert(this.customSettings.om_zeroByteFileMessage || OM.SwfUpload.i18nMessage.zeroByteFile);
				return;
			case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
				alert(this.customSettings.om_invalidFileTypeMessage || OM.SwfUpload.i18nMessage.invalidFileType);
				return;
			default:
				alert(OM.SwfUpload.i18nMessage.defaultUploadError);
		}
	},

	uploadError : function(file, errorCode, message) {
	    if (OM.SwfUpload.execMethod(this.customSettings.om_upload_error, this, [file, errorCode, message]))
	       return;
	
		// Handle this error separately because we don't want to create a OM.SwfUpload.FileProgress element for it.
	    var errorMsg;
		switch (errorCode) {
			case SWFUpload.UPLOAD_ERROR.MISSING_UPLOAD_URL:
				alert(OM.SwfUpload.i18nMessage.missingUploadUrl);
				return;
			case SWFUpload.UPLOAD_ERROR.UPLOAD_LIMIT_EXCEEDED:
				alert(OM.SwfUpload.i18nMessage.uploadLimitExceeded);
			case SWFUpload.UPLOAD_ERROR.FILE_CANCELLED:
			case SWFUpload.UPLOAD_ERROR.UPLOAD_STOPPED:
			case SWFUpload.UPLOAD_ERROR.FILE_VALIDATION_FAILED:
			case SWFUpload.UPLOAD_ERROR.SPECIFIED_FILE_ID_NOT_FOUND:
				return;
            case SWFUpload.UPLOAD_ERROR.HTTP_ERROR:
                errorMsg = OM.SwfUpload.i18nMessage.httpError;
                break;
            case SWFUpload.UPLOAD_ERROR.IO_ERROR:
                errorMsg = OM.SwfUpload.i18nMessage.serverIoError;
                break;
            case SWFUpload.UPLOAD_ERROR.SECURITY_ERROR:
                errorMsg = OM.SwfUpload.i18nMessage.securityError;
                break;
            case SWFUpload.UPLOAD_ERROR.UPLOAD_FAILED:
                errorMsg = OM.SwfUpload.i18nMessage.uploadFailed;
                break;
            default:
                errorMsg = OM.SwfUpload.i18nMessage.uploadFailed; 
		}

		if (this.customSettings.om_show_progress !== false) {
		    var alias = OM.SwfUpload.FileProgress;
		    alias.create(file, this);
            alias.setError(file.id);
            alias.setStatus(file.id, errorMsg);
		} else {
		    alert(errorMsg);  
		}
	}, 

	uploadProgress : function(file, bytesLoaded, bytesTotal) {
	    if (OM.SwfUpload.execMethod(this.customSettings.om_progress, this, [file, bytesLoaded, bytesTotal]))
           return;
	
		if (this.customSettings.om_show_progress !== false) {
		  var percent = Math.ceil((bytesLoaded / bytesTotal) * 100);
		  var alias = OM.SwfUpload.FileProgress;
          alias.create(file, this);
		  alias.setProgress(file.id, percent);
		  alias.setStatus(file.id, OM.SwfUpload.i18nMessage.uploading + "(" + percent +"%)");
		}		
	}, 

	uploadSuccess : function(file, serverData, response) {
	    if (OM.SwfUpload.execMethod(this.customSettings.om_success, this, [file, serverData, response]))
           return;
	
	    if (this.customSettings.om_show_progress !== false) {
	        var alias = OM.SwfUpload.FileProgress;
            alias.create(file, this);
            alias.setComplete(file.id);
            alias.setStatus(file.id, OM.SwfUpload.i18nMessage.complete);
		}
	}, 

	uploadComplete : function(file) {
       if (OM.SwfUpload.execMethod(this.customSettings.om_complete, this, [file]))
           return;
	
        if (file.filestatus === SWFUpload.FILE_STATUS.COMPLETE) {
            this.queueSettings.queue_upload_count++;
        }
        
        if (!(file.filestatus === SWFUpload.FILE_STATUS.QUEUED)) {
            var stats = this.getStats();
            if (stats.files_queued > 0 && this.queueSettings.queue_cancelled_flag === false) {
                this.startUpload();
            } else if (this.queueSettings.queue_cancelled_flag === false) {
                this.settings.queue_complete_handler && this.queueEvent("queue_complete_handler", [this.queueSettings.queue_upload_count]);
                this.queueSettings.queue_upload_count = 0;
            } else {
                this.queueSettings.queue_cancelled_flag = false;
                this.queueSettings.queue_upload_count = 0;
            }
        }
	}, 
	
	fileQueued : function(file) {
	    if (OM.SwfUpload.execMethod(this.customSettings.om_queued, this, [file]))
           return;
        
        if (this.customSettings.om_show_progress !== false) {
            var alias = OM.SwfUpload.FileProgress;
            alias.create(file, this);
            alias.setProgress(file.id, 0);
            alias.setStatus(file.id, OM.SwfUpload.i18nMessage.ready);
        }
	},
	
	fileDialogComplete : function(selectedFiles, queuedFiles, totalQueuedFiles) {
	   if (OM.SwfUpload.execMethod(this.customSettings.om_dialog_complete, this, [selectedFiles, queuedFiles, totalQueuedFiles]))
           return;
	
	   if (queuedFiles && this.customSettings.om_autoUpload) {
	       this.startUpload();
	   }
	}, 
	
	uploadStart : function(file) {
        return !(this.queueSettings.queue_cancelled_flag = OM.SwfUpload.execMethod(this.customSettings.om_upload_started_handler, this, [file]));
	},
	
	execMethod : function(func, owner, argus) {
	   return (typeof func === 'function') && (func.apply(owner, argus) === false);
	}
}

OM.SwfUpload.i18n.prototype = {
		// error message
		queueLimitExceeded : "You have attempted to queue too many files. You may select {0} file(s).",
		fileExceedSizeLimit : "The file you selected is too big.",
		zeroByteFile : "The file you selected is empty.  Please select another file.",
		invalidFileType: "The file you choose is not an allowed file type.", 
		defaultUploadError : "An error occurred in the upload. Try again later.", 
		missingUploadUrl : "There was a configuration error.  You will not be able to upload files at this time.",
		uploadLimitExceeded : "It's not allow to upload so many files.",
		fileRejectedError: "There was a problem with the upload.\nThe server did not accept it.",
		
		// status message 
		httpError : "Update error!",
		uploadFailed : "Update failed!",
		serverIoError : "Server (IO) Error",
		securityError : "Security Error",
		fileCancelled : "Upload Cannelled",
		uploadStopped: "Upload Stopped", 
		uploading : "Uploading",
		ready: "Ready",
		complete : "Complete",
		fileRejected: "File rejected."
}

OM.SwfUpload.i18nMessage = new OM.SwfUpload.i18n();

OM.SwfUpload.FileProgress = function() {
     var tackleMsg = function(file) {
        var byteSize = Math.round(file.size / 1024 * 100) * .01;
        var suffix = 'KB', fileName;
        if (byteSize > 1000) {
            byteSize = Math.round(byteSize *.001 * 100) * .01;
            suffix = 'MB';
        }
        var sizeParts = byteSize.toString().split('.');
        if (sizeParts.length > 1) {
            byteSize = sizeParts[0] + '.' + sizeParts[1].substr(0,2);
        } else {
            byteSize = sizeParts[0];
        }
        if (file.name.length > 17) {
            fileName = file.name.substr(0,17) + '...';
        } else {
            fileName = file.name;
        }
        return fileName + "(" + byteSize + suffix + ")";
    }

    return {
        create : function(file, uploadInstance) {
	        var progressItem = document.getElementById(file.id);
		    if (!progressItem) {
		        progressItem = document.createElement("div");
		        progressItem.className = "om-swfUpload-progressWapper";
		        progressItem.id = file.id;
		    
		        var progressContainer = document.createElement("div");
		        progressContainer.className = "om-swfUpload-progressContainer";
		
		        var cancelOuter = document.createElement("div");
		        cancelOuter.className = "om-swfUpload-progressCancel";
		        var cancelHref = document.createElement("a");
		        var cancelImg = document.createElement("img");
		        cancelHref.href = "javascript:" + uploadInstance.customSettings.om_jsvar + ".cancelUpload('" + file.id + "', false);";
		        cancelImg.src = uploadInstance.customSettings.om_cancel_image;
		        cancelHref.appendChild(cancelImg);
		        cancelOuter.appendChild(cancelHref);
		
		        var fileName = document.createElement("span");
		        fileName.className = "om-swfUpload-progressName";
		        fileName.appendChild(document.createTextNode(tackleMsg(file)));
		        
		        var status = document.createElement("span");
		        status.className = "om-swfUpload-progressBarStatus";
		
		        var percentOuter = document.createElement("div");
		        percentOuter.className = "om-swfUpload-progressBar";
		        
		        var percentInProgress = document.createElement("div");
		        percentInProgress.className = "om-swfUpload-progressBarInProgress";
		        
		        percentOuter.appendChild(percentInProgress);
		        
		        progressContainer.appendChild(cancelOuter);
		        progressContainer.appendChild(fileName);
		        progressContainer.appendChild(status);
		        progressContainer.appendChild(percentOuter);
		        
		        progressItem.appendChild(progressContainer);
		
		        document.getElementById(uploadInstance.customSettings.om_progress_target).appendChild(progressItem);
		    }
		},
	    
	    setProgress : function (fileId, percentage) {
	        var target = document.getElementById(fileId);
	        target && (target.childNodes[0].childNodes[3].childNodes[0].style.width = percentage + "%");
	    },
	    
	    setComplete : function (fileId) {
	          setTimeout(function() {
	               OM.SwfUpload.FileProgress.disappear(fileId);
	          }, 2000);
	    },
	    
	    setError : function (fileId) {
	        var target = document.getElementById(fileId);
	        target && (target.childNodes[0].className = "om-swfUpload-progressContainer om-swfUpload-progressError");
	    },
	    
	    setStatus : function (fileId, status) {
	        var target = document.getElementById(fileId);
	        target && (target.childNodes[0].childNodes[2].innerHTML = "- " + status);
	    }, 
	    
	   disappear : function (fileId, animat) {
	        if(animat === false) {
		       var target = document.getElementById(fileId);
		       return target && target.getParentNode().removeChild(target);
		    }
            Ext.get(fileId) && Ext.get(fileId).fadeOut({
               useDisplay: false,
               remove: true
            });
	    }
	}
}();